

<?php $__env->startSection('content'); ?>
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Create New 22CR Item</h2>

    <form action="<?php echo e(route('twenty_two_cr.store')); ?>" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        <?php echo csrf_field(); ?>

        <?php
        $titles = [
            "Performing successfully under physical stress",
            "Performing successfully under emotional stress",
            "Knowing the job",
            "Applying his knowledge",
            "Telling the truth",
            "Acting Honestly",
            "Admitting mistakes",
            "Accepting criticism",
            "Learning from experience",
            "Assuming responsibility",
            "Taking action on his own",
            "Ensuring assigned tasks understood",
            "Ensuring supervision and completion of tasks",
            "Complying with rules and orders even though he/she disagrees",
            "Supporting superiors and associates even though he/she disagrees",
            "Expressing self clearly Orally",
            "Expressing self clearly in Writing",
            "Making effort to co-operate and work as team member...",
            "Maintaining high standards of appearance and hygiene...",
            "Maintaining good personal habits and manners",
            "Delegating tasks to others",
            "Maintaining and increasing team performance"
        ];
        ?>

        <div class="mb-4">
            <label for="title" class="block text-gray-700 font-semibold mb-2">Title</label>
            <select name="title" id="title" class="w-full p-3 border border-gray-300 rounded" required>
                <option value="">Select Title</option>
                <?php $__currentLoopData = $titles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($title); ?>"><?php echo e($title); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-4">
            <label for="phase" class="block text-gray-700 font-semibold mb-2">Phase</label>
            <select name="phase" id="phase" class="w-full p-3 border border-gray-300 rounded" required>
                <option value="">Select Phase</option>
                <?php $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($item->name); ?>"><?php echo e($item->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-4">
            <label for="weight" class="block text-gray-700 font-semibold mb-2">Weight</label>
            <input type="number" step="0.01" name="weight" id="weight" class="w-full p-3 border border-gray-300 rounded" required>
        </div>

        <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">
            Create Record
        </button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\22cr\create.blade.php ENDPATH**/ ?>