<!DOCTYPE html>
<html>
<head>
    <title>22CR Report</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            margin: 50px 30px;
            color: #333;
        }

        header, footer {
            position: fixed;
            left: 0;
            right: 0;
            color: #555;
            text-align: center;
            font-size: 14px;
        }

        header {
            top: -30px;
        }

        footer {
            bottom: -30px;
        }

        .restricted {
            color: rgb(0, 0, 0);
            font-weight: bold;
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 30px;
        }

        th, td {
            padding: 8px;
            border: 1px solid #ccc;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

    </style>
</head>
<body>

    <!-- Header -->
    <header>
       
        <div class="restricted">RESTRICTED</div>
    </header>

    <!-- Footer -->
    <footer>
        <div class="restricted">RESTRICTED</div>
    </footer>

    <!-- Main content -->
    <h2>22CR Cadets Assessment Report</h2>

    <div style="margin-bottom: 10px; text-align: center;">

        <strong>BN:</strong> <?php echo e($bn ?? '-'); ?> &nbsp; | &nbsp;
        <strong>COY:</strong> <?php echo e($coys ?? '-'); ?> &nbsp; | &nbsp;
        <strong>PL:</strong> <?php echo e($platoon ?? '-'); ?>

    </div>

    <table>
        <thead>
            <tr>
                <th>SN</th>
                <th>Army Number</th>
                <th>Rank</th>
                <th>Cadet Name</th>
                
                <th>22CR Score</th>
            </tr>
        </thead>
        <tbody>
            <?php $cadetCounter = 1; ?>
            <?php $__currentLoopData = $assessments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $armyNumber => $armyAssessments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $armyAssessments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assessment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <?php if($index === 0): ?>
                            <td rowspan="<?php echo e(count($armyAssessments)); ?>"><?php echo e($cadetCounter); ?></td>
                            <td rowspan="<?php echo e(count($armyAssessments)); ?>"><?php echo e($armyNumber); ?></td>
                            <td rowspan="<?php echo e(count($armyAssessments)); ?>">O/CDT</td>
                            <td rowspan="<?php echo e(count($armyAssessments)); ?>"><?php echo e($assessment->name); ?></td>
                            <?php $cadetCounter++; ?>
                        <?php endif; ?>
                 
                        <td>
                            <?php
                                $totalCRES = 0;
                                foreach($assessment->assessmentDetails as $detail) {
                                    $f = $detail->f1 + $detail->f2 + $detail->f3 + $detail->f4 + $detail->f5;
                                    $fx = ($detail->f1 * 1) + ($detail->f2 * 2) + ($detail->f3 * 3) +
                                          ($detail->f4 * 4) + ($detail->f5 * 5);
                                    if ($f > 0) {
                                        $individualCRES = ($fx / $f) * $detail->twentyTwoCR->weight;
                                        $totalCRES += $individualCRES;
                                    }
                                }
                                $score = number_format(($totalCRES / 720) * 20, 2);
                            ?>
                            <?php echo e($score); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\22cr\print.blade.php ENDPATH**/ ?>