

<?php $__env->startSection('title', '22 CR Overview'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="bg-white rounded-lg shadow-md">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-800">22 CR Overview</h3>
            <p class="text-sm text-gray-600 mt-1">View and filter cadet performance by school, course, battalion, company, and platoon.</p>
        </div>

        <!-- Filters Section -->
        <div class="p-6">
            <form method="GET" action="<?php echo e(route('cr.overview')); ?>" class="mb-6">
                <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-6 gap-4 mb-4">
                    <div>
                        <label for="school" class="block text-sm font-medium text-gray-700 mb-1">School</label>
                        <select name="school" id="school" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Schools</option>
                            <?php $__currentLoopData = $schools ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($school); ?>" <?php echo e(request('school') == $school ? 'selected' : ''); ?>><?php echo e($school); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="course" class="block text-sm font-medium text-gray-700 mb-1">Course</label>
                        <select name="course" id="course" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Courses</option>
                            <?php $__currentLoopData = $courses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($course); ?>" <?php echo e(request('course') == $course ? 'selected' : ''); ?>><?php echo e($course); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="bn" class="block text-sm font-medium text-gray-700 mb-1">Battalion</label>
                        <select name="bn" id="bn" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Battalions</option>
                            <?php $__currentLoopData = $bns ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($bn); ?>" <?php echo e(request('bn') == $bn ? 'selected' : ''); ?>><?php echo e($bn); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="coy" class="block text-sm font-medium text-gray-700 mb-1">Company</label>
                        <select name="coy" id="coy" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Companies</option>
                            <?php $__currentLoopData = $coys ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($coy); ?>" <?php echo e(request('coy') == $coy ? 'selected' : ''); ?>><?php echo e($coy); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="pl" class="block text-sm font-medium text-gray-700 mb-1">Platoon</label>
                        <select name="pl" id="pl" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">All Platoons</option>
                            <?php $__currentLoopData = $pls ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($pl); ?>" <?php echo e(request('pl') == $pl ? 'selected' : ''); ?>><?php echo e($pl); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="sort" class="block text-sm font-medium text-gray-700 mb-1">Sort Direction</label>
                        <select name="sort" id="sort" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="default" <?php echo e(request('sort') == 'default' ? 'selected' : ''); ?>>Default</option>
                            <option value="score_asc" <?php echo e(request('sort') == 'score_asc' ? 'selected' : ''); ?>>Score (Low to High)</option>
                            <option value="score_desc" <?php echo e(request('sort') == 'score_desc' ? 'selected' : ''); ?>>Score (High to Low)</option>
                            <option value="name_asc" <?php echo e(request('sort') == 'name_asc' ? 'selected' : ''); ?>>Name (A-Z)</option>
                            <option value="name_desc" <?php echo e(request('sort') == 'name_desc' ? 'selected' : ''); ?>>Name (Z-A)</option>
                        </select>
                    </div>
                </div>
                
                <div class="flex space-x-3">
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition-colors">
                        Apply Filters
                    </button>
                    <a href="<?php echo e(route('cr.overview')); ?>" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2 transition-colors">
                        Reset Filters
                    </a>
                    <a href="<?php echo e(route('cr.mark')); ?>?<?php echo e(http_build_query(request()->query())); ?>" 
                       class="bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-offset-2 transition-colors">
                        Add cr Marks
                    </a>
             <a href="<?php echo e(route('cr.import.form')); ?>?<?php echo e(http_build_query(request()->query())); ?>" 
                       class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-offset-2 transition-colors">
                       Import cr Marks
                    </a>



                </div>
            </form>

            <!-- Results Table -->
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white border border-gray-200">
                    <thead class="bg-gray-800 text-white">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">SN</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Army Number</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Rank</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Cadet Name</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Phase</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">22CR Score</th>
                            <th class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider">Remarks</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $assessments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assessment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700"><?php echo e($index + 1); ?></td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700"><?php echo e($assessment->army_number); ?></td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700"><?php echo e($assessment->rank); ?></td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700"><?php echo e($assessment->name); ?></td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700"><?php echo e($assessment->phase->name ?? 'N/A'); ?></td>
                                <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700 font-semibold">
                                    <?php echo e($assessment->score ? number_format($assessment->score, 2) . '% /15%' : 'N/A'); ?>

                                </td>
                         <td class="px-4 py-3 whitespace-nowrap">
    <span
        class="text-sm font-semibold px-2 py-1 rounded
            <?php echo e($assessment->score >= 8 ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
        <?php echo e($assessment->score !== null ? ($assessment->score >= 8 ? 'PASS' : 'FAIL') : 'NOT MARKED'); ?>

    </span>
</td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="px-4 py-4 text-center text-sm text-gray-500">
                                    No CR assessment records found matching your criteria.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if($assessments->count() > 0): ?>
                <div class="mt-4 text-sm text-gray-600">
                    Showing <?php echo e($assessments->count()); ?> record(s)
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php
function calculateRemarks($score) {
    if (!$score) return '';

    $numericScore = floatval($score);
    
    if ($numericScore >= 97.2) return '9.72 - EXCELLENT';
    if ($numericScore >= 90) return '9.0+ - VERY GOOD';
    if ($numericScore >= 80) return '8.0+ - GOOD';
    if ($numericScore >= 70) return '7.0+ - AVERAGE';
    if ($numericScore >= 60) return '6.0+ - BELOW AVERAGE';
    return 'FAIL';
}
?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\cr\overview.blade.php ENDPATH**/ ?>