

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <h2 class="text-2xl font-bold mb-6">Individual 22 CR</h2>

    <!-- Search Form -->
    <div class="bg-white rounded-lg shadow-lg overflow-hidden mb-8">



        <div class="p-6">
            <form action="<?php echo e(route('cr.assessments.22cr')); ?>" method="GET" class="flex flex-col md:flex-row gap-4">
                <div class="flex-grow">
                    <label for="army_number" class="block text-sm font-medium text-gray-700 mb-1">Army Number</label>
                    <input type="text" name="army_number" id="army_number"
                           class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-blue-500 focus:border-blue-500"
                           placeholder="Enter Army Number"
                           value="<?php echo e(request('army_number')); ?>" required>
                </div>
                <div class="self-end">
                    <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                        Search Records
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Show results only if search was performed -->
    <?php if(request()->has('army_number')): ?>
        <?php if($assessments->count() > 0): ?>
            <!-- Assessment Records Section -->
            <?php $__currentLoopData = $assessments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $armyNumber => $armyAssessments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mb-8 bg-white rounded-lg shadow-lg overflow-hidden">
                <!-- Header section -->
                <div class="bg-blue-600 text-white px-6 py-4">
                    <div class="flex justify-between items-center">
                        <h3 class="text-xl font-semibold">
                            Army Number: <?php echo e($armyNumber); ?>

                            <span class="ml-4">Name: <?php echo e($armyAssessments->first()->name); ?></span>
                        </h3>
                        <span class="text-sm">
                            Total Assessments: <?php echo e($armyAssessments->count()); ?>

                        </span>
                    </div>
                </div>

                <!-- Main assessment table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Phase</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__currentLoopData = $armyAssessments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assessment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!-- Assessment row -->
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap"><?php echo e($assessment->created_at->format('d/m/Y')); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap"><?php echo e($assessment->phase); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <button onclick="viewDetails('<?php echo e($assessment->id); ?>')"
                                            class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">
                                        View Details
                                    </button>
                                </td>
                            </tr>

                            <!-- Details row -->
                            <tr id="details_<?php echo e($assessment->id); ?>" class="hidden">
                                <td colspan="3" class="px-6 py-4">
                                    <div class="grid grid-cols-1 gap-4">
                                        <table class="min-w-full divide-y divide-gray-200">
                                            <thead class="bg-gray-50">
                                                <tr>
                                                    <th class="px-4 py-2 text-left">#</th>
                                                    <th class="px-4 py-2 text-left">Critical Requirement</th>
                                                    <?php $__currentLoopData = ['F1', 'F2', 'F3', 'F4', 'F5']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <th class="px-4 py-2 text-center"><?php echo e($f); ?></th>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <th class="px-4 py-2 text-center">F</th>
                                                    <th class="px-4 py-2 text-center">FX</th>
                                                    <th class="px-4 py-2 text-center">Mean</th>
                                                    <th class="px-4 py-2 text-center">Weight</th>
                                                    <th class="px-4 py-2 text-center">CRES</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $assessment->assessmentDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="px-4 py-2"><?php echo e($detail->twentyTwoCR->id); ?></td>
                                                    <td class="px-4 py-2"><?php echo e($detail->twentyTwoCR->title); ?></td>

                                                    <?php
                                                        $sumF = 0;
                                                        $sumFX = 0;
                                                    ?>

                                                    <?php $__currentLoopData = ['f1', 'f2', 'f3', 'f4', 'f5']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $sumF += $detail->$f;
                                                            $sumFX += $detail->$f * ($index + 1);
                                                        ?>
                                                        <td class="px-4 py-2 text-center">
                                                            <?php if($detail->$f > 0): ?>
                                                                <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded-full text-sm">
                                                                    <?php echo e($detail->$f); ?>

                                                                </span>
                                                            <?php else: ?>
                                                                -
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    <td class="px-4 py-2 text-center font-semibold"><?php echo e($sumF); ?></td>
                                                    <td class="px-4 py-2 text-center"><?php echo e($sumFX); ?></td>
                                                    <td class="px-4 py-2 text-center">
                                                        <?php echo e($sumF > 0 ? number_format($sumFX / $sumF, 2) : '-'); ?>

                                                    </td>
                                                    <td class="px-4 py-2 text-center">
                                                        <?php echo e($detail->twentyTwoCR->weight); ?>

                                                    </td>
                                                    <td class="px-4 py-2 text-center">
                                                        <?php echo e($sumF > 0 ? number_format($sumFX / $sumF * $detail->twentyTwoCR->weight, 2) : '-'); ?>

                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php
                                                $totalCRES = 0;
                                                foreach($assessment->assessmentDetails as $detail) {
                                                    // Calculate individual f and fx
                                                    $f = $detail->f1 + $detail->f2 + $detail->f3 + $detail->f4 + $detail->f5;
                                                    $fx = ($detail->f1 * 1) + ($detail->f2 * 2) + ($detail->f3 * 3) +
                                                          ($detail->f4 * 4) + ($detail->f5 * 5);

                                                    // Calculate individual CRES
                                                    if ($f > 0) {
                                                        $individualCRES = ($fx / $f) * $detail->twentyTwoCR->weight;
                                                        $totalCRES += $individualCRES;
                                                    }
                                                }
                                                ?>

                                                <!-- Total CRES Row -->
                                                <tr class="bg-blue-50 font-bold text-blue-800 border-t-2 border-blue-200">
                                                    <td colspan="<?php echo e(8 + 5); ?>" class="px-4 py-3 text-right">
                                                        Total CRES: <?php echo e(number_format($totalCRES, 2)); ?>

                                                    </td>
                                                </tr>

                                                <!-- 22CR Score Row -->
                                                <tr class="bg-yellow-300 font-bold text-blue-900 border-b-2 border-blue-200">
                                                    <td colspan="<?php echo e(8 + 5); ?>" class="px-4 py-3 text-right">
                                                        22CR Score <?php echo e($assessment->phase); ?>:
                                                        <?php echo e(number_format(($totalCRES / 720) * 20, 2).'%'.' /20%'); ?>

                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <!-- No results found -->
            <div class="bg-white rounded-lg shadow-lg overflow-hidden">
                <div class="p-6 text-center">
                    <div class="text-gray-500 mb-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 mx-auto mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <h3 class="text-xl font-medium text-gray-900 mb-2">No Records Found</h3>
                        <p>No 22 CR records were found for Army Number: <strong><?php echo e(request('army_number')); ?></strong></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function viewDetails(assessmentId) {
    const detailsRow = document.getElementById(`details_${assessmentId}`);
    detailsRow.classList.toggle('hidden');
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\22cr\view.blade.php ENDPATH**/ ?>