<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Database Backup Manager</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .backup-card {
            transition: transform 0.2s;
        }
        .backup-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .loading-spinner {
            display: none;
        }
        .loading-spinner.active {
            display: inline-block;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row mb-4">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <h1 class="mb-0"><i class="bi bi-database"></i> Database Backup Manager</h1>
                    <button class="btn btn-primary" id="createBackupBtn">
                        <span class="spinner-border spinner-border-sm loading-spinner me-2"></span>
                        <i class="bi bi-plus-circle"></i> Create New Backup
                    </button>
                </div>
            </div>
        </div>

        <!-- Alert Messages -->
        <div id="alertContainer"></div>

        <!-- Backups List -->
        <div class="row">
            <div class="col-12">
                <div class="card backup-card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-archive"></i> Available Backups</h5>
                    </div>
                    <div class="card-body">
                        <?php if(count($backups) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Filename</th>
                                        <th>Size</th>
                                        <th>Date</th>
                                        <th class="text-end">Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="backupsTableBody">
                                    <?php $__currentLoopData = $backups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr data-filename="<?php echo e($backup['name']); ?>">
                                        <td>
                                            <i class="bi bi-file-earmark-zip"></i>
                                            <strong><?php echo e($backup['name']); ?></strong>
                                        </td>
                                        <td><?php echo e($backup['size']); ?></td>
                                        <td><?php echo e($backup['date']); ?></td>
                                        <td class="text-end">
                                            <div class="btn-group" role="group">
                                                <a href="<?php echo e(route('backup.download', $backup['name'])); ?>" 
                                                   class="btn btn-sm btn-success">
                                                    <i class="bi bi-download"></i> Download
                                                </a>
                                                <button class="btn btn-sm btn-warning restore-btn" 
                                                        data-filename="<?php echo e($backup['name']); ?>">
                                                    <i class="bi bi-arrow-counterclockwise"></i> Restore
                                                </button>
                                                <button class="btn btn-sm btn-danger delete-btn" 
                                                        data-filename="<?php echo e($backup['name']); ?>">
                                                    <i class="bi bi-trash"></i> Delete
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <?php else: ?>
                        <div class="text-center py-5">
                            <i class="bi bi-inbox display-1 text-muted"></i>
                            <p class="text-muted mt-3">No backups available. Create your first backup!</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // CSRF Token Setup
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        // Show Alert Function
        function showAlert(message, type = 'success') {
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert alert-${type} alert-dismissible fade show`;
            alertDiv.innerHTML = `
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            document.getElementById('alertContainer').appendChild(alertDiv);
            
            setTimeout(() => {
                alertDiv.remove();
            }, 5000);
        }

        // Create Backup
        document.getElementById('createBackupBtn').addEventListener('click', async function() {
            const btn = this;
            const spinner = btn.querySelector('.loading-spinner');
            
            btn.disabled = true;
            spinner.classList.add('active');
            
            try {
                const response = await fetch('<?php echo e(route("backup.create")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken
                    }
                });
                
                const data = await response.json();
                
                if (data.success) {
                    showAlert(data.message, 'success');
                    setTimeout(() => window.location.reload(), 1500);
                } else {
                    showAlert(data.message, 'danger');
                }
            } catch (error) {
                showAlert('An error occurred while creating backup', 'danger');
            } finally {
                btn.disabled = false;
                spinner.classList.remove('active');
            }
        });

        // Delete Backup
        document.querySelectorAll('.delete-btn').forEach(btn => {
            btn.addEventListener('click', async function() {
                const filename = this.dataset.filename;
                
                if (!confirm(`Are you sure you want to delete ${filename}?`)) {
                    return;
                }
                
                try {
                    const response = await fetch(`/backup/delete/${filename}`, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': csrfToken
                        }
                    });
                    
                    const data = await response.json();
                    
                    if (data.success) {
                        showAlert(data.message, 'success');
                        document.querySelector(`tr[data-filename="${filename}"]`).remove();
                    } else {
                        showAlert(data.message, 'danger');
                    }
                } catch (error) {
                    showAlert('An error occurred while deleting backup', 'danger');
                }
            });
        });

        // Restore Backup
        document.querySelectorAll('.restore-btn').forEach(btn => {
            btn.addEventListener('click', async function() {
                const filename = this.dataset.filename;
                
                if (!confirm(`Are you sure you want to restore from ${filename}? This will overwrite your current database!`)) {
                    return;
                }
                
                const btn = this;
                btn.disabled = true;
                
                try {
                    const response = await fetch(`/backup/restore/${filename}`, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': csrfToken
                        }
                    });
                    
                    const data = await response.json();
                    
                    if (data.success) {
                        showAlert(data.message, 'success');
                    } else {
                        showAlert(data.message, 'danger');
                    }
                } catch (error) {
                    showAlert('An error occurred while restoring backup', 'danger');
                } finally {
                    btn.disabled = false;
                }
            });
        });
    </script>
</body>
</html><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\backup\index.blade.php ENDPATH**/ ?>