
<?php $__env->startSection('title', '22 CR Entry'); ?>
<?php $__env->startSection('content'); ?>
    <div class="max-w-4xl mx-auto mt-10 bg-white shadow-lg rounded-lg p-6">
        <h2 class="text-2xl font-bold text-center text-blue-600 mb-6">22 CR Entry</h2>
        
        <!-- Intake Info Banner -->
        <div class="bg-gradient-to-r from-blue-50 to-indigo-50 border-l-4 border-blue-500 p-4 mb-6 rounded-lg shadow-sm">
            <div class="flex items-start">
                <div class="flex-shrink-0">
                    <svg class="h-6 w-6 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <div class="ml-3 flex-1">
                    <h3 class="text-lg font-semibold text-blue-800 mb-2">Intake Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div class="space-y-2">
                            <p class="text-gray-700">
                                <span class="font-medium">Latest Intake:</span> 
                                <span class="text-blue-600 font-bold"><?php echo e($latestIntake ?? 'N/A'); ?></span>
                                <span class="text-gray-500 text-xs ml-2">(Started: <?php echo e($latestIntakeStartDate ?? 'N/A'); ?>)</span>
                            </p>
                            <p class="text-gray-700">
                                <span class="font-medium">Current Phase:</span> 
                                <span class="text-green-600 font-semibold"><?php echo e($currentPhase ?? 'Phase 1'); ?></span>
                            </p>
                        </div>
                        <div class="space-y-2">
                            <p class="text-gray-700">
                                <span class="font-medium">Total Cadets (Latest Intake):</span> 
                                <span class="text-purple-600 font-semibold"><?php echo e($latestIntakeCount ?? '0'); ?></span>
                            </p>
                            <p class="text-gray-700">
                                <span class="font-medium">Intake Duration:</span> 
                                <span class="text-orange-600 font-semibold"><?php echo e($intakeDuration ?? '6 months'); ?></span>
                            </p>
                        </div>
                    </div>
                    
                    <!-- Progress Bar for Current Intake -->
                    <?php if(isset($intakeProgress)): ?>
                    <div class="mt-3">
                        <div class="flex justify-between text-xs text-gray-600 mb-1">
                            <span>Intake Progress</span>
                            <span><?php echo e($intakeProgress); ?>% Complete</span>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-blue-600 h-2 rounded-full" style="width: <?php echo e($intakeProgress); ?>%"></div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Intake History Table -->
        <?php if(isset($intakeHistory) && count($intakeHistory) > 0): ?>
        <div class="mb-6 bg-white rounded-lg border border-gray-200 overflow-hidden">
            <div class="bg-gray-50 px-4 py-3 border-b border-gray-200">
                <h3 class="font-semibold text-gray-700">Intake History</h3>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Intake</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Start Date</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">End Date</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Cadets</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Current Phase</th>
                            <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $intakeHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $intake): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-2 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo e($intake->name); ?></td>
                            <td class="px-4 py-2 whitespace-nowrap text-sm text-gray-500"><?php echo e($intake->start_date ? date('d M Y', strtotime($intake->start_date)) : 'N/A'); ?></td>
                            <td class="px-4 py-2 whitespace-nowrap text-sm text-gray-500"><?php echo e($intake->end_date ? date('d M Y', strtotime($intake->end_date)) : 'N/A'); ?></td>
                            <td class="px-4 py-2 whitespace-nowrap text-sm text-gray-500"><?php echo e($intake->cadets_count ?? '0'); ?></td>
                            <td class="px-4 py-2 whitespace-nowrap text-sm text-gray-500"><?php echo e($intake->current_phase ?? 'Phase 1'); ?></td>
                            <td class="px-4 py-2 whitespace-nowrap">
                                <?php
                                    $now = now();
                                    $start = $intake->start_date ? \Carbon\Carbon::parse($intake->start_date) : null;
                                    $end = $intake->end_date ? \Carbon\Carbon::parse($intake->end_date) : null;
                                ?>
                                <?php if($start && $now < $start): ?>
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">Upcoming</span>
                                <?php elseif($end && $now > $end): ?>
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">Completed</span>
                                <?php elseif($start && $end && $now >= $start && $now <= $end): ?>
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">Active</span>
                                <?php else: ?>
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">Ongoing</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>

        <div id="successMessage" style="display: none; color: green;"></div>
        <div id="errorMessage" style="display: none; color: red;"></div>

        
        <?php if($errors->any()): ?>
            <div class="mb-4 p-4 bg-red-100 text-red-700 rounded-lg">
                <strong>Whoops! Something went wrong.</strong>
                <ul class="mt-2">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>- <?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="mb-4 p-4 bg-red-100 text-red-700 rounded-lg">
                <strong>Error:</strong> <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="mb-4 p-4 bg-green-100 text-green-700 rounded-lg">
                <strong>Success:</strong> <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

     <form id="filterForm" onsubmit="return submitCRAssessment(event)">
            <?php echo csrf_field(); ?>
            <!-- First Grid -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                <div>
                    <label class="block font-semibold">School</label>
                    <select name="school_id" id="school_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                        <option value="">Select School</option>
                        <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($id); ?>" <?php echo e($name === 'BMTS' ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div id="course_container">
                    <label class="block font-semibold">Course</label>
                    <select name="course_id" id="course_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                        <option value="">Select Course</option>
                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($id); ?>" <?php echo e($name === 'O/CDT' ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div id="intake_container">
                    <label class="block font-semibold">Intake</label>
                <select name="intake_id" id="intake_id" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus-border-blue-500" required>
    <option value="">Select Intake</option>
    <?php $__currentLoopData = $intakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($id); ?>" <?php echo e(isset($latestIntakeId) && $latestIntakeId == $id ? 'selected' : ''); ?>><?php echo e($name); ?></option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>
                </div>
            </div>

            <!-- Second Grid -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                <div id="phase_container">
                    <label class="block font-semibold">Phase</label>
                    <select name="choose_phase" id="choose_phase" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                        <option value="">Select Phase</option>
                        <?php $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phaseItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($phaseItem->name); ?>" <?php if($selectedPhase && $selectedPhase == $phaseItem->name): ?> selected <?php endif; ?>><?php echo e($phaseItem->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div id="assessment_type_container">
                    <label class="block font-semibold">Assessment Type</label>
                    <select name="choose_assessment_type" id="choose_assessment_type" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                        <option value="">Select Assessment Type</option>
                        <option value="Character Assessment">Character Assessment</option>
                    </select>
                </div>

                <div id="assessment_group_container" style="display: none;">
                    <label class="block font-semibold">Assessment Group</label>
                    <select name="choose_assessment_group" id="choose_assessment_group" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                        <option value="">Select Assessment Group</option>
                    </select>
                </div>

                <div id="unit_container" style="display: none;">
                    <label class="block font-semibold">Search Army Number <span class="text-red-500">*</span></label>
                    <div class="flex space-x-2">
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm focus:ring focus:ring-blue-300 p-2" id="army_number" name="army_number" placeholder="Enter Army Number">
                        <button type="button" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600 whitespace-nowrap" onclick="searchArmyNumber()">Search</button>
                    </div>
                    <p class="text-xs text-gray-500 mt-1">Latest intake: <?php echo e($latestIntake ?? 'N/A'); ?></p>
                </div>
            </div>

            <div id="unit1_container" style="display: none;" class="grid grid-cols-1 gap-4">
                <!-- Student Info Section -->
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Student Name</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2 bg-gray-100" id="name" name="name" readonly>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Intake</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2 bg-gray-100" id="student_intake" name="student_intake" readonly>
                    </div>
                </div>

                <!-- CR Requirements Table -->
                <div class="overflow-x-auto mb-6">
                    <table class="min-w-full bg-white border border-gray-300">
                        <thead>
                        <tr class="bg-gray-50">
                            <th class="border px-4 py-2">#</th>
                            <th class="border px-4 py-2">Critical Requirements</th>
                            <th class="border px-4 py-2 text-center" colspan="5">Best</th>
                        </tr>
                        <tr class="bg-gray-50">
                            <th colspan="2"></th>
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <th class="border px-4 py-2 text-center"><?php echo e($i); ?></th>
                            <?php endfor; ?>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $twentyTwoCR; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $cr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="border px-4 py-2 text-center"><?php echo e($index+1); ?></td>
                                <td class="border px-4 py-2"><?php echo e($cr->title); ?></td>
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <td class="border px-2 py-2 text-center">
                                        <input type="radio" id="rating_<?php echo e($cr->id); ?>_<?php echo e($i); ?>" name="rating_<?php echo e($cr->id); ?>" value="<?php echo e($i); ?>" class="cr-radio w-5 h-5" onclick="handleRatingClick(this, <?php echo e($cr->id); ?>, <?php echo e($i); ?>)" data-previous-state="unchecked">
                                    </td>
                                <?php endfor; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                    <div class="mt-6 flex justify-center gap-4">
                   <button type="button" onclick="saveCRAssessment()" class="bg-blue-600 text-white px-6 py-3 rounded-lg shadow hover:bg-blue-700 focus:outline-none flex items-center">
                       <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                           <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                       </svg>
                       Save 22 CR Assessment
                   </button>
                    </div>
                </div>
            </div>
        </form>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
        document.getElementById('choose_phase').addEventListener('change', function() {
            const selectedPhase = this.value;
            const form = document.getElementById('filterForm');

            const phaseInput = document.createElement('input');
            phaseInput.type = 'hidden';
            phaseInput.name = 'phase';
            phaseInput.value = selectedPhase;
            form.appendChild(phaseInput);

            form.submit();
        });

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Add these functions to your existing JavaScript
        function updateRating(crId, value) {
            const fValue = value;
            const fInput = document.getElementById(`f${fValue}`);

            for (let i = 1; i <= 5; i++) {
                const oldFInput = document.getElementById(`f${i}`);
                const currentValue = parseInt(oldFInput.value) || 0;
                if (currentValue > 0) {
                    oldFInput.value = currentValue - 1;
                    updateFX(i);
                }
            }

            if (fInput) {
                const currentValue = parseInt(fInput.value) || 0;
                fInput.value = currentValue + 1;
                updateFX(fValue);
            }
        }

        // Add some CSS styles
        const style = document.createElement('style');
        style.textContent = `
    .cr-checkbox {
        accent-color: #2563eb;
        cursor: pointer;
    }
    .cr-checkbox:hover {
        transform: scale(1.1);
    }
`;
        document.head.appendChild(style);

        // Add to your existing JavaScript
/**
 * Configuration object for phase assessment ranges
 */
const ASSESSMENT_CONFIG = {
    'Phase 1': { start: 1, end: 22 },
    'Phase 2': { start: 23, end: 44 },
    'Phase 3': { start: 45, end: 66 }
};

/**
 * Get form element value by ID with validation
 * @param  {string} elementId - The ID of the form element
 * @param  {boolean} required - Whether the field is required
 * @returns  {string|null} The element value or null if not found/empty
 */
function getFormValue(elementId, required = true) {
    const element = document.getElementById(elementId);
    if (!element) {
        console.warn(`Element with ID '${elementId}' not found`);
        return null;
    }
    
    const value = element.value.trim();
    if (required && !value) {
        throw new Error(`${elementId.replace('_', ' ')} is required`);
    }
    
    return value || null;
}

/**
 * Collect assessment ratings for a specific phase
 * @param  {string} phase - The selected phase
 * @returns  {Array} Array of assessment objects
 */
function collectAssessments(phase) {
    const config = ASSESSMENT_CONFIG[phase];
    if (!config) {
        throw new Error(`Invalid phase: ${phase}`);
    }

    const assessments = [];
    let missingRatings = [];

    for (let crId = config.start; crId <= config.end; crId++) {
        const selectedRating = document.querySelector(`input[name="rating_${crId}"]:checked`);
        
        if (selectedRating) {
            const rating = parseInt(selectedRating.value);
            if (isNaN(rating)) {
                console.warn(`Invalid rating value for CR ${crId}: ${selectedRating.value}`);
                continue;
            }
            
            assessments.push({
                cr_id: crId,
                rating: rating
            });
        } else {
            missingRatings.push(crId);
        }
    }

    if (missingRatings.length > 0) {
        console.warn(`Missing ratings for CRs: ${missingRatings.join(', ')}`);
    }

    return assessments;
}

/**
 * Validate form data before submission
 * @param  {Object} formData - The form data to validate
 * @returns  {boolean} True if valid, throws error if invalid
 */
function validateFormData(formData) {
    const requiredFields = ['army_number', 'name', 'school_id', 'course_id', 'intake_id', 'phase', 'assessment_type'];
    
    for (const field of requiredFields) {
        if (!formData[field]) {
            throw new Error(`${field.replace('_', ' ')} is required`);
        }
    }

    if (!formData.assessments || formData.assessments.length === 0) {
        throw new Error('At least one assessment rating is required');
    }

    return true;
}

/**
 * Clear the assessment form
 */
function clearForm() {
    const textInputs = ['army_number', 'name', 'student_intake'];
    textInputs.forEach(id => {
        const element = document.getElementById(id);
        if (element) element.value = '';
    });

    const selects = ['school_id', 'course_id', 'intake_id', 'choose_phase', 'choose_assessment_type', 'choose_assessment_group'];
    selects.forEach(id => {
        const element = document.getElementById(id);
        if (element) element.selectedIndex = 0;
    });

    const radioButtons = document.querySelectorAll('input[type="radio"]');
    radioButtons.forEach(radio => radio.checked = false);
}

/**
 * Show loading state
 */
function setLoadingState(isLoading) {
    const submitButton = document.querySelector('button[onclick*="saveCRAssessment"]') || 
                        document.querySelector('input[onclick*="saveCRAssessment"]');
    
    if (submitButton) {
        submitButton.disabled = isLoading;
        const originalText = submitButton.textContent || submitButton.value;
        
        if (isLoading) {
            submitButton.setAttribute('data-original-text', originalText);
            if (submitButton.textContent !== undefined) {
                submitButton.textContent = 'Saving...';
            } else {
                submitButton.value = 'Saving...';
            }
        } else {
            const originalText = submitButton.getAttribute('data-original-text');
            if (originalText) {
                if (submitButton.textContent !== undefined) {
                    submitButton.textContent = originalText;
                } else {
                    submitButton.value = originalText;
                }
            }
        }
    }
}

/**
 * Handle AJAX errors with detailed messaging
 * @param  {Object} xhr - The XMLHttpRequest object
 */
function handleAjaxError(xhr) {
    console.error('AJAX Error:', xhr);

    let errorMessage = 'Error saving assessment:\n\n';
    
    switch (xhr.status) {
        case 422:
            const errors = xhr.responseJSON?.errors || {};
            errorMessage += 'Validation failed:\n';
            for (const [field, messages] of Object.entries(errors)) {
                const fieldName = field.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase());
                errorMessage += `• ${fieldName}: ${messages.join(', ')}\n`;
            }
            break;
            
        case 401:
            errorMessage += 'Authentication required. Please log in again.';
            break;
            
        case 403:
            errorMessage += 'You do not have permission to perform this action.';
            break;
            
        case 500:
            errorMessage += 'Server error occurred. Please try again later or contact support.';
            break;
            
        case 0:
            errorMessage += 'Network error. Please check your internet connection.';
            break;
            
        default:
            errorMessage += xhr.responseJSON?.message || 
                           `HTTP ${xhr.status}: ${xhr.statusText || 'Unknown error'}`;
    }

    alert(errorMessage);
}

/**
 * Main function to save CR Assessment with improved error handling and validation
 */
async function saveCRAssessment() {
    try {
        setLoadingState(true);

        const phase = getFormValue('choose_phase');
        const assessmentType = getFormValue('choose_assessment_type');
        
        const formData = {
            army_number: getFormValue('army_number'),
            name: getFormValue('name'),
            school_id: getFormValue('school_id'),
            course_id: getFormValue('course_id'),
            intake_id: getFormValue('intake_id'),
            phase: phase,
            assessment_type: assessmentType,
            assessment_group: getFormValue('choose_assessment_group', false),
            assessments: collectAssessments(phase)
        };

        validateFormData(formData);

        console.log('Sending assessment data:', formData);

        const response = await $.ajax({
            url: '<?php echo e(route("cr-assessment.store")); ?>',
            method: 'POST',
            data: JSON.stringify(formData),
            contentType: 'application/json',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Accept': 'application/json'
            },
            timeout: 30000
        });

        console.log('Server response:', response);
        
        const message = response.message || 'CR Assessment saved successfully!';
        Swal.fire({
            icon: 'success',
            title: 'Success!',
            text: message,
            timer: 2000,
            showConfirmButton: false
        });
        
        clearForm();
        
        setTimeout(() => {
            window.location.reload();
        }, 2000);

    } catch (error) {
        console.error('Error in saveCRAssessment:', error);
        
        if (error.responseJSON !== undefined) {
            handleAjaxError(error);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: error.message
            });
        }
    } finally {
        setLoadingState(false);
    }
}

function submitCRAssessment(event) {
    event.preventDefault();
    saveCRAssessment();
    return false;
}

function onPhaseChange() {
    const phase = getFormValue('choose_phase', false);
    if (phase) {
        const radioButtons = document.querySelectorAll('input[type="radio"][name^="rating_"]');
        radioButtons.forEach(radio => radio.checked = false);
        console.log(`Phase changed to: ${phase}`);
    }
}

document.addEventListener('DOMContentLoaded', function() {
    const phaseSelect = document.getElementById('choose_phase');
    if (phaseSelect) {
        phaseSelect.addEventListener('change', onPhaseChange);
    }
});

function clearForm() {
    document.getElementById('army_number').value = '';
    document.getElementById('name').value = '';
    document.getElementById('student_intake').value = '';

    const table = document.querySelector('#unit1_container table');
    if (table) {
        table.querySelectorAll('input[type="radio"]').forEach(radio => {
            radio.checked = false;
            radio.dataset.previousState = 'unchecked';
        });
    }

    document.querySelectorAll('.cr-radio').forEach(radio => {
        radio.disabled = false;
        if (radio.nextElementSibling) {
            radio.nextElementSibling.classList.remove('text-gray-400');
        }
    });

    const container = document.getElementById('unit1_container');
    if (container) {
        container.style.display = 'none';
    }

    if (typeof RatingInputHandler !== 'undefined') {
        RatingInputHandler.init();
    }
}

const MESSAGES = {
    ARMY_NUMBER_REQUIRED: "Please enter an Army Number",
    ARMY_NUMBER_NOT_FOUND: "Army Number not found in the system",
    NETWORK_ERROR: "Network error occurred. Please check your connection and try again",
    GENERAL_ERROR: "An error occurred. Please try again",
    LOADING: "Loading..."
};

/**
 * Search for records by army number and handle the UI accordingly
 */
function searchArmyNumber() {
    console.log('=== Search Army Number Started ===');
    
    const armyNumberInput = document.getElementById('army_number');
    const nameInput = document.getElementById('name');
    const intakeInput = document.getElementById('student_intake');
    const searchButton = document.querySelector('button[onclick="searchArmyNumber()"]');
    const unit1Container = document.getElementById('unit1_container');
    const successMessageContainer = document.getElementById('successMessage');
    const errorMessageContainer = document.getElementById('errorMessage');

    const schoolId = document.getElementById('school_id').value;
    const courseId = document.getElementById('course_id').value;
    const intakeId = document.getElementById('intake_id').value;
    const phase = document.getElementById('choose_phase').value;
    const armyNumber = armyNumberInput.value.trim();

    console.log('Selected Values:', {
        schoolId: schoolId,
        courseId: courseId,
        intakeId: intakeId,
        phase: phase,
        armyNumber: armyNumber,
        intakeText: document.getElementById('intake_id').options[document.getElementById('intake_id').selectedIndex]?.text
    });

    function showAlert(message, isError = true) {
        console.log('Alert:', message, 'isError:', isError);
        if (isError) {
            if (errorMessageContainer) {
                errorMessageContainer.textContent = message;
                errorMessageContainer.style.display = 'block';
                if (successMessageContainer) successMessageContainer.style.display = 'none';
            } else {
                alert(message);
            }
        } else {
            if (successMessageContainer) {
                successMessageContainer.textContent = message;
                successMessageContainer.style.display = 'block';
                if (errorMessageContainer) errorMessageContainer.style.display = 'none';
            }
        }
    }

    if (errorMessageContainer) errorMessageContainer.style.display = 'none';
    if (successMessageContainer) successMessageContainer.style.display = 'none';

    if (!schoolId || !courseId || !intakeId || !phase) {
        console.log('Validation failed: missing selections');
        showAlert('Please select School, Course, Intake, and Phase before searching');
        return;
    }

    if (!armyNumber) {
        console.log('Validation failed: missing army number');
        showAlert('Please enter an Army Number');
        armyNumberInput.focus();
        return;
    }

    searchButton.disabled = true;
    searchButton.textContent = 'Searching...';
    nameInput.value = '';
    if (intakeInput) intakeInput.value = '';
    unit1Container.style.display = 'none';

    const requestData = {
        army_number: armyNumber,
        school_id: schoolId,
        course_id: courseId,
        intake_id: intakeId,
        phase: phase
    };

    console.log('Sending request with data:', requestData);

    fetch("<?php echo e(route('admissions.searchArmyNumber')); ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            "Accept": "application/json"
        },
        body: JSON.stringify(requestData)
    })
    .then(response => {
        console.log('Response received:', {
            status: response.status,
            statusText: response.statusText,
            ok: response.ok
        });
        
        if (!response.ok) {
            return response.json().then(errorData => {
                console.log('Error response data:', errorData);
                throw new Error(errorData.message || `Server error: ${response.status}`);
            });
        }
        return response.json();
    })
    .then(data => {
        console.log('Success response data:', data);
        
        if (data.error) {
            showAlert(data.error);
            return;
        }
        
        if (!data.success && data.message) {
            showAlert(data.message);
            return;
        }

        const name = data.data ? data.data.name : data.name;
        const intake = data.data ? data.data.intake : (data.intake || '');
        
        console.log('Student name:', name);
        console.log('Student intake:', intake);
        
        if (!name) {
            showAlert('Name data is missing in the response');
            return;
        }

        nameInput.value = name;
        if (intakeInput) intakeInput.value = intake;
        unit1Container.style.display = "block";
        showAlert('Record found successfully!', false);

        document.querySelectorAll('.cr-radio').forEach(radio => {
            radio.checked = false;
        });

        return $.ajax({
            url: '<?php echo e(route("cr-assessment.getAllByArmyNumber")); ?>',
            method: 'POST',
            data: {
                army_number: armyNumber,
                school_id: schoolId,
                course_id: courseId,
                intake_id: intakeId,
                phase: phase,
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        });
    })
    .then(assessmentResponse => {
        if (assessmentResponse) {
            console.log('Assessment response:', assessmentResponse);
            if (assessmentResponse.assessments && assessmentResponse.assessments.length > 0) {
                showAlert(`Found ${assessmentResponse.assessments.length} existing assessment(s)`, false);
            }
        }
    })
    .catch(error => {
        console.error('Search Error:', error);
        console.error('Error stack:', error.stack);
        showAlert(error.message || 'Network error. Please try again.');
    })
    .finally(() => {
        console.log('Search completed, resetting button');
        searchButton.disabled = false;
        searchButton.textContent = 'Search';
    });
}

document.addEventListener('DOMContentLoaded', function() {
    const unit1Container = document.getElementById('unit1_container');

    if (!unit1Container || !unit1Container.querySelector('table')) {
        console.error('Table container or table not found');
        return;
    }

    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === 'attributes' && mutation.attributeName === 'style') {
                if (unit1Container.style.display !== 'none') {
                    unit1Container.querySelector('table').style.display = 'table';
                }
            }
        });
    });

    observer.observe(unit1Container, {
        attributes: true
    });
});

$(document).ready(function () {
    const schoolSelect = $('#school_id');
    if (schoolSelect.val()) {
        schoolSelect.trigger('change');
    }

    $('#school_id').change(function() {
        const schoolId = $(this).val();
        if (schoolId) {
            $.get("<?php echo e(route('getCourses')); ?>", { school_id: schoolId })
                .done(function(data) {
                    $('#course_id').html('<option value="">Select Course</option>');
                    $.each(data, function(id, name) {
                        const selected = name === 'O/CDT' ? 'selected' : '';
                        $('#course_id').append(`<option value="${id}" ${selected}>${name}</option>`);
                    });
                    $('#course_id').trigger('change');
                });
        }
    });

    function toggleContainer(containerId, show) {
        const container = $(`#${containerId}_container`);
        if (show) {
            container.show();
        } else {
            container.hide();
            $(`#${containerId}`).val('');
        }
    }

    $('#school_id').change(function () {
        const schoolId = $(this).val();
        toggleContainer('course', !!schoolId);

        if (schoolId) {
            $.get("<?php echo e(route('getCourses')); ?>", { school_id: schoolId })
                .done(function (data) {
                    $('#course_id').html('<option value="">Select Course</option>');
                    $.each(data, function (id, name) {
                        $('#course_id').append(`<option value="${id}">${name}</option>`);
                    });
                });
        }
    });

    // Course change handler
    $('#course_id').change(function() {
        const courseId = $(this).val();
        if (courseId) {
            $.get("<?php echo e(route('getIntakes')); ?>", { course_id: courseId })
                .done(function(data) {
                    $('#intake_id').html('<option value="">Select Intake</option>');
                    $.each(data, function(id, year) {
                        $('#intake_id').append(`<option value="${id}">${year}</option>`);
                    });
                });
        }
    });

    $('#intake_id').change(function() {
        const intakeId = $(this).val();
        if (intakeId) {
            $('#phase_container').show();
            $('#assessment_type_container').show();
            if (!$('#choose_phase').val()) {
                $('#choose_phase').val('Phase 1').trigger('change');
            }

            if (!$('#choose_assessment_type').val()) {
                $('#choose_assessment_type').val('Character Assessment').trigger('change');
            }
        }
    });

    $('#choose_phase').change(function () {
        toggleContainer('assessment_type', !!$(this).val());
    });

    $('#choose_assessment_group').change(function () {
        const assessmentGroup = $(this).val();
        toggleContainer('type', !!assessmentGroup);

        if (assessmentGroup === 'Theory') {
            $('#choose_type').html(`
                <option value="">Select Exam Type</option>
                <option value="Weekly">Weekly</option>
                <option value="Monthly">Monthly</option>
                <option value="End of Phase Exam">End of Phase Exam</option>
            `);
        } else if (assessmentGroup === 'Practical') {
            $('#choose_type').html(`
                <option value="">Select Exam Type</option>
                <option value="Weekly">Weekly</option>
            `);
        }
    });

    $('#choose_assessment_type').change(function () {
        const assessmentType = $(this).val();
        toggleContainer('assessment_group', !!assessmentType);

        if (assessmentType) {
            let options = '<option value="">Select Assessment Group</option>';
            if (assessmentType === 'MSK') {
                options += `
                    <option value="Theory">Theory</option>
                    <option value="Practical">Practical</option>
                `;
                toggleContainer('unit', false);
                toggleContainer('type', true);
            } else if (assessmentType === 'Character Assessment') {
                options += `
                    <option value="22 CR">22 CR</option>
                `;
            }
            $('#choose_assessment_group').html(options);
        }
    });

    $('#choose_assessment_group').change(function () {
        const assessmentGroup = $(this).val();
        const assessmentType = $('#choose_assessment_type').val();

        if (assessmentType === 'Character Assessment' && assessmentGroup === '22 CR') {
            toggleContainer('unit', true);
            toggleContainer('type', false);
        } else {
            toggleContainer('unit', false);
            toggleContainer('type', true);

            if (assessmentGroup === 'Theory') {
                $('#choose_type').html(`
                    <option value="">Select Exam Type</option>
                    <option value="Weekly">Weekly</option>
                    <option value="Monthly">Monthly</option>
                    <option value="End of Phase Exam">End of Phase Exam</option>
                `);
            } else if (assessmentGroup === 'Practical') {
                $('#choose_type').html(`
                    <option value="">Select Exam Type</option>
                    <option value="Weekly">Weekly</option>
                `);
            }
        }
    });

    $('#choose_type').change(function () {
        const examType = $(this).val();
        const assessmentGroup = $('#choose_assessment_group').val();
        const courseId = $('#course_id').val();

        toggleContainer('weeks', examType === 'Weekly');

        if (assessmentGroup === 'Theory') {
            toggleContainer('subject', examType === 'End of Phase Exam');
            toggleContainer('exercises', false);
        } else if (assessmentGroup === 'Practical') {
            toggleContainer('subject', false);
            toggleContainer('exercises', examType === 'End of Phase Exam' || examType === 'Weekly');
        }

        toggleContainer('bn', ['Weekly', 'Monthly', 'End of Phase Exam'].includes(examType));
    });

    $('#bn').change(function () {
        toggleContainer('coy', !!$(this).val());
    });

    $('#coy').change(function () {
        toggleContainer('pl', !!$(this).val());
    });

    $('#pl').change(function () {
        toggleContainer('sec', !!$(this).val());
    });
});

$('#filterForm').on('submit', function(e) {
    e.preventDefault();

    if ($('#choose_assessment_group').val() === '22 CR') {
        submitCRAssessment();
        return;
    }

    const marksData = [];
    $('#studentList input[type="number"]').each(function() {
        const studentId = $(this).attr('id').replace('marks_', '');
        const marks = $(this).val();
        marksData.push({
            admission_id: studentId,
            marks: marks !== "" ? marks : null
        });
    });

    const formData = {
        marks: marksData,
        school_id: $('#school_id').val(),
        course_id: $('#course_id').val(),
        intake_id: $('#intake_id').val(),
        phase: $('#choose_phase').val(),
        assessment_type: $('#choose_assessment_type').val(),
        assessment_group: $('#choose_assessment_group').val(),
        type: $('#choose_type').val(),
        subject_id: $('#subject').val(),
        exercises: $('#exercises').val(),
        bn: $('#bn').val(),
        coy: $('#coy').val(),
        pl: $('#pl').val(),
        sec: $('#sec').val(),
        week: $('#weeks').val(),
    };

    $.ajax({
        url: '<?php echo e(route("marks_entry.store")); ?>',
        type: 'POST',
        data: JSON.stringify(formData),
        contentType: 'application/json',
        success: function(response) {
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: 'Marks saved successfully!',
                timer: 2000,
                showConfirmButton: false
            });
        },
        error: function(xhr) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: xhr.responseJSON?.message || 'Error saving data'
            });
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views/marks_entry.blade.php ENDPATH**/ ?>