

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
  <div class="flex justify-between items-center mb-8">
    <div>
        <h1 class="text-4xl font-bold text-gray-800">22 CR Overview</h1>
        <p class="text-gray-600">View and filter cadet performance by school, course, battalion, company, and platoon. <br> Sort and apply filters, then print or export results as PDF.</p>
    </div>
</div>


    <!-- Search Form -->
    <div class="bg-white rounded-lg shadow-lg overflow-hidden mb-8">
        <form method="GET" action="<?php echo e(route('cr.assessments.22cr.overview')); ?>" class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-4">
                <!-- School Filter -->
                <div>
                    <label for="school_id" class="block text-sm font-medium text-gray-700">School</label>
                    <select name="school_id" id="school_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Schools</option>
                        <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($school->id); ?>" <?php echo e(request('school_id') == $school ? 'selected' : ''); ?>><?php echo e($school->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                
                <!-- Course Filter -->
                <div>
                    <label for="course_id" class="block text-sm font-medium text-gray-700">Course</label>
                    <select name="course_id" id="course_id" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Courses</option>
                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($course->id); ?>" <?php echo e(request('course_id') == $course->name ? 'selected' : ''); ?>><?php echo e($course->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Battalion Filter -->
                <div>
                    <label for="bn" class="block text-sm font-medium text-gray-700">Battalion</label>
                    <select name="bn" id="bn" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Battalions</option>
                        <?php $__currentLoopData = $battalions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $battalion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($battalion); ?>" <?php echo e(request('bn') == $battalion ? 'selected' : ''); ?>><?php echo e($battalion); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                
                <!-- Company Filter -->
                <div>
                    <label for="coy" class="block text-sm font-medium text-gray-700">Company</label>
                    <select name="coy" id="coy" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Companies</option>
                        <?php $__currentLoopData = $coysList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($coy); ?>" <?php echo e(request('coy') == $coy ? 'selected' : ''); ?>><?php echo e($coy); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                
                <!-- Platoon Filter -->
                <div>
                    <label for="pl" class="block text-sm font-medium text-gray-700">Platoon</label>
                    <select name="pl" id="pl" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">All Platoons</option>
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                 
                    </select>
                </div>
                
                <!-- Section Filter -->
                
                
                <!-- Sort Direction Filter -->
                <div>
                    <label for="sort" class="block text-sm font-medium text-gray-700">Sort Direction</label>
                    <select name="sort" id="sort" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">Default</option>
                        <option value="asc" <?php echo e(request('sort') == 'asc' ? 'selected' : ''); ?>>Ascending (A-Z)</option>
                        <option value="desc" <?php echo e(request('sort') == 'desc' ? 'selected' : ''); ?>>Descending (Z-A)</option>
                        <option value="score_asc" <?php echo e(request('sort') == 'score_asc' ? 'selected' : ''); ?>>Score (Low to High)</option>
                        <option value="score_desc" <?php echo e(request('sort') == 'score_desc' ? 'selected' : ''); ?>>Score (High to Low)</option>
                    </select>
                </div>
            </div>
            <div class="flex justify-end mt-4">
                <button type="submit"
                    class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                    Apply Filters
                </button>
            </div>
          <div class="flex flex-wrap gap-4 mt-4">

                    <!-- Apply Filters Button -->
                
                
                    <!-- Reset Filters Link -->
                    <div>
                        <a href="<?php echo e(route('cr.assessments.22cr.overview')); ?>"
                            class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-400 focus:ring-offset-2">
                            Reset Filters
                        </a>
                    </div>
                
                    <!-- Print PDF Link -->
                    <div>
                        <a href="<?php echo e(route('admissions.print22c', [
                            'pl' => request('pl'),
                            'coy' => request('coy'),
                            'sec' => request('sec'),
                            'bn' => request('bn'),
                            'school_id' => request('school_id'),
                            'course_id' => request('course_id'),
                            'intake_id' => request('intake_id'),
                            'year_admission' => request('year_admission'),
                            'student_id' => request('student_id'),
                            'sort' => request('sort', 'default')
                        ])); ?>"
                        target="_blank"
                        class="bg-green-600 text-white px-4 py-2 rounded-md font-semibold shadow hover:bg-green-700 transition">
                            Print PDF
                        </a>
                    </div>
                
                </div>
        </form>
    
        
        
  
    </div>

    
    <!-- Show results only if search was performed -->
    <?php if($assessments->count() > 0): ?>

    <div class="relative flex flex-col w-full h-full overflow-scroll text-gray-700 bg-white shadow-md rounded-xl bg-clip-border">
        <table class="w-full text-left table-auto min-w-max">
            <thead>
                <tr>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                      SN
                    </p>
                  </th>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => request('sort') == 'asc_army' ? 'desc_army' : 'asc_army'])); ?>" class="flex items-center cursor-pointer">
                      <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                        Army Number
                      </p>
                      <?php if(request('sort') == 'asc_army'): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" />
                        </svg>
                      <?php elseif(request('sort') == 'desc_army'): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                      <?php endif; ?>
                    </a>
                  </th>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                      Rank
                    </p>
                  </th>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => request('sort') == 'asc' ? 'desc' : 'asc'])); ?>" class="flex items-center cursor-pointer">
                      <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                        Cadet Name
                      </p>
                      <?php if(request('sort') == 'asc'): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" />
                        </svg>
                      <?php elseif(request('sort') == 'desc'): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                      <?php endif; ?>
                    </a>
                  </th>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                      Phase
                    </p>
                  </th>
                  <th class="p-4 border-b border-blue-gray-100 bg-blue-gray-50">
                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => request('sort') == 'score_asc' ? 'score_desc' : 'score_asc'])); ?>" class="flex items-center cursor-pointer">
                      <p class="block font-sans text-sm antialiased font-normal leading-none text-blue-gray-900 opacity-70">
                        22CR Score
                      </p>
                      <?php if(request('sort') == 'score_asc'): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" />
                        </svg>
                      <?php elseif(request('sort') == 'score_desc'): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                      <?php endif; ?>
                    </a>
                  </th>
                </tr>
              </thead>
          <tbody>
            <?php $cadetCounter = 1; ?>
            <?php $__currentLoopData = $assessments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $armyNumber => $armyAssessments): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php $__currentLoopData = $armyAssessments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assessment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="<?php echo e($index === count($armyAssessments)-1 && !$loop->parent->last ? 'border-b-2 border-blue-gray-100' : ''); ?>">
                  <?php if($index === 0): ?>
                    <td class="p-4 border-b border-blue-gray-50" rowspan="<?php echo e(count($armyAssessments)); ?>">
                      <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                        <?php echo e($cadetCounter); ?>

                      </p>
                    </td>
                    <td class="p-4 border-b border-blue-gray-50" rowspan="<?php echo e(count($armyAssessments)); ?>">
                      <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                        <?php echo e($armyNumber); ?>

                      </p>
                    </td>
                    <td class="p-4 border-b border-blue-gray-50" rowspan="<?php echo e(count($armyAssessments)); ?>">
                      <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                        O/CDT
                      </p>
                    </td>
                    <td class="p-4 border-b border-blue-gray-50" rowspan="<?php echo e(count($armyAssessments)); ?>">
                      <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                        <?php echo e($assessment->name); ?>

                      </p>
                    </td>
                    <?php $cadetCounter++; ?>
                  <?php endif; ?>
                  <td class="p-4 border-b border-blue-gray-50">
                    <p class="block font-sans text-sm antialiased font-normal leading-normal text-blue-gray-900">
                      <?php echo e($assessment->phase); ?>

                    </p>
                  </td>
                  <td class="p-4 border-b border-blue-gray-50">
                    <p class="block font-sans text-sm antialiased font-semibold leading-normal text-blue-700">
                      <?php
                      $totalCRES = 0;
                      foreach($assessment->assessmentDetails as $detail) {
                          // Calculate individual f and fx
                          $f = $detail->f1 + $detail->f2 + $detail->f3 + $detail->f4 + $detail->f5;
                          $fx = ($detail->f1 * 1) + ($detail->f2 * 2) + ($detail->f3 * 3) +
                                ($detail->f4 * 4) + ($detail->f5 * 5);
            
                          // Calculate individual CRES
                          if ($f > 0) {
                              $individualCRES = ($fx / $f) * $detail->twentyTwoCR->weight;
                              $totalCRES += $individualCRES;
                          }
                      }
                      $score = number_format(($totalCRES / 720) * 20, 2);
                      ?>
                      <?php echo e($score); ?>% /20%
                    </p>
                  </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>

    <?php else: ?>
        <!-- No results found -->
        <div class="bg-white rounded-lg shadow-lg overflow-hidden">
            <div class="p-6 text-center">
                <div class="text-gray-500 mb-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 mx-auto mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <h3 class="text-xl font-medium text-gray-900 mb-2">No Records Found</h3>
                    <p>No 22 CR records were found <?php echo e("for Platoon ". $platoon); ?></p>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function viewDetails(assessmentId) {
    const detailsRow = document.getElementById(`details_${assessmentId}`);
    detailsRow.classList.toggle('hidden');
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\22cr\overview.blade.php ENDPATH**/ ?>