<!-- resources/views/exports/assessments_pdf.blade.php -->
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Assessment Report</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .filters {
            margin-bottom: 15px;
            font-size: 11px;
        }
        .filter-item {
            display: inline-block;
            margin-right: 15px;
            margin-bottom: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th {
            background-color: #4CAF50;
            color: white;
            font-weight: bold;
            text-align: center;
            padding: 5px;
            font-size: 11px;
        }
        td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: center;
            font-size: 10px;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .monthly-header {
            background-color: #2196F3;
        }
        .eope-header {
            background-color: #9C27B0;
        }
        .no-data {
            text-align: center;
            color: #666;
            padding: 20px;
        }
    </style>
</head>
<body>
<div class="header">
    <h2>Assessment Report</h2>
    <h3><?php echo e($type); ?> Assessment</h3>
</div>

<div class="filters">
    <p><strong>Filters:</strong></p>
    <?php $__currentLoopData = $filters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(!empty($value) && $key !== '_token'): ?>
            <div class="filter-item">
                <strong><?php echo e(ucwords(str_replace('_', ' ', $key))); ?>:</strong> <?php echo e($value); ?>

            </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<table>
    <thead>
    <tr>
        <th>Army Number</th>
        <th>Rank</th>
        <th>Cadet Name</th>

        <?php if($type == 'Monthly'): ?>
            <?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <th class="monthly-header">
                    Monthly <?php echo e(substr($month, -1)); ?>

                </th>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php elseif($type == 'End of Phase Exam'): ?>
            <th class="eope-header">EOPE</th>
        <?php else: ?>
            <?php for($i = 1; $i <= 10; $i++): ?>
                <th>Week <?php echo e($i); ?></th>
            <?php endfor; ?>
        <?php endif; ?>
    </tr>
    </thead>
    <tbody>
    <?php $__empty_1 = true; $__currentLoopData = $assessments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <?php
            $firstAssessment = $studentData->first();
            $assessmentMarks = $studentData->groupBy(function($assessment) {
                if ($assessment->type === 'Monthly') {
                    return 'monthly' . preg_replace('/[^0-9]/', '', $assessment->month, -1);
                } elseif ($assessment->type === 'End of Phase Exam') {
                    return 'eope';
                } else {
                    return preg_replace('/[^0-9]/', '', $assessment->week, -1);
                }
            });
        ?>

        <tr>
            <td><?php echo e($firstAssessment->admission->army_number); ?></td>
            <td><?php echo e($firstAssessment->admission->rank); ?></td>
            <td><?php echo e($firstAssessment->admission->name); ?></td>

            <?php if($type == 'Monthly'): ?>
                <?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $monthKey = 'monthly' . substr($month, -1);
                        $assessment = isset($assessmentMarks[$monthKey]) ? $assessmentMarks[$monthKey]->first() : null;
                    ?>
                    <td>
                        <?php if($assessment): ?>
                            <?php echo e($assessment->marks); ?>/<?php echo e($assessment->weight); ?>

                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php elseif($type == 'End of Phase Exam'): ?>
                <?php
                    $assessment = isset($assessmentMarks['eope']) ? $assessmentMarks['eope']->first() : null;
                ?>
                <td>
                    <?php if($assessment): ?>
                        <?php echo e($assessment->marks); ?>/<?php echo e($assessment->weight); ?>

                    <?php else: ?>
                        N/A
                    <?php endif; ?>
                </td>
            <?php else: ?>
                <?php for($week = 1; $week <= 10; $week++): ?>
                    <?php
                        $assessment = isset($assessmentMarks[$week]) ? $assessmentMarks[$week]->first() : null;
                    ?>
                    <td>
                        <?php if($assessment): ?>
                            <?php echo e($assessment->marks); ?>/<?php echo e($assessment->weight); ?>

                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>
                <?php endfor; ?>
            <?php endif; ?>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr>
            <td colspan="<?php echo e($type == 'Monthly' ? count($columns) + 3 : ($type == 'End of Phase Exam' ? 4 : 13)); ?>" class="no-data">
                No assessments found
            </td>
        </tr>
    <?php endif; ?>
    </tbody>
</table>

<div style="margin-top: 20px; font-size: 10px; text-align: right;">
    Generated on <?php echo e(date('Y-m-d H:i:s')); ?>

</div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\exports\assessments_pdf.blade.php ENDPATH**/ ?>