

<?php $__env->startSection('content'); ?>
    <div class="container mx-auto p-4 mt-10">
        <div class="mb-6">
            <div class="flex justify-between items-center mb-8">
                <div>
                    <h1 class="text-4xl font-bold text-gray-800">Marks Overview</h1>
                    <p class="text-gray-600">Review cadet performance across weeks, monthly, and end-of-phase, <br> with filters for assessment group or exam type, and export results.</p>
                </div>
            </div>

            <!-- Filters Form -->
            <form id="filter-form" method="GET" action="<?php echo e(route('marks.index')); ?>" class="space-y-1">
                <!-- First Row -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                    <!-- Assessment Type -->
                    <div>
                        <select name="assessment_type" id="assessment_type" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                            <option value="MSK" <?php echo e(request('assessment_type') == 'MSK' ? 'selected' : ''); ?>>MSK</option>
                        </select>
                    </div>

                    <!-- Assessment Group -->
                    <div id="assessment_group_container">
                        <select name="assessment_group" id="assessment_group" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                            <option value="">Select Assessment Group</option>
                            <option value="Theory" <?php echo e(request('assessment_group') == 'Theory' ? 'selected' : ''); ?>>Theory</option>
                            <option value="Practical" <?php echo e(request('assessment_group') == 'Practical' ? 'selected' : ''); ?>>Practical</option>
                        </select>
                    </div>

                    <!-- Exam Type -->
                    <div id="type_container">
                        <select name="type" id="type" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500" required>
                            <option value="">Select Exam Type</option>
                            <option value="Weekly" <?php echo e(request('type') == 'Weekly' ? 'selected' : ''); ?>>Weekly</option>
                            <option value="Monthly" <?php echo e(request('type') == 'Monthly' ? 'selected' : ''); ?>>Monthly</option>
                            <option value="End of Phase Exam" <?php echo e(request('type') == 'End of Phase Exam' ? 'selected' : ''); ?>>End of Phase Exam</option>
                        </select>
                    </div>
                </div>

                <!-- Second Row -->
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                    <!-- Week -->
                    <div id="weeks_container" style="display: <?php echo e(request('type') == 'Weekly' ? 'block' : 'none'); ?>;">
                        <select name="week" id="weeks" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Week</option>
                            <?php for($i = 1; $i <= $phase->weeks; $i++): ?>
                                <option value="week<?php echo e($i); ?>" <?php echo e(request('week') == "week$i" ? 'selected' : ''); ?>>Week <?php echo e($i); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>

                    <!-- Month -->
                    <div id="month_container" style="display: <?php echo e(request('type') == 'Monthly' ? 'block' : 'none'); ?>;">
                        <select name="month" id="month" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Month</option>
                            <?php $__currentLoopData = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($month); ?>" <?php echo e(request('month') == $month ? 'selected' : ''); ?>><?php echo e($month); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Subject -->
                    <div id="subject_container" style="display: <?php echo e((request('assessment_group') == 'Theory' && request('type') == 'End of Phase Exam') ? 'block' : 'none'); ?>;">
                        <select name="subject_id" id="subject" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Subject</option>
                            <?php $__currentLoopData = $subjects ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($subject->id); ?>" <?php echo e(request('subject_id') == $subject->id ? 'selected' : ''); ?>><?php echo e($subject->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Exercise -->
                    <div id="exercises_container" style="display: <?php echo e((request('assessment_group') == 'Practical' && request('type') == 'Weekly') ? 'block' : 'none'); ?>;">
                        <select name="exercises" id="exercises" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Exercise</option>
                            <?php $__currentLoopData = $exercise ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ex): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ex->title); ?>" <?php echo e(request('exercises') == $ex->title ? 'selected' : ''); ?>><?php echo e($ex->title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <!-- Third Row -->
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                    <!-- Battalion -->
                    <div id="bn_container" style="display: <?php echo e(in_array(request('type'), ['Weekly', 'Monthly', 'End of Phase Exam']) ? 'block' : 'none'); ?>;">
                        <select name="bn" id="bn" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Bn</option>
                            <?php $__currentLoopData = $bn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $battalion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($battalion); ?>" <?php echo e(request('bn') == $battalion ? 'selected' : ''); ?>><?php echo e($battalion); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Company -->
                    <div id="coy_container" style="display: <?php echo e(request('bn') ? 'block' : 'none'); ?>;">
                        <select name="coy" id="coy" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Coy</option>
                            <?php $__currentLoopData = $coy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($company); ?>" <?php echo e(request('coy') == $company ? 'selected' : ''); ?>><?php echo e($company); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Platoon -->
                    <div id="pl_container" style="display: <?php echo e(request('coy') ? 'block' : 'none'); ?>;">
                        <select name="pl" id="pl" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Pl</option>
                            <?php $__currentLoopData = ['1', '2', '3']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platoon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($platoon); ?>" <?php echo e(request('pl') == $platoon ? 'selected' : ''); ?>><?php echo e($platoon); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Section -->
                    <div id="sec_container" style="display: <?php echo e(request('pl') ? 'block' : 'none'); ?>;">
                        <select name="sec" id="sec" class="w-full mt-1 px-3 py-2 border rounded-lg focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Select Sec</option>
                            <?php $__currentLoopData = ['I', 'II', 'III']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($section); ?>" <?php echo e(request('sec') == $section ? 'selected' : ''); ?>><?php echo e($section); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <!-- Filter Button -->
                <div class="mb-4">
                    <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700">
                        Apply Filters
                    </button>
                    <a href="<?php echo e(route('marks.index')); ?>" class="ml-2 bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600">
                        Clear Filters
                    </a>
                </div>
            </form>

            <!-- Search and Export Section -->
            <div class="flex justify-between items-center mb-6">
                <!-- Search Form -->
                <form method="GET" action="<?php echo e(route('marks.index')); ?>" class="flex-1 max-w-2xl">
                    <?php $__currentLoopData = request()->except(['search', 'page']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                    <div class="flex space-x-4">
                        <div class="relative flex-1">
                            <input
                                type="text"
                                name="search"
                                placeholder="Search by Army Number, Name or Rank"
                                value="<?php echo e(request('search')); ?>"
                                class="w-full border-gray-300 rounded-lg shadow-sm p-2 pl-10 focus:ring-blue-500 focus:border-blue-500"
                            >
                            <svg class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                        </div>
                        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
                            Search
                        </button>
                    </div>
                </form>

                <!-- Export Buttons -->
                <div class="flex space-x-2">
                    <button type="button" id="exportExcel" class="bg-blue-500 text-white px-4 py-2 rounded-lg flex items-center hover:bg-blue-600">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        Export to Excel
                    </button>

                    <button type="button" id="exportPdf" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        Export to PDF
                    </button>
                </div>
            </div>

            <!-- Pagination Controls -->
            <div class="flex items-center justify-between py-4">
                <div class="flex items-center">
                    <span class="text-sm text-gray-700 mr-4">
                        Showing <span class="font-medium"><?php echo e($marks->firstItem() ?? 0); ?></span>
                        to <span class="font-medium"><?php echo e($marks->lastItem() ?? 0); ?></span>
                        of <span class="font-medium"><?php echo e($marks->total()); ?></span> results
                    </span>
                    
                    <!-- Per Page Selector -->
                    <div class="relative inline-block">
                        <select id="per-page-selector" 
                                class="form-select rounded-md border-gray-300 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50"
                                onchange="window.location.href = this.value">
                            <?php $__currentLoopData = [10, 25, 50, 100]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perPageOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e(request()->fullUrlWithQuery(['per_page' => $perPageOption, 'page' => 1])); ?>"
                                        <?php echo e(request()->get('per_page', 25) == $perPageOption ? 'selected' : ''); ?>>
                                    <?php echo e($perPageOption); ?> per page
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Results Table -->
            <div class="max-w-7xl mx-auto bg-white shadow-md rounded-lg p-6">
                <div class="overflow-x-auto">
                    <table class="min-w-full border border-gray-300 text-center">
                        <thead>
                            <tr class="bg-green-500 text-white">
                                <th class="py-2 px-3 border text-sm">
                                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'admissions.army_number', 'direction' => request('sort') === 'admissions.army_number' && request('direction') === 'asc' ? 'desc' : 'asc'])); ?>" 
                                       class="flex items-center justify-center text-white hover:text-gray-100">
                                        Army Number
                                        <?php if(request('sort') === 'admissions.army_number'): ?>
                                            <span class="ml-1"><?php echo e(request('direction') === 'asc' ? '↑' : '↓'); ?></span>
                                        <?php endif; ?>
                                    </a>
                                </th>
                                <th class="py-2 px-3 border text-sm">
                                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'admissions.rank', 'direction' => request('sort') === 'admissions.rank' && request('direction') === 'asc' ? 'desc' : 'asc'])); ?>"
                                       class="flex items-center justify-center text-white hover:text-gray-100">
                                        Rank
                                        <?php if(request('sort') === 'admissions.rank'): ?>
                                            <span class="ml-1"><?php echo e(request('direction') === 'asc' ? '↑' : '↓'); ?></span>
                                        <?php endif; ?>
                                    </a>
                                </th>
                                <th class="py-2 px-3 border text-sm">
                                    <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'admissions.name', 'direction' => request('sort') === 'admissions.name' && request('direction') === 'asc' ? 'desc' : 'asc'])); ?>"
                                       class="flex items-center justify-center text-white hover:text-gray-100">
                                        Cadet Name
                                        <?php if(request('sort') === 'admissions.name'): ?>
                                            <span class="ml-1"><?php echo e(request('direction') === 'asc' ? '↑' : '↓'); ?></span>
                                        <?php endif; ?>
                                    </a>
                                </th>
                                
                                
                                <?php if(request('type') == 'Monthly'): ?>
                                    <?php
                                        $monthlyColumns = $marks->first()?->filter(function($mark) {
                                            return $mark->type === 'Monthly';
                                        })->pluck('week')->unique()->sort() ?? collect([]);
                                    ?>
                            
                                    <?php $__currentLoopData = $monthlyColumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th class="py-2 px-3 border text-sm bg-blue-600">
                                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'marks.marks', 'month' => $month, 'direction' => request('sort') === 'marks.marks' && request('month') === $month && request('direction') === 'asc' ? 'desc' : 'asc'])); ?>"
                                               class="flex items-center justify-center text-white hover:text-gray-100">
                                                Monthly <?php echo e(substr($month, -1)); ?>

                                                <?php if(request('sort') === 'marks.marks' && request('month') === $month): ?>
                                                    <span class="ml-1"><?php echo e(request('direction') === 'asc' ? '↑' : '↓'); ?></span>
                                                <?php endif; ?>
                                            </a>
                                        </th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php elseif(request('type') == 'End of Phase Exam'): ?>
                                    <th class="py-2 px-3 border text-sm bg-purple-600">
                                        <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'marks.marks', 'direction' => request('sort') === 'marks.marks' && request('direction') === 'asc' ? 'desc' : 'asc'])); ?>"
                                           class="flex items-center justify-center text-white hover:text-gray-100">
                                            EOPE
                                            <?php if(request('sort') === 'marks.marks'): ?>
                                                <span class="ml-1"><?php echo e(request('direction') === 'asc' ? '↑' : '↓'); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </th>
                                <?php else: ?>
                                    <?php for($i = 1; $i <= $phase->weeks; $i++): ?>
                                        <th class="py-2 px-3 border text-sm">
                                            <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'marks.marks', 'week' => $i, 'direction' => request('sort') === 'marks.marks' && request('week') === $i && request('direction') === 'asc' ? 'desc' : 'asc'])); ?>"
                                               class="flex items-center justify-center text-white hover:text-gray-100">
                                                Week <?php echo e($i); ?>

                                                <?php if(request('sort') === 'marks.marks' && request('week') == $i): ?>
                                                    <span class="ml-1"><?php echo e(request('direction') === 'asc' ? '↑' : '↓'); ?></span>
                                                <?php endif; ?>
                                            </a>
                                        </th>
                                    <?php endfor; ?>
                                <?php endif; ?>
                                <th class="py-2 px-3 border text-sm">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $marks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $firstMark = $studentData->first();
                                $assessmentMarks = $studentData->groupBy(function($mark) {
                                    if ($mark->type === 'Monthly') {
                                        return 'monthly' . preg_replace('/[^0-9]/', '',$mark->week, -1);
                                    } elseif ($mark->type === 'End of Phase Exam') {
                                        return 'eope';
                                    } else {
                                        return preg_replace('/[^0-9]/', '',$mark->week, -1);
                                    }
                                });
                            ?>

                            <tr class="hover:bg-gray-50">
                                <td class="py-2 px-3 border text-sm"><?php echo e($firstMark->army_number ?? ""); ?></td>
                                <td class="py-2 px-3 border text-sm"><?php echo e($firstMark->rank ?? ""); ?></td>
                                <td class="py-2 px-3 border text-sm"><?php echo e($firstMark->name ?? ""); ?></td>

                                
                                <?php if(request('type') == 'Monthly'): ?>
                                    <?php $__currentLoopData = $monthlyColumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo $__env->make('partials.mark-cell', [
                                            'weeklyMarks' => $assessmentMarks,
                                            'week' => 'monthly' . substr($month, -1),
                                            'isMonthly' => true
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php elseif(request('type') == 'End of Phase Exam'): ?>
                                    <?php echo $__env->make('partials.mark-cell', [
                                        'weeklyMarks' => $assessmentMarks,
                                        'week' => 'eope',
                                        'isEope' => true
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php else: ?>
                                    <?php for($week = 1; $week <= $phase->weeks; $week++): ?>
                                        <?php echo $__env->make('partials.mark-cell', [
                                            'weeklyMarks' => $assessmentMarks,
                                            'week' => $week
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endfor; ?>
                                <?php endif; ?>
                                <td class="py-2 px-3 border text-sm">
                                    <a href="<?php echo e(route('mark.show', $firstMark->admission_id)); ?>"
                                       class="text-indigo-600 hover:text-indigo-900 hover:underline">
                                        View
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="15" class="px-4 py-8 text-center text-gray-500">
                                    No assessments found
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Bottom Pagination -->
            <div class="mt-6 px-4">
                <div class="flex items-center justify-between">
                    <div class="flex justify-end">
                        <?php echo e($marks->appends(request()->except('page'))->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Simple form-based filtering without AJAX caching
            function toggleContainer(containerId, show) {
                const container = document.getElementById(containerId + '_container');
                if (container) {
                    container.style.display = show ? 'block' : 'none';
                    if (!show) {
                        const select = document.getElementById(containerId);
                        if (select) select.value = '';
                    }
                }
            }

            // Assessment Group change handler
            document.getElementById('assessment_group').addEventListener('change', function() {
                const group = this.value;
                const typeSelect = document.getElementById('type');
                
                // Update exam type options based on assessment group
                if (group === 'Theory') {
                    typeSelect.innerHTML = `
                        <option value="">Select Exam Type</option>
                        <option value="Weekly">Weekly</option>
                        <option value="Monthly">Monthly</option>
                        <option value="End of Phase Exam">End of Phase Exam</option>
                    `;
                } else if (group === 'Practical') {
                    typeSelect.innerHTML = `
                        <option value="">Select Exam Type</option>
                        <option value="Weekly">Weekly</option>
                    `;
                }
                
                // Reset dependent fields
                ['weeks', 'month', 'subject', 'exercises', 'bn', 'coy', 'pl', 'sec'].forEach(field => {
                    toggleContainer(field, false);
                });
            });

            // Exam Type change handler
            document.getElementById('type').addEventListener('change', function() {
                const examType = this.value;
                const assessmentGroup = document.getElementById('assessment_group').value;

                // Show/hide containers based on exam type
                toggleContainer('weeks', examType === 'Weekly');
                toggleContainer('month', examType === 'Monthly');
                toggleContainer('subject', assessmentGroup === 'Theory' && examType === 'End of Phase Exam');
                toggleContainer('exercises', assessmentGroup === 'Practical' && examType === 'Weekly');
                toggleContainer('bn', ['Weekly', 'Monthly', 'End of Phase Exam'].includes(examType));
            });

            // Chain dropdowns for Bn > Coy > Pl > Sec
            document.getElementById('bn').addEventListener('change', function() {
                toggleContainer('coy', !!this.value);
                if (!this.value) {
                    ['pl', 'sec'].forEach(field => toggleContainer(field, false));
                }
            });

            document.getElementById('coy').addEventListener('change', function() {
                toggleContainer('pl', !!this.value);
                if (!this.value) {
                    toggleContainer('sec', false);
                }
            });

            document.getElementById('pl').addEventListener('change', function() {
                toggleContainer('sec', !!this.value);
            });

            // Export functionality
            document.getElementById('exportExcel').addEventListener('click', function() {
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = '<?php echo e(route("marks.export.excel")); ?>';
                form.target = '_blank';

                // Add CSRF token
                const csrfToken = document.createElement('input');
                csrfToken.type = 'hidden';
                csrfToken.name = '_token';
                csrfToken.value = document.querySelector('meta[name="csrf-token"]').content;
                form.appendChild(csrfToken);

                // Add current URL parameters
                const urlParams = new URLSearchParams(window.location.search);
                for (let pair of urlParams.entries()) {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = pair[0];
                    input.value = pair[1];
                    form.appendChild(input);
                }

                document.body.appendChild(form);
                form.submit();
                document.body.removeChild(form);
            });

            document.getElementById('exportPdf').addEventListener('click', function() {
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = '<?php echo e(route("marks.export.pdf")); ?>';
                form.target = '_blank';

                // Add CSRF token
                const csrfToken = document.createElement('input');
                csrfToken.type = 'hidden';
                csrfToken.name = '_token';
                csrfToken.value = document.querySelector('meta[name="csrf-token"]').content;
                form.appendChild(csrfToken);

                // Add current URL parameters
                const urlParams = new URLSearchParams(window.location.search);
                for (let pair of urlParams.entries()) {
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = pair[0];
                    input.value = pair[1];
                    form.appendChild(input);
                }

                document.body.appendChild(form);
                form.submit();
                document.body.removeChild(form);
            });
        });
    </script>

    <style>
        .action-buttons {
            opacity: 0;
            transition: opacity 0.2s;
        }

        tr:hover .action-buttons {
            opacity: 1;
        }

        .action-button {
            padding: 0.25rem;
            border-radius: 0.375rem;
            transition: background-color 0.2s;
        }

        .action-button:hover {
            background-color: rgba(0, 0, 0, 0.05);
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views/marks/index.blade.php ENDPATH**/ ?>