

<?php $__env->startSection('content'); ?>
<!-- Loading Overlay -->



<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Title and Add New Button -->
    <!-- Add this after the "Add New Admission" button -->


 

    <?php if($type == 'epr'): ?>
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">End Of Phase Report</h1>
            <p class="text-gray-600">Overview of performance at the end of a training phase</p>
        </div>
    </div>
<?php elseif($type == 'isr'): ?>
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">Individual Summary Report</h1>
            <p class="text-gray-600">Detailed summary of an individual's performance and progress</p>
        </div>
    </div>
<?php elseif($type == 'tr'): ?>
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">Transcript Report</h1>
            <p class="text-gray-600">Comprehensive record of academic achievements and results</p>
        </div>
    </div>
<?php endif; ?>

   
        <!-- Success Message -->
        <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <span class="block sm:inline"><?php echo e(session('success')); ?></span>
        </div>
        <?php endif; ?>


  

<form method="GET" action="<?php echo e(route('admissions.list', $type)); ?>" class="mb-4 flex flex-wrap gap-4">
    <!-- School Filter -->
    <select name="school_id" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by School</option>
        <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($school->id); ?>" <?php echo e(request('school_id') == $school->id ? 'selected' : ''); ?>>
                <?php echo e($school->name); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    
    <!-- Course Filter -->
    <select name="course_id" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Course</option>
        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($course->id); ?>" <?php echo e(request('course_id') == $course->id ? 'selected' : ''); ?>>
                <?php echo e($course->name); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    
    <!-- Battalion Filter -->
    <select name="bn" id="bn-filter" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Bn</option>
        <?php $__currentLoopData = $bn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $battalion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($battalion); ?>" <?php echo e(request('bn') == $battalion ? 'selected' : ''); ?>>
                <?php echo e(ucfirst($battalion)); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    
    <!-- Company Filter -->
    <select name="coy" id="coy-filter" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Coy</option>
        <?php $__currentLoopData = $coy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($company); ?>" 
                <?php echo e(request('coy') == $company ? 'selected' : ''); ?>

                data-bn="<?php echo e($companyBnMap[$company] ?? ''); ?>">
                <?php echo e(strtoupper($company)); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    
    <!-- Platoon Filter -->
    <select name="pl" id="" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Pl</option>
        <option value="1">1</option>
        <option value="2">2</option>
        <option value="3">3</option>
        <option value="4">4</option>
    </select>
    
    <!-- Section Filter -->
    <select name="sec" id="sec-filte" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Sec</option>
        <option value="I">I</option>
        <option value="II">II</option>
        <option value="III">III</option>
 
    </select>
    
    <!-- Submit and Clear Buttons -->
    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
        Filter
    </button>
    <a href="<?php echo e(route('admissions.list', $type)); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
        Clear
    </a>
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const bnFilter = document.getElementById('bn-filter');
    const coyFilter = document.getElementById('coy-filter');
    const plFilter = document.getElementById('pl-filter');
    const secFilter = document.getElementById('sec-filter');
    
    // Function to filter dropdowns based on selection
    function updateFilters() {
        const selectedBn = bnFilter.value;
        const selectedCoy = coyFilter.value;
        const selectedPl = plFilter.value;
        
        // Filter company options based on battalion
        if (selectedBn) {
            Array.from(coyFilter.options).forEach(option => {
                if (option.value === '' || option.dataset.bn === selectedBn) {
                    option.style.display = '';
                } else {
                    option.style.display = 'none';
                }
            });
        } else {
            // Show all company options if no battalion selected
            Array.from(coyFilter.options).forEach(option => {
                option.style.display = '';
            });
        }
        
        // Filter platoon options based on battalion and company
        Array.from(plFilter.options).forEach(option => {
            if (option.value === '') {
                option.style.display = '';
                return;
            }
            
            let shouldShow = true;
            
            if (selectedBn && option.dataset.bn !== selectedBn) {
                shouldShow = false;
            }
            
            if (selectedCoy && option.dataset.coy !== selectedCoy) {
                shouldShow = false;
            }
            
            option.style.display = shouldShow ? '' : 'none';
        });
        
        // Filter section options based on battalion, company, and platoon
        Array.from(secFilter.options).forEach(option => {
            if (option.value === '') {
                option.style.display = '';
                return;
            }
            
            let shouldShow = true;
            
            if (selectedBn && option.dataset.bn !== selectedBn) {
                shouldShow = false;
            }
            
            if (selectedCoy && option.dataset.coy !== selectedCoy) {
                shouldShow = false;
            }
            
            if (selectedPl && option.dataset.pl !== selectedPl) {
                shouldShow = false;
            }
            
            option.style.display = shouldShow ? '' : 'none';
        });
    }
    
    // Add event listeners for filter changes
    bnFilter.addEventListener('change', function() {
        // Clear lower-level filters when battalion changes
        coyFilter.value = '';
        plFilter.value = '';
        secFilter.value = '';
        updateFilters();
    });
    
    coyFilter.addEventListener('change', function() {
        // Clear lower-level filters when company changes
        plFilter.value = '';
        secFilter.value = '';
        updateFilters();
    });
    
    plFilter.addEventListener('change', function() {
        // Clear section filter when platoon changes
        secFilter.value = '';
        updateFilters();
    });
    
    // Initial update on page load
    updateFilters();
});
</script>
        <!-- Search Bar -->
<!-- Search Bar -->
<form method="GET" action="<?php echo e(route('admissions.list', $type)); ?>" class="mb-4">
    <div class="flex space-x-2">
        <div class="relative w-full">
            <input type="text" name="search" placeholder="Search by Army Number, Name"
                   value="<?php echo e(request('search')); ?>"
                   class="w-full border-gray-300 rounded-lg shadow-sm p-2 pl-10">
            <svg class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-gray-500"
                 xmlns="http://www.w3.org/2000/svg" fill="none"
                 viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M11 19a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm0 0l7 7"></path>
            </svg>
        </div>
        <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600">
            Search
        </button>
    </div>
</form>

<?php if(!empty($filteredArmyNumbers)): ?>
    <?php if($type !== 'tr'): ?>
        <!-- Show this for EPR or ISR, but NOT TR -->
        <form action="<?php echo e(route('report.generateMultiple')); ?>" method="POST" target="_blank">
            <?php echo csrf_field(); ?>
            <?php $__currentLoopData = $filteredArmyNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <input type="hidden" name="army_numbers[]" value="<?php echo e($number); ?>">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($type == 'epr'): ?>
                <input type="hidden" name="report_type" value="generate">
            <?php elseif($type == 'isr'): ?>
                <input type="hidden" name="report_type" value="generate2">
            <?php endif; ?>

            <button type="submit"
                    class="mt-3 bg-purple-600 text-white px-4 py-2 rounded hover:bg-purple-700">
                Generate Reports for All Filtered
            </button>
        </form>
    <?php endif; ?>
<?php endif; ?>

<!-- Show this ONLY when type == 'tr' -->
<?php if($admissions->count() > 0 && $type == 'tr'): ?>
    <form action="<?php echo e(route('reports.generate.all.transcripts')); ?>" method="POST" target="_blank" class="mb-4">
        <?php echo csrf_field(); ?>
        <!-- Pass all current filters -->
        <input type="hidden" name="school_id" value="<?php echo e(request('school_id')); ?>">
        <input type="hidden" name="course_id" value="<?php echo e(request('course_id')); ?>">
        <input type="hidden" name="intake_id" value="<?php echo e(request('intake_id')); ?>">
        <input type="hidden" name="bn" value="<?php echo e(request('bn')); ?>">
        <input type="hidden" name="coy" value="<?php echo e(request('coy')); ?>">
        <input type="hidden" name="pl" value="<?php echo e(request('pl')); ?>">
        <input type="hidden" name="sec" value="<?php echo e(request('sec')); ?>">
        <input type="hidden" name="search" value="<?php echo e(request('search')); ?>">

        <button type="submit"
                class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none"
                 viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z" />
            </svg>
            Print All Transcript Reports (<?php echo e($admissions->total()); ?>)
        </button>
    </form>
<?php endif; ?>



        <!-- Bulk Delete Form -->
        
            
            <div class="text-sm text-gray-700">
                Showing 
                <span class="font-medium"><?php echo e($admissions->firstItem() ?? 0); ?></span>
                to 
                <span class="font-medium"><?php echo e($admissions->lastItem() ?? 0); ?></span>
                of 
                <span class="font-medium"><?php echo e($admissions->total()); ?></span>
                results
            </div>
            <!-- Admissions Table -->
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                
                                <th class="px-6 py-3">#</th> <!-- Serial number column -->
                                <th class="px-6 py-3">
                                    <input type="checkbox" id="select-all" class="select-all-checkbox">
                                </th>
                        

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=admission_id&direction=<?php echo e(request('direction') == 'asc' ? 'desc' : 'asc'); ?>">
                                        Admission ID
                                        <?php if(request('sort') == 'admission_id'): ?>
                                            <?php if(request('direction') == 'asc'): ?>
                                                ▲
                                            <?php else: ?>
                                                ▼
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </a>
                                </th>

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=army_number&direction=<?php echo e(request('direction') == 'asc' ? 'desc' : 'asc'); ?>">
                                        Army Number
                                        <?php if(request('sort') == 'army_number'): ?>
                                            <?php if(request('direction') == 'asc'): ?>
                                                ▲
                                            <?php else: ?>
                                                ▼
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </a>
                                </th>
                                
                                
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Rank</th>

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=name&direction=<?php echo e(request('direction') == 'asc' ? 'desc' : 'asc'); ?>">
                                        Cadet Name
                                        <?php if(request('sort') == 'name'): ?>
                                            <?php if(request('direction') == 'asc'): ?>
                                                ▲
                                            <?php else: ?>
                                                ▼
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </a>
                                </th>
                            
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">School</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Course</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__currentLoopData = $admissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $admission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <!-- Adjusted numbering based on pagination -->
                                <td class="px-6 py-4"><?php echo e($admissions->firstItem() + $index); ?></td>
                                <td class="px-6 py-4">
                                    <input type="checkbox" name="selected_ids[]" value="<?php echo e($admission->id); ?>" class="select-item">
                                </td>
                                <td class="px-6 py-4"><?php echo e($admission->admission_id); ?></td>
                                <td class="px-6 py-4"><?php echo e($admission->army_number); ?></td>
                                <td class="px-6 py-4"><?php echo e($admission->rank); ?></td>
                                <td class="px-6 py-4"><?php echo e($admission->name); ?></td>
                                <td class="px-6 py-4"><?php echo e($admission->school->name); ?></td>
                                <td class="px-6 py-4"><?php echo e($admission->course->name); ?></td>
                       <td class="px-6 py-4">
    <div class="flex flex-col space-y-2">
        <!-- Generate Report Button -->
        <?php if($type == 'epr'): ?>
            <form action="<?php echo e(route('report.generate')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="army_number" value="<?php echo e($admission->army_number); ?>">
                <button type="submit" class="w-full bg-blue-500 text-white px-3 py-1.5 rounded hover:bg-blue-600 transition-colors flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    Generate EPR
                </button>
            </form>
        <?php endif; ?>

        <?php if($type == 'isr'): ?>
            <form action="<?php echo e(route('report.generate2')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="army_number" value="<?php echo e($admission->army_number); ?>">
                <button type="submit" class="w-full bg-blue-500 text-white px-3 py-1.5 rounded hover:bg-blue-600 transition-colors flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    Generate ISR
                </button>
            </form>
        <?php endif; ?>

        <?php if($type == 'tr'): ?>
            <form action="<?php echo e(route('report.generate3')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="army_number" value="<?php echo e($admission->army_number); ?>">
                <button type="submit" class="w-full bg-blue-500 text-white px-3 py-1.5 rounded hover:bg-blue-600 transition-colors flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    Generate TR
                </button>
            </form>
        <?php endif; ?>

        <!-- Add Remarks Button -->
        <a href="<?php echo e(route('remarks.create', $admission->id)); ?>" class="flex items-center justify-center bg-green-500 text-white px-3 py-1.5 rounded hover:bg-green-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
            </svg>
            Add Remarks
        </a>
    </div>
</td>
                                

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    
                    <!-- Pagination Links -->
                   
                    
                </div>
            </div>
        </form>

        <!-- Pagination -->
    <!-- Pagination -->

 
    <div>
        <?php echo e($admissions->withQueryString()->links()); ?>

    </div>

    </div>
</div>

<script>
    // Select all checkboxes logic
    document.addEventListener("DOMContentLoaded", function () {
        const selectAllCheckbox = document.getElementById('select-all');
        const rowCheckboxes = document.querySelectorAll('input[type="checkbox"].select-item');

        selectAllCheckbox.addEventListener("change", function () {
            rowCheckboxes.forEach(checkbox => {
                checkbox.checked = selectAllCheckbox.checked;
            });
        });

        rowCheckboxes.forEach(checkbox => {
            checkbox.addEventListener("change", function () {
                if (![...rowCheckboxes].some(chk => chk.checked)) {
                    selectAllCheckbox.checked = false;
                }
            });
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\admissions\index2.blade.php ENDPATH**/ ?>