

<?php $__env->startSection('content'); ?>

<div class="container mx-auto py-12">
    <h2 class="text-4xl font-bold text-gray-800 mb-8">Coy List</h2>

    <div class="mb-6 flex justify-between items-center">
        <a href="<?php echo e(route('coy.create')); ?>" class="bg-blue-600 text-white px-5 py-3 rounded-lg shadow-md hover:bg-blue-700 transition duration-200">Add Coy</a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-500 text-white p-5 mb-6 rounded-lg shadow-md">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="overflow-hidden border border-gray-300 rounded-lg shadow-lg">
        <table class="min-w-full bg-white">
            <thead class="bg-gray-100 border-b">
                <tr>
                    <th class="px-8 py-4 text-left font-semibold text-gray-700">ID</th>
                    <th class="px-8 py-4 text-left font-semibold text-gray-700">Coy</th>
               
                    <th class="px-8 py-4 text-left font-semibold text-gray-700">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $coy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="border-b hover:bg-gray-50 transition">
                        <td class="px-8 py-5"><?php echo e($school->id); ?></td>
                        <td class="px-8 py-5"><?php echo e($school->name); ?></td>
       
                        <td class="px-8 py-5 flex space-x-3">
                            <a href="<?php echo e(route('coy.edit', $school)); ?>" class="bg-yellow-500 text-white px-4 py-2 rounded-lg shadow-md hover:bg-yellow-600 transition">Edit</a>
                            <form action="<?php echo e(route('coy.destroy', $school)); ?>" method="POST" onsubmit="return confirm('Are you sure?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="bg-red-500 text-white px-4 py-2 rounded-lg shadow-md hover:bg-red-600 transition">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\coy\index.blade.php ENDPATH**/ ?>