

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="bg-white shadow-md rounded-lg overflow-hidden mt-6">
        <div class="flex items-center justify-between px-6 py-4 border-b border-gray-200">
            <h5 class="text-lg font-semibold text-gray-800">Edit Phase Configuration</h5>
            <a href="<?php echo e(route('phase-config.index')); ?>" class="bg-gray-500 text-white text-sm px-3 py-1.5 rounded hover:bg-gray-600 inline-flex items-center">
                <i class="fas fa-arrow-left mr-1"></i> Back to Phase Configurations
            </a>
        </div>

        <div class="px-6 py-4">
            <?php if($errors->any()): ?>
                <div class="bg-red-100 text-red-800 px-4 py-3 rounded mb-4">
                    <ul class="list-disc pl-5">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('phase-config.update', $phase->id)); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <!-- Phase Name -->
                <div class="mb-4">
                    <label for="phase_name" class="block font-medium text-sm text-gray-700">Phase Name</label>
                    <input id="phase_name" name="phase_name" type="text" value="<?php echo e(old('phase_name', $phase->phase_name)); ?>" required
                           class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 <?php $__errorArgs = ['phase_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <?php $__errorArgs = ['phase_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Section Configs -->
                <?php
                    $configs = [
                        'MSK Theory' => ['theory_max_score' => $phase->msk_theory_config['max_score'], 'theory_pass_mark' => $phase->msk_theory_config['pass_mark']],
                        'MSK Practical' => ['practical_max_score' => $phase->msk_practical_config['max_score'], 'practical_pass_mark' => $phase->msk_practical_config['pass_mark']],
                        'Character 22CR' => ['cr22_max_score' => $phase->character_22cr_config['max_score'], 'cr22_pass_mark' => $phase->character_22cr_config['pass_mark']],
                        'Character PR' => ['pr_max_score' => $phase->character_pr_config['max_score'], 'pr_pass_mark' => $phase->character_pr_config['pass_mark']],
                    ];
                ?>

                <?php $__currentLoopData = $configs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section => $fields): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <h5 class="text-lg font-semibold text-gray-700 mt-6 mb-3 border-b pb-2"><?php echo e($section); ?> Configuration</h5>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <?php $__currentLoopData = $fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div>
                                <label for="<?php echo e($name); ?>" class="block font-medium text-sm text-gray-700">
                                    <?php echo e(ucwords(str_replace('_', ' ', $name))); ?>

                                </label>
                                <input id="<?php echo e($name); ?>" name="<?php echo e($name); ?>" type="number" step="0.01"
                                       value="<?php echo e(old($name, $value)); ?>"
                                       class="mt-1 block w-full border border-gray-300 rounded-md shadow-sm p-2 <?php $__errorArgs = [$name];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <?php $__errorArgs = [$name];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <!-- Active Checkbox -->
                <div class="mt-6">
                    <label class="inline-flex items-center">
                        <input type="checkbox" name="is_active" id="is_active" value="1"
                               class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                               <?php echo e(old('is_active', $phase->is_active) ? 'checked' : ''); ?>>
                        <span class="ml-2 text-sm text-gray-600">Set as active phase (will deactivate any currently active phase)</span>
                    </label>
                </div>

                <!-- Buttons -->
                <div class="mt-6 flex gap-3">
                    <button type="submit"
                            class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700"
                            onclick="return confirm('Are you sure you want to update this phase configuration? This will affect student evaluation calculations.')">
                        <i class="fas fa-save mr-1"></i> Update Phase Configuration
                    </button>
                    <a href="<?php echo e(route('phase-config.index')); ?>" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">
                        <i class="fas fa-times mr-1"></i> Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views/phase-config/edit.blade.php ENDPATH**/ ?>