
<?php $__env->startSection('title', 'Edit Exercise'); ?>
<?php $__env->startSection('content'); ?>
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Edit Exercise Record</h2>
    <?php if($errors->any()): ?>
        <div class="bg-red-100 text-red-700 p-4 rounded-lg mb-4">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <p><?php echo e($error); ?></p>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('exercise.update', $record->id)); ?>" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="mb-4">
            <label for="title" class="block text-gray-700 font-semibold mb-2">Title</label>
            <input type="text" name="title" id="title" value="<?php echo e($record->title); ?>" class="w-full p-3 border border-gray-300 rounded" required>
        </div>

        <div class="mb-4">
            <label for="phase_id" class="block text-gray-700 font-semibold mb-2">Select Phase</label>
            <select name="phase_id" id="phase_id" class="w-full p-3 border border-gray-300 rounded" required>
                <option value="">Choose a Phase</option>
                <?php $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($id); ?>" <?php echo e(old('phase', $record->phase_id) == $id ? 'selected' : ''); ?>>
                        <?php echo e($name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>


        <div class="mb-4">
            <label for="weight" class="block text-gray-700 font-semibold mb-2">Weight</label>
            <input type="number" step="0.01" name="weight" id="weight" value="<?php echo e($record->weight); ?>" class="w-full p-3 border border-gray-300 rounded" required>
        </div>



        <div class="flex gap-4">
            <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Update Record</button>
            <a href="<?php echo e(route('exercise.index')); ?>" class="bg-gray-500 text-white px-6 py-3 rounded hover:bg-gray-600">Cancel</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\exercise\edit.blade.php ENDPATH**/ ?>