 

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto bg-white shadow-md rounded-lg p-6 mt-6">
    <h2 class="text-2xl font-bold mb-4 text-gray-800">Edit Admission</h2>
<!-- filepath: /c:/xampp8/htdocs/army_project2/army_project2/resources/views/admissions/edit.blade.php -->

<!-- System Information -->
<div class="bg-gray-50 p-6 rounded-lg">
    <h2 class="text-xl font-bold mb-4">System Information</h2>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <!-- Created Info -->
             <div>
            <label class="block font-semibold text-gray-700">Phase</label>
            <div class="mt-1">
                <p class="text-sm text-gray-600">Curent Phase : <?php echo e($phase->name ?? "N/A"); ?></p>
                
            </div>
        </div>
        <div>
            <label class="block font-semibold text-gray-700">Created</label>
            <div class="mt-1">
                <p class="text-sm text-gray-600">Date: <?php echo e($admission->created_at ? $admission->created_at->format('d M Y, h:i A') : 'N/A'); ?></p>
                
            </div>
        </div>

        <!-- Updated Info -->
        <div>
            <label class="block font-semibold text-gray-700">Last Updated</label>
            <div class="mt-1">
                <p class="text-sm text-gray-600">Date: <?php echo e($admission->updated_at ? $admission->updated_at->format('d M Y, h:i A') : 'N/A'); ?></p>
                
            </div>
        </div>

        <!-- Admission Year -->
        <div>
            <label class="block font-semibold text-gray-700">Admission Year</label>
            <p class="mt-1 text-sm text-gray-600"><?php echo e($admission->year_admission ?? 'N/A'); ?></p>
        </div>

        <?php if($admission->is_decommissioned): ?>
        <!-- Decommission Info -->
        <div class="md:col-span-3 border-t pt-4 mt-4">
            <label class="block font-semibold text-red-700">Discontinued</label>
            <div class="mt-1 grid grid-cols-1 md:grid-cols-3 gap-4">
                <p class="text-sm text-red-600">Date: <?php echo e($admission->decommission_date ? date('d M Y', strtotime($admission->decommission_date)) : 'N/A'); ?></p>
                <p class="text-sm text-red-600">By: <?php echo e($admission->decommissioner->name ?? 'N/A'); ?></p>
                <p class="text-sm text-red-600">Reason: <?php echo e($admission->decommission_reason ?? 'N/A'); ?></p>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
    <?php if($errors->any()): ?>
<div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6">
    <div class="flex">
        <div class="flex-shrink-0">
            <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
            </svg>
        </div>
        <div class="ml-3">
            <p class="text-sm text-red-700">
                Please correct the following errors:
            </p>
            <ul class="mt-2 text-sm text-red-700 list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
</div>
<?php endif; ?>
    <form action="<?php echo e(route('admissions.update', $admission->id)); ?>" method="POST" enctype="multipart/form-data" class="space-y-8">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <?php if($admission->is_decommissioned): ?>
  
        <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <h3 class="text-lg font-medium text-red-800">Profile Locked</h3>
                    <p class="text-sm text-red-700">This profile has been discontinued and cannot be updated.</p>
                    <a href="<?php echo e(route('admissions.index', $admission)); ?>" class="inline-block mt-2 text-sm text-blue-600 hover:text-blue-800">
                        Return to List
                    </a>
                </div>
            </div>
    <?php endif; ?>

        <!-- Military Information -->
        <div class="bg-gray-50 p-6 rounded-lg">
            <h2 class="text-xl font-bold mb-4">Military Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block font-semibold">Name</label>
<input type="text" name="name" value="<?php echo e(old('name', $admission->name)); ?>" class="w-full border-gray-300 rounded-lg p-2 bg-gray-100">
                </div>
                <div>
                    <label class="block font-semibold">Rank</label>
                    <input type="text" value="<?php echo e(old('rank', $admission->rank)); ?>" class="w-full border-gray-300 rounded-lg p-2 bg-gray-100" readonly>
                </div>
                <div>
                    <label class="block font-semibold">Army Number</label>
                    <input type="text" value="<?php echo e(old('army_number', $admission->army_number)); ?>" class="w-full border-gray-300 rounded-lg p-2 bg-gray-100" readonly>
                </div>
                <div>
                    <label for="image" class="block text-sm font-medium text-gray-700">Profile Image</label>
                    
                    <?php if(isset($admission) && $admission->image): ?>
                        <div class="mb-4">
                            <img src="http://localhost/army_project2/army_project2/public/<?php echo e($admission->image); ?>" 
                                 alt="Profile Image" 
                                 class="w-32 h-32 object-cover rounded-lg shadow">
                        </div>
                    <?php endif; ?>
                    
                    <input type="file" 
                           class="w-full border-gray-300 rounded-lg shadow-sm p-2" 
                           name="image" 
                           id="image"
                           accept="image/*"
                           onchange="previewImage(event)">
                    
                    <!-- Image Preview -->
                    <div id="imagePreview" class="mt-2 hidden">
                        <img src="" alt="Preview" class="w-32 h-32 object-cover rounded-lg shadow">
                    </div>
                </div>
            </div>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mt-4">
    <?php $__currentLoopData = ['bn' => 'Bn', 'coy' => 'Coy', 'pl' => 'Pl', 'sec' => 'Sec']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div>
        <label class="block font-semibold"><?php echo e($label); ?> <span class="text-red-500">*</span></label>
        <select name="<?php echo e($field); ?>" class="w-full border-gray-300 rounded-lg p-2" required>
            <option value="">Select <?php echo e($label); ?></option>

            <?php if($field == 'pl'): ?>
                <?php $__currentLoopData = ['1', '2', '3']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($option); ?>" <?php echo e(old($field, $admission->$field) == $option ? 'selected' : ''); ?>><?php echo e($option); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php elseif($field == 'sec'): ?>
                <?php $__currentLoopData = ['I', 'II', 'III']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($option); ?>" <?php echo e(old($field, $admission->$field) == $option ? 'selected' : ''); ?>><?php echo e($option); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <?php $__currentLoopData = $$field; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($option->name); ?>" <?php echo e(old($field, $admission->$field) == $option->name ? 'selected' : ''); ?>><?php echo e($option->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </select>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

        </div>

      <!-- Section 2: Academic Information -->
      <div class="bg-gray-50 p-6 rounded-lg">
        <h2 class="text-xl font-bold mb-4">Academic Information</h2>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <!-- School Dropdown -->
            <div>
                <label class="block font-semibold">School <span class="text-red-500">*</span></label>
                <select class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="school_id" required>
                    <option value="">Select School</option>
                    <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($school->id); ?>" <?php echo e($admission->school_id == $school->id ? 'selected' : ''); ?>>
                            <?php echo e($school->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <!-- Course Dropdown -->
            <div>
                <label class="block font-semibold">Course <span class="text-red-500">*</span></label>
                <select class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="course_id" required>
                    <option value="">Select Course</option>
                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($course->id); ?>" <?php echo e($admission->course_id == $course->id ? 'selected' : ''); ?>>
                            <?php echo e($course->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <!-- Subjects Dropdown (Multiple select) -->
            <div>
                <label for="subjects" class="block text-sm font-medium text-gray-700">Subjects:</label>
                <select class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="subjects[]" id="subjects" multiple required>
                    <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($subject->id); ?>" 
                            <?php echo e($admission->subjects->contains($subject->id) ? 'selected' : ''); ?>>
                            <?php echo e($subject->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <!-- Intake Dropdown -->
            <div>
                <label class="block font-semibold">Intake <span class="text-red-500">*</span></label>
                <select class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="intake_id" required>
                    <option value="">Select Intake</option>
                    <?php $__currentLoopData = $intakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $intake): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($intake->id); ?>" <?php echo e($admission->intake_id == $intake->id ? 'selected' : ''); ?>>
                            <?php echo e($intake->year); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>
    
    

    
        

        <!-- Personal Information -->
        <div class="bg-gray-50 p-6 rounded-lg">
            <h2 class="text-xl font-bold mb-4">Personal Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block font-semibold">Email</label>
                    <input type="email" name="email" value="<?php echo e(old('email', $admission->email)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Phone</label>
                    <input type="text" name="phone_number" value="<?php echo e(old('phone_number', $admission->phone_number)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Home District</label>
                    <input type="text" name="home_district" value="<?php echo e(old('home_district', $admission->home_district)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                <div>
                    <label class="block font-semibold">Village</label>
                    <input type="text" name="village" value="<?php echo e(old('village', $admission->village)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Next of Kin</label>
                    <input type="text" name="next_kin" value="<?php echo e(old('next_kin', $admission->next_kin)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>

                <div>
                    <label class="block font-semibold">Next of Kin Phone</label>
                    <input type="text" name="next_kin_phone"  value="<?php echo e(old('next_kin_phone', $admission->next_kin_phone)); ?>"   class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Next of Kin Relationship</label>
                    <input type="text" name="next_kin_rel" value="<?php echo e(old('next_kin_rel', $admission->next_kin_rel)); ?>"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
            </div>
        </div>

        <!-- Family Information -->
        <div class="bg-gray-50 p-6 rounded-lg">
            <h2 class="text-xl font-bold mb-4">Family Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block font-semibold">Father's Name</label>
                    <input type="text" name="father_name" value="<?php echo e(old('father_name', $admission->father_name)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Father's Phone</label>
                    <input type="text" name="father_phone" value="<?php echo e(old('father_phone', $admission->father_phone)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Mother's Name</label>
                    <input type="text" name="mother_name" value="<?php echo e(old('mother_name', $admission->mother_name)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Mother's Phone</label>
                    <input type="text" name="mother_phone" value="<?php echo e(old('mother_phone', $admission->mother_phone)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
            </div>
        </div>

        <!-- Additional Information -->
        <div class="bg-gray-50 p-6 rounded-lg">
            <h2 class="text-xl font-bold mb-4">Additional Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block font-semibold">Education Level</label>
                    <input type="text" name="education_level" value="<?php echo e(old('education_level', $admission->education_level)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Sex <span class="text-red-500">*</span></label>
                    <select name="sex" class="w-full border-gray-300 rounded-lg p-2" required>
                        <option value="">Select Sex</option>
                        <option value="M" <?php echo e(old('sex', $admission->sex) === 'M' ? 'selected' : ''); ?>>M</option>
                        <option value="F" <?php echo e(old('sex', $admission->sex) === 'F' ? 'selected' : ''); ?>>F</option>
                    </select>
                </div>
            
                <div>
                    <label class="block font-semibold">Spouse Name</label>
                    <input type="text" name="spouse_name" value="<?php echo e(old('spouse_name', $admission->spouse_name)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Spouse Phone</label>
                    <input type="text" name="spouse_phone" value="<?php echo e(old('spouse_phone', $admission->spouse_phone)); ?>" class="w-full border-gray-300 rounded-lg p-2">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-4">
                <div>
                    <label for="shoe_size" class="block text-sm font-medium text-gray-700">Shoe Size</label>
                    <input type="text" value="<?php echo e(old('shoe_size', $admission->shoe_size)); ?>" class="w-full border-gray-300 rounded-lg shadow-sm p-2" id="shoe_size" name="shoe_size">
                </div>
                <div>
                    <label for="nin" class="block text-sm font-medium text-gray-700">NIN</label>
                    <input type="text" value="<?php echo e(old('nin', $admission->nin)); ?>" class="w-full border-gray-300 rounded-lg shadow-sm p-2" id="nin" name="nin">
                </div>
               

                   <div>
                    <label for="country_origin" class="block text-sm font-medium text-gray-700">Country Of Origin</label>
                    <input type="text" value="<?php echo e(old('country_origin', $admission->country_origin)); ?>" class="w-full border-gray-300 rounded-lg shadow-sm p-2" id="country_origin" name="country_origin">
                </div>

      
               
                
            </div>
         <!-- Replace the existing decommission section with this -->
<div class="bg-red-50 p-6 rounded-lg hidden" id="decommissionSection">
    <h2 class="text-xl font-bold mb-4 text-red-700">Discontinued Information</h2>
    <input type="hidden" name="is_decommissioned" id="is_decommissioned" value="0">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
            <label class="block font-semibold">Discontinued Date <span class="text-red-500">*</span></label>
            <input type="date" 
            name="decommission_date" 
            id="decommission_date"
            class="w-full border-gray-300 rounded-lg p-2"
            value="<?php echo e(\Carbon\Carbon::parse($admission->created_at)->format('Y-m-d')); ?>">
        </div>
        <div>
            <label class="block font-semibold">Reason for Discontinued <span class="text-red-500">*</span></label>
            <select name="decommission_reason" 
                    id="decommission_reason"
                    class="w-full border-gray-300 rounded-lg p-2">
                <option value="">Select Reason</option>
                <option value="medical">Medical Grounds</option>
                <option value="disciplinary">Disciplinary Issues</option>
                <option value="voluntary">Voluntary Withdrawal</option>
                <option value="other">Other</option>
            </select>
        </div>
        <div class="md:col-span-2">
            <label class="block font-semibold">Additional Notes</label>
            <textarea name="decommission_notes" 
                      id="decommission_notes"
                      class="w-full border-gray-300 rounded-lg p-2" 
                      rows="3"></textarea>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const decommissionButton = document.getElementById('decommissionButton');
        const decommissionSection = document.getElementById('decommissionSection');
        const decommissionWarningModal = document.getElementById('decommissionWarningModal');
        const confirmDecommission = document.getElementById('confirmDecommission');
        const cancelDecommission = document.getElementById('cancelDecommission');
        const isDecommissionedInput = document.getElementById('is_decommissioned');
        const decommissionDateInput = document.getElementById('decommission_date');
        const decommissionReasonSelect = document.getElementById('decommission_reason');
    
        // Show warning modal when decommission button is clicked
        decommissionButton.addEventListener('click', function(e) {
            e.preventDefault();
            decommissionWarningModal.classList.remove('hidden');
        });
    
        // Handle confirmation
        confirmDecommission.addEventListener('click', function() {
            decommissionWarningModal.classList.add('hidden');
            decommissionSection.classList.remove('hidden');
            isDecommissionedInput.value = "1";
            
            // Set today's date as default
            const today = new Date().toISOString().split('T')[0];
            decommissionDateInput.value = today;
            
            // Make fields required
            decommissionDateInput.setAttribute('required', 'required');
            decommissionReasonSelect.setAttribute('required', 'required');
            
            // Scroll to decommission section
            decommissionSection.scrollIntoView({ behavior: 'smooth' });
        });
    
        // Handle cancellation
        cancelDecommission.addEventListener('click', function() {
            decommissionWarningModal.classList.add('hidden');
            decommissionSection.classList.add('hidden');
            isDecommissionedInput.value = "0";
            
            // Remove required attributes
            decommissionDateInput.removeAttribute('required');
            decommissionReasonSelect.removeAttribute('required');
        });
    });
    </script>
        </div>

        <?php if(!$admission->is_decommissioned): ?>
        <!-- Submit Button -->
        <button type="submit" class="w-full bg-green-500 text-white py-3 px-4 rounded-lg hover:bg-green-600 font-semibold">
            Update Admission
        </button>
        <button type="button" id="decommissionButton" class="bg-red-500 text-white py-3 px-4 rounded-lg hover:bg-red-600 font-semibold">
            Discontinued
        </button>
    <?php endif; ?>
    
    </form>
    <!-- Add this warning modal right after your form -->
<div id="decommissionWarningModal" class="fixed inset-0 bg-black bg-opacity-50 hidden flex items-center justify-center z-50">
    <div class="bg-white rounded-lg p-6 max-w-md w-full mx-4">
        <div class="text-center">
            <!-- Warning Icon -->
            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100 mb-4">
                <svg class="h-6 w-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                </svg>
            </div>
            
            <h3 class="text-lg font-bold text-gray-900 mb-2">⚠️ WARNING: Discontinued Cadet ⚠️</h3>
            
            <div class="text-sm text-gray-500 mb-4">
                <p class="font-bold text-red-600 mb-2">This action cannot be undone!</p>
                <p class="mb-2"> Discontinuing a cadet will:</p>
                <ul class="text-left list-disc pl-4 mb-4">
                    <li>Permanently remove them from active duty</li>
                    <li>Archive all their records</li>
                    <li>Prevent further updates</li>

                </ul>
                <p class="text-red-600 font-semibold">Are you absolutely sure you want to proceed?</p>
            </div>

            <div class="flex justify-center space-x-4">
                <button id="confirmDecommission" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 font-semibold">
                    Yes,  Discontinue
                </button>
                <button id="cancelDecommission" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400 font-semibold">
                    Cancel
                </button>
            </div>
        </div>
    </div>
</div>
</div>

<script>
    // Set the minimum date to the 'created_at' value (e.g., '2025-02-24')
    const createdAt = "<?php echo e(\Carbon\Carbon::parse($admission->created_at)->format('Y-m-d')); ?>"; // Replace with your PHP dynamic value
    const minDate = createdAt; 

    // Set the maximum date to today's date
    const today = new Date().toISOString().split('T')[0]; // 'YYYY-MM-DD' format

    // Set both 'min' and 'max' attributes
    const dateInput = document.getElementById('decommission_date');
    dateInput.setAttribute('min', minDate);
    dateInput.setAttribute('max', today);

document.addEventListener('DOMContentLoaded', function() {
    const decommissionButton = document.getElementById('decommissionButton');
    const decommissionSection = document.getElementById('decommissionSection');
    const decommissionWarningModal = document.getElementById('decommissionWarningModal');
    const confirmDecommission = document.getElementById('confirmDecommission');
    const cancelDecommission = document.getElementById('cancelDecommission');

    // Show warning modal when decommission button is clicked
    decommissionButton.addEventListener('click', function(e) {
        e.preventDefault();
        decommissionWarningModal.classList.remove('hidden');
    });

    // Handle confirmation
    confirmDecommission.addEventListener('click', function() {
        decommissionWarningModal.classList.add('hidden');
        decommissionSection.classList.remove('hidden');
    });

    // Handle cancellation
    cancelDecommission.addEventListener('click', function() {
        decommissionWarningModal.classList.add('hidden');
    });

    // Close modal when clicking outside
    decommissionWarningModal.addEventListener('click', function(e) {
        if (e.target === decommissionWarningModal) {
            decommissionWarningModal.classList.add('hidden');
        }
    });
});

function previewImage(event) {
    const input = event.target;
    const preview = document.getElementById('imagePreview');
    const previewImg = preview.querySelector('img');

    if (input.files && input.files[0]) {
        const reader = new FileReader();
        
        reader.onload = function(e) {
            previewImg.src = e.target.result;
            preview.classList.remove('hidden');
        }
        
        reader.readAsDataURL(input.files[0]);
    } else {
        preview.classList.add('hidden');
    }
}
    // Add this to your existing JavaScript
    document.addEventListener('DOMContentLoaded', function() {
        const nonUgandanToggle = document.getElementById('nonUgandanToggle');
        const ugandanFields = document.getElementById('ugandanFields');
        const nonUgandanFields = document.getElementById('nonUgandanFields');
        const isNonUgandan = document.getElementById('isNonUgandan');
        const armyNumberInput = document.getElementById('ArmyNumber');
        const decommissionButton = document.getElementById('decommissionButton');
        const decommissionSection = document.getElementById('decommissionSection');

        nonUgandanToggle.addEventListener('change', function() {
            ugandanFields.classList.toggle('hidden');
            nonUgandanFields.classList.toggle('hidden');
            isNonUgandan.value = this.checked ? "1" : "0";
            
            // Toggle required attribute for Army Number
            if (this.checked) {
                armyNumberInput.removeAttribute('required');
            } else {
                armyNumberInput.setAttribute('required', 'required');
            }
        });

        decommissionButton.addEventListener('click', function() {
            decommissionSection.classList.toggle('hidden');
        });
    });

    // ... rest of your existing JavaScript ...
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\army_project2\army_project2\resources\views\admissions\edit.blade.php ENDPATH**/ ?>