<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TRADOC Portal - Training & Doctrine (UPDF)</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .army-green-900 { background-color: #1a3c1a; }
        .army-green-800 { background-color: #2a4d2a; }
        .army-green-700 { background-color: #3a5d3a; }
        .army-green-600 { background-color: #4a6d4a; }
        .army-green-500 { background-color: #5a7d5a; }
        .army-green-400 { background-color: #6a8d6a; }
        .army-green-300 { background-color: #7a9d7a; }
        .army-green-200 { background-color: #8aad8a; }
        .army-green-100 { background-color: #9abd9a; }
        .army-green-50 { background-color: #aacdaa; }
        
        .text-army-green-900 { color: #1a3c1a; }
        .text-army-green-800 { color: #2a4d2a; }
        .text-army-green-700 { color: #3a5d3a; }
        .text-army-green-600 { color: #4a6d4a; }
        .text-army-green-500 { color: #5a7d5a; }
        
        .bg-army-green-900 { background-color: #1a3c1a; }
        .bg-army-green-800 { background-color: #2a4d2a; }
        .bg-army-green-700 { background-color: #3a5d3a; }
        .bg-army-green-600 { background-color: #4a6d4a; }
        .bg-army-green-500 { background-color: #5a7d5a; }
        .bg-army-green-400 { background-color: #6a8d6a; }
        .bg-army-green-300 { background-color: #7a9d7a; }
        .bg-army-green-200 { background-color: #8aad8a; }
        .bg-army-green-100 { background-color: #9abd9a; }
        .bg-army-green-50 { background-color: #aacdaa; }
        
        .border-army-green-200 { border-color: #8aad8a; }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <nav class="bg-army-green-900 text-white">
        <div class="container mx-auto px-4">
            <div class="flex items-center justify-between py-4">
                <div class="flex items-center space-x-3">
                    <i class="fas fa-shield-alt text-2xl text-green-300"></i>
                    <div>
                        <h1 class="text-xl font-bold">TRADOC PORTAL</h1>
                        <p class="text-xs text-gray-300">Training & Doctrine Command</p>
                    </div>
                </div>
                
                <!-- Desktop Navigation -->
                <div class="hidden md:flex space-x-1">
                    <a href="#" class="px-4 py-2 hover:bg-army-green-800 rounded">
                        <i class="fas fa-home mr-2"></i>Home
                    </a>

      <a href="#" class="px-4 py-2 hover:bg-army-green-800 rounded">
                        <i class="fas fa-file-contract mr-2"></i>Doctrine
                    </a>
              
                    <div class="relative group">
                        <a href="#" class="px-4 py-2 hover:bg-army-green-800 rounded inline-flex items-center">
                            <i class="fas fa-graduation-cap mr-2"></i>Training Schools
                            <i class="fas fa-chevron-down ml-1 text-xs"></i>
                        </a>
                        <div class="absolute bg-white text-gray-800 shadow-lg w-64 rounded invisible group-hover:visible z-10">
                       
                            <a href="https://strart.wimservices.com/public/" class="block px-6 py-3 hover:bg-army-green-50 border-b">
                                <i class=" text-yellow-500 mr-2"></i>Strart
                            </a>
                           
                        </div>
      <a href="#" class="px-4 py-2 hover:bg-army-green-800 rounded">
                        <i class="fas fa-book mr-2"></i>Library
                    </a>
                    </div>
              
                </div>
                
                <!-- Mobile Menu Button -->
                <button id="mobile-menu-button" class="md:hidden text-white">
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </div>
            
            <!-- Mobile Navigation -->
            <div id="mobile-menu" class="md:hidden bg-army-green-800 rounded-b-lg overflow-hidden hidden">
                <a href="#" class="block px-4 py-3 hover:bg-army-green-700 border-b border-army-green-700">
                    <i class="fas fa-home mr-3"></i>Home
                </a>
       <a href="#" class="block px-8 py-3 hover:bg-army-green-600 border-b border-army-green-600">
                            <i class="fas fa-university mr-3"></i>Doctrine
                        </a>
        
                <div>
                    <div class="px-4 py-3 hover:bg-army-green-700 border-b border-army-green-700 flex justify-between items-center">
                        <span><i class="fas fa-graduation-cap mr-3"></i>Training Schools</span>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="bg-army-green-700">
                 
                 
                    </div>
                </div>
             <a href="#" class="block px-4 py-3 hover:bg-army-green-700 border-b border-army-green-700">
                    <i class="fas fa-book mr-3"></i>Library
                </a>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="relative bg-gray-900 text-white overflow-hidden">
        <div class="absolute inset-0 z-0">
            <div class="absolute inset-0 bg-gradient-to-r from-army-green-900/90 to-army-green-700/90"></div>
        </div>

        <div class="relative z-10 max-w-7xl mx-auto px-4 py-16 text-center">
            <h1 class="text-4xl md:text-5xl font-bold mb-4">TRADOC Portal</h1>
            <p class="text-xl md:text-2xl mb-6 opacity-90">
                <strong>Training & Doctrine Command</strong><br>
                <span class="text-green-200">Uganda People's Defence Forces (UPDF)</span>
            </p>
            <p class="text-lg max-w-3xl mx-auto mb-8 opacity-85">
                Centralized platform for military training resources, doctrine publications, and operational excellence.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
           
                <a href="#" 
                   class="border-2 border-white text-white px-6 py-3 rounded-lg font-semibold hover:bg-white hover:text-army-green-800 transition duration-300">
                    <i class="fas fa-book mr-2"></i>Explore Resources
                </a>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-12 bg-white">
        <div class="max-w-7xl mx-auto px-4">
            <div class="text-center mb-10">
                <h2 class="text-3xl font-bold text-gray-900 mb-3">Portal Features</h2>
                <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                    Access training resources and tools supporting military education and operational readiness.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Training Manuals -->
                <div class="bg-gray-50 rounded-xl p-5 hover:shadow-lg transition duration-300 border border-gray-200">
                    <div class="w-10 h-10 bg-army-green-100 rounded-lg flex items-center justify-center mb-4">
                        <i class="fas fa-book text-army-green-600"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Training Manuals</h3>
                    <p class="text-gray-600 text-sm mb-3">
                        Structured training materials for military operations and tactics.
                    </p>
                    <a href="#" class="text-army-green-600 hover:text-army-green-700 font-medium text-sm">
                        Explore Manuals →
                    </a>
                </div>

       

                <!-- Doctrine Publications -->
                <div class="bg-gray-50 rounded-xl p-5 hover:shadow-lg transition duration-300 border border-gray-200">
                    <div class="w-10 h-10 bg-army-green-100 rounded-lg flex items-center justify-center mb-4">
                        <i class="fas fa-file-alt text-army-green-600"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Doctrine</h3>
                    <p class="text-gray-600 text-sm mb-3">
                        Military doctrine, policies and standard procedures.
                    </p>
                    <a href="#" class="text-army-green-600 hover:text-army-green-700 font-medium text-sm">
                        View Doctrine →
                    </a>
                </div>

                <!-- Training Schools -->
                <div class="bg-gray-50 rounded-xl p-5 hover:shadow-lg transition duration-300 border border-gray-200">
                    <div class="w-10 h-10 bg-army-green-100 rounded-lg flex items-center justify-center mb-4">
                        <i class="fas fa-graduation-cap text-army-green-600"></i>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-2">Training Schools</h3>
                    <p class="text-gray-600 text-sm mb-3">
                        UPDF training institutions and programs directory.
                    </p>
                    <a href="#" class="text-army-green-600 hover:text-army-green-700 font-medium text-sm">
                        Visit Schools →
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- IITS Highlight -->


    <!-- Footer -->
    <footer class="bg-army-green-900 text-white py-8">
        <div class="container mx-auto px-4">
            <div class="text-center">
                <div class="flex justify-center items-center space-x-4 mb-4">
                    <i class="fas fa-shield-alt text-2xl text-green-300"></i>
                    <h3 class="text-xl font-bold">TRADOC PORTAL</h3>
                </div>
                <p class="mb-2">Training & Doctrine Command - UPDF</p>
                <p class="text-sm text-gray-300">© 2025 Ministry of Defence & Veteran Affairs</p>
                <p class="text-xs text-gray-400 mt-4">For authorized military personnel only</p>
            </div>
        </div>
    </footer>

    <script>
        // Mobile menu toggle
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const mobileMenu = document.getElementById('mobile-menu');
        
        mobileMenuButton.addEventListener('click', function() {
            if (mobileMenu.classList.contains('hidden')) {
                mobileMenu.classList.remove('hidden');
                mobileMenuButton.innerHTML = '<i class="fas fa-times text-xl"></i>';
            } else {
                mobileMenu.classList.add('hidden');
                mobileMenuButton.innerHTML = '<i class="fas fa-bars text-xl"></i>';
            }
        });
    </script>
</body>
</html>