@extends('layouts.app')

@section('content')
<div class="container mx-auto py-8">

    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">Subject</h1>
            <p class="text-gray-600">Manage subjects, including creating, edit, and deleted</p>
        </div>
    </div>
    



    <a href="{{ route('subjects.create') }}" class="bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600 mb-4 inline-block">Add Subject</a>

    @if(session('success'))
        <div class="bg-green-500 text-white p-4 mb-4 rounded">
            {{ session('success') }}
        </div>
    @endif

    <table class="min-w-full bg-white border border-gray-300 rounded-lg mt-6">
        <thead>
            <tr>
                <th class="px-6 py-3 text-left">Subject ID</th>
                <th class="px-6 py-3 text-left">Subject Name</th>
                 
                <th class="px-6 py-3 text-left">Code</th>
                <th class="px-6 py-3 text-left">Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($subjects as $subject)
                <tr class="border-b border-gray-200">
                    <td class="px-6 py-4">{{ $subject->id }}</td> 
                    <td class="px-6 py-4">{{ $subject->name }}</td>
                    <td class="px-6 py-4">{{ $subject->code }}</td>
                    {{-- <td class="px-6 py-4">{{ $subject->course->name }}</td> --}}
                    <td class="px-6 py-4">
                        <a href="{{ route('subjects.edit', $subject) }}" class="bg-yellow-500 text-white px-3 py-2 rounded hover:bg-yellow-600">Edit</a>
                        <form action="{{ route('subjects.destroy', $subject) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="bg-red-500 text-white px-3 py-2 rounded hover:bg-red-600">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
