@extends('layouts.app')

@section('content')
<div class="container mx-auto py-8">
    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Edit Subject</h2>

    <form action="{{ route('subjects.update', $subject) }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        @csrf
        @method('PUT')
        <div class="mb-4">
            <label for="name" class="block text-gray-700 font-semibold mb-2">Subject Name</label>
            <input type="text" name="name" id="name" value="{{ old('name', $subject->name) }}" class="w-full p-3 border border-gray-300 rounded" required>
        </div>
        <div class="mb-4">
            <label for="code" class="block text-gray-700 font-semibold mb-2">Code</label>
            <input type="text" name="code" id="code" value="{{ old('code', $subject->code) }}" class="w-full p-3 border border-gray-300 rounded" required>
        </div>
        <div class="mb-4">
            <label for="weight" class="block text-gray-700 font-semibold mb-2">Weight</label>
            <input type="number" name="weight" id="weight" value="{{ old('weight', $subject->weight) }}" class="w-full p-3 border border-gray-300 rounded" required>
        </div>
        <div class="mb-4">
            <label for="course_id" class="block text-gray-700 font-semibold mb-2">Course</label>
            <select name="course_id" id="course_id" class="w-full p-3 border border-gray-300 rounded" required>
                @foreach($courses as $course)
                    <option value="{{ $course->id }}" {{ $subject->course_id == $course->id ? 'selected' : '' }}>
                        {{ $course->name }}
                    </option>
                @endforeach
            </select>
        </div>
        <div class="mb-4">
            <label for="phase_id" class="block text-gray-700 font-semibold mb-2">Phase</label>
            <select name="phase_id" id="phase_id" class="w-full p-3 border border-gray-300 rounded" required>
                @foreach($phases as $phase)
                    <option value="{{ $phase->id }}" {{ $subject->phase_id == $phase->id ? 'selected' : '' }}>
                        {{ $phase->name }}
                    </option>
                @endforeach
            </select>
        </div>
        <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Update Subject</button>
    </form>
</div>
@endsection
