<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Logging In - Please Wait</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            background: linear-gradient(135deg, #0d6efd, #0a58ca);
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            padding: 20px;
        }

        .loading-container {
            background: #ffffff;
            border-radius: 16px;
            padding: 40px;
            max-width: 520px;
            width: 100%;
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.2);
            text-align: center;
            animation: fadeIn 0.6s ease-in-out;
        }

        .logo-section {
            margin-bottom: 20px;
        }

        .logo-section img {
            max-width: 80px;
            height: auto;
        }

        h2 {
            margin-top: 10px;
            margin-bottom: 10px;
            font-weight: 700;
            color: #0d6efd;
            font-size: 1.75rem;
        }

        .subtitle {
            color: #6c757d;
            font-size: 0.95rem;
            margin-bottom: 25px;
        }

        .loader {
            position: relative;
            width: 90px;
            height: 90px;
            margin: 0 auto 20px;
        }

        .loader-circle {
            position: absolute;
            inset: 0;
            border: 4px solid rgba(13, 110, 253, 0.2);
            border-top-color: #0d6efd;
            border-radius: 50%;
            animation: spin 1.2s linear infinite;
        }

        .loader-inner {
            position: absolute;
            inset: 12px;
            border-radius: 50%;
            background: rgba(13, 110, 253, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .loader-checkmark {
            font-size: 32px;
            color: #0d6efd;
            display: none;
        }

        .loader.complete .loader-circle {
            animation: none;
            border-color: #28a745;
        }

        .loader.complete .loader-checkmark {
            display: block;
        }

        .progress {
            height: 10px;
            border-radius: 10px;
            overflow: hidden;
            margin-bottom: 15px;
        }

        .progress-bar {
            transition: width 0.6s ease;
            background: linear-gradient(90deg, #0d6efd, #0a58ca);
        }

        .status-message {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 15px;
            margin-top: 20px;
            text-align: left;
            font-size: 0.95rem;
            border-left: 4px solid #0d6efd;
        }

        .status-message .spinner-border {
            width: 1.2rem;
            height: 1.2rem;
            border-width: 2px;
        }

        .status-message strong {
            margin-left: 10px;
            color: #0d6efd;
            font-size: 1rem;
        }

        .status-message p {
            margin-top: 8px;
            margin-bottom: 0;
            color: #6c757d;
            font-size: 0.9rem;
        }

        .user-info {
            background: linear-gradient(135deg, #eef4ff, #e3f2fd);
            border-left: 4px solid #0d6efd;
            border-radius: 10px;
            padding: 20px;
            margin-top: 20px;
            text-align: left;
            font-size: 0.9rem;
        }

        .user-info h5 {
            font-weight: 600;
            margin-bottom: 15px;
            color: #0d6efd;
            font-size: 1rem;
            display: flex;
            align-items: center;
        }

        .user-info h5 svg {
            margin-right: 8px;
        }

        .user-info-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid rgba(13, 110, 253, 0.1);
        }

        .user-info-row:last-child {
            border-bottom: none;
        }

        .user-info-label {
            font-weight: 600;
            color: #495057;
        }

        .user-info-value {
            color: #212529;
            text-align: right;
        }

        .progress-text {
            margin-top: 10px;
            font-size: 0.85rem;
            color: #6c757d;
            font-weight: 500;
        }

        .error-message {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            border-radius: 10px;
            padding: 15px;
            margin-top: 15px;
            text-align: left;
            display: none;
        }

        .error-message.show {
            display: block;
        }

        .security-badge {
            display: inline-flex;
            align-items: center;
            background: #d1e7dd;
            color: #0f5132;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-top: 15px;
        }

        .security-badge svg {
            margin-right: 5px;
        }

        @keyframes spin {
            100% {
                transform: rotate(360deg);
            }
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(15px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.6;
            }
        }

        .pulse {
            animation: pulse 2s ease-in-out infinite;
        }
    </style>
</head>
<body>
    <div class="loading-container">
        <!-- Optional Logo Section -->
        <div class="logo-section">
            <!-- Add your logo here -->
            <!-- <img src="/path/to/logo.png" alt="Logo"> -->
        </div>

        <div class="loader" id="loader">
            <div class="loader-circle"></div>
            <div class="loader-inner">
                <span class="loader-checkmark">✓</span>
            </div>
        </div>
        
        <h2>Setting Up Your Account</h2>
        <p class="subtitle">Securely authenticating your credentials...</p>
        
        <div class="progress mb-3">
            <div class="progress-bar progress-bar-striped progress-bar-animated" 
                 role="progressbar" 
                 style="width: 0%" 
                 id="progressBar"
                 aria-valuenow="0" 
                 aria-valuemin="0" 
                 aria-valuemax="100">
            </div>
        </div>
        
        <div class="progress-text">
            <span id="progressText">0% Complete</span>
        </div>
        
        <div class="status-message">
            <div class="d-flex align-items-center mb-2">
                <div class="spinner-border text-primary" role="status" id="statusSpinner">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <strong id="currentStep">Initializing...</strong>
            </div>
            <p id="stepDetails">Starting secure authentication process</p>
        </div>
        
        @if(isset($mcopUser))
        <div class="user-info">
            <h5>
                <svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M8 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm2-3a2 2 0 1 1-4 0 2 2 0 0 1 4 0zm4 8c0 1-1 1-1 1H3s-1 0-1-1 1-4 6-4 6 3 6 4zm-1-.004c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664h10z"/>
                </svg>
                Authenticated User
            </h5>
            
            <div class="user-info-row">
                <span class="user-info-label">Name:</span>
                <span class="user-info-value">{{ $mcopUser['full_name'] ?? 'N/A' }}</span>
            </div>
            
            <div class="user-info-row">
                <span class="user-info-label">Army Number:</span>
                <span class="user-info-value">{{ $mcopUser['army_number'] ?? 'N/A' }}</span>
            </div>
            
            @if(isset($mcopUser['rank']) && !empty($mcopUser['rank']))
            <div class="user-info-row">
                <span class="user-info-label">Rank:</span>
                <span class="user-info-value">{{ $mcopUser['rank'] }}</span>
            </div>
            @endif
            
            @if(isset($mcopUser['unit']) && !empty($mcopUser['unit']))
            <div class="user-info-row">
                <span class="user-info-label">Unit:</span>
                <span class="user-info-value">{{ $mcopUser['unit'] }}</span>
            </div>
            @endif
            
            @if(isset($mcopUser['department']) && !empty($mcopUser['department']))
            <div class="user-info-row">
                <span class="user-info-label">Department:</span>
                <span class="user-info-value">{{ strtoupper($mcopUser['department']) }}</span>
            </div>
            @endif
        </div>
        @endif
        
        <div class="error-message" id="errorMessage">
            <strong>⚠️ Notice:</strong>
            <p id="errorText">Taking longer than expected. Please wait...</p>
        </div>
        
        <div class="security-badge">
            <svg width="14" height="14" fill="currentColor" viewBox="0 0 16 16">
                <path d="M5.338 1.59a61.44 61.44 0 0 0-2.837.856.481.481 0 0 0-.328.39c-.554 4.157.726 7.19 2.253 9.188a10.725 10.725 0 0 0 2.287 2.233c.346.244.652.42.893.533.12.057.218.095.293.118a.55.55 0 0 0 .101.025.615.615 0 0 0 .1-.025c.076-.023.174-.061.294-.118.24-.113.547-.29.893-.533a10.726 10.726 0 0 0 2.287-2.233c1.527-1.997 2.807-5.031 2.253-9.188a.48.48 0 0 0-.328-.39c-.651-.213-1.75-.56-2.837-.855C9.552 1.29 8.531 1.067 8 1.067c-.53 0-1.552.223-2.662.524zM5.072.56C6.157.265 7.31 0 8 0s1.843.265 2.928.56c1.11.3 2.229.655 2.887.87a1.54 1.54 0 0 1 1.044 1.262c.596 4.477-.787 7.795-2.465 9.99a11.775 11.775 0 0 1-2.517 2.453 7.159 7.159 0 0 1-1.048.625c-.28.132-.581.24-.829.24s-.548-.108-.829-.24a7.158 7.158 0 0 1-1.048-.625 11.777 11.777 0 0 1-2.517-2.453C1.928 10.487.545 7.169 1.141 2.692A1.54 1.54 0 0 1 2.185 1.43 62.456 62.456 0 0 1 5.072.56z"/>
                <path d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0z"/>
            </svg>
            Secure Connection
        </div>
        
        <!-- Hidden form to auto-submit -->
        <form id="processForm" action="{{ route('sso.process') }}" method="GET" style="display: none;">
            @csrf
            <input type="hidden" name="loading" value="true">
        </form>
    </div>

    <script>
        // Configuration
        const STEP_DURATION = 800; // milliseconds per step
        const TOTAL_STEPS = 6;
        const PROGRESS_INCREMENT = 100 / TOTAL_STEPS;
        const MAX_WAIT_TIME = 10000; // 10 seconds max
        const TIMEOUT_WARNING_TIME = 7000; // Show warning after 7 seconds
        
        // Progress steps
        const steps = [
            {step: "Validating token...", detail: "Verifying authentication credentials"},
            {step: "Loading user data...", detail: "Retrieving your profile information"},
            {step: "Checking account status...", detail: "Validating account permissions"},
            {step: "Setting up profile...", detail: "Configuring user preferences"},
            {step: "Preparing dashboard...", detail: "Loading application components"},
            {step: "Finalizing...", detail: "Completing authentication process"}
        ];
        
        // DOM elements
        const progressBar = document.getElementById('progressBar');
        const progressText = document.getElementById('progressText');
        const currentStep = document.getElementById('currentStep');
        const stepDetails = document.getElementById('stepDetails');
        const processForm = document.getElementById('processForm');
        const errorMessage = document.getElementById('errorMessage');
        const errorText = document.getElementById('errorText');
        const loader = document.getElementById('loader');
        const statusSpinner = document.getElementById('statusSpinner');
        
        // State
        let progress = 0;
        let currentStepIndex = 0;
        let startTime = Date.now();
        
        /**
         * Update progress bar and step information
         */
        function updateProgress() {
            // Update step text
            if (currentStepIndex < steps.length) {
                currentStep.textContent = steps[currentStepIndex].step;
                stepDetails.textContent = steps[currentStepIndex].detail;
                currentStepIndex++;
            }
            
            // Update progress bar
            progress += PROGRESS_INCREMENT;
            if (progress > 100) progress = 100;
            
            progressBar.style.width = progress + '%';
            progressBar.setAttribute('aria-valuenow', Math.round(progress));
            progressText.textContent = Math.round(progress) + '% Complete';
            
            // Check if we should show timeout warning
            const elapsed = Date.now() - startTime;
            if (elapsed > TIMEOUT_WARNING_TIME && progress < 100) {
                showTimeoutWarning();
            }
            
            // Continue or complete
            if (progress < 100) {
                setTimeout(updateProgress, STEP_DURATION);
            } else {
                completeProgress();
            }
        }
        
        /**
         * Show timeout warning message
         */
        function showTimeoutWarning() {
            errorText.textContent = 'Taking longer than expected. Please wait, we\'re still processing...';
            errorMessage.classList.add('show');
        }
        
        /**
         * Complete the progress and submit form
         */
        function completeProgress() {
            currentStep.textContent = "Authentication Complete!";
            stepDetails.textContent = "Redirecting to your dashboard...";
            
            // Update loader to show completion
            loader.classList.add('complete');
            progressBar.classList.remove('progress-bar-animated');
            progressBar.style.width = '100%';
            
            // Hide spinner
            if (statusSpinner) {
                statusSpinner.style.display = 'none';
            }
            
            // Submit form after brief delay
            setTimeout(() => {
                submitForm();
            }, 1000);
        }
        
        /**
         * Submit the form to process login
         */
        function submitForm() {
            try {
                processForm.submit();
            } catch (error) {
                console.error('Form submission error:', error);
                showError('Failed to proceed. Redirecting...');
                // Fallback: redirect manually
                setTimeout(() => {
                    window.location.href = '{{ route("sso.process") }}?loading=true';
                }, 2000);
            }
        }
        
        /**
         * Show error message
         */
        function showError(message) {
            errorText.textContent = message;
            errorMessage.classList.add('show');
        }
        
        /**
         * Initialize progress animation
         */
        function initialize() {
            console.log('Loading page initialized');
            
            // Start progress after brief delay
            setTimeout(updateProgress, 100);
            
            // Failsafe: auto-submit after MAX_WAIT_TIME
            setTimeout(() => {
                if (progress < 100) {
                    console.warn('Max wait time reached, forcing submission');
                    showError('Processing is taking longer than expected. Proceeding anyway...');
                    setTimeout(submitForm, 2000);
                }
            }, MAX_WAIT_TIME);
        }
        
        // Handle page visibility changes (user switches tabs)
        document.addEventListener('visibilitychange', function() {
            if (document.hidden) {
                console.log('Page hidden');
            } else {
                console.log('Page visible again');
            }
        });
        
        // Prevent accidental page navigation
        window.addEventListener('beforeunload', function(e) {
            if (progress < 100) {
                const message = 'Authentication is in progress. Are you sure you want to leave?';
                e.returnValue = message;
                return message;
            }
        });
        
        // Start the process
        initialize();
    </script>
</body>
</html>