@extends('layouts.app')

@section('content')
    <div class="container mx-auto py-8">
        <h2 class="text-3xl font-semibold text-gray-800 mb-6">Edit Section</h2>

        {{-- Display Validation Errors --}}
        @if ($errors->any())
            <div class="bg-red-100 text-red-700 p-4 rounded-lg mb-4">
                <strong>Whoops! Something went wrong.</strong>
                <ul class="mt-2">
                    @foreach ($errors->all() as $error)
                        <li>- {{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- Success & Error Messages --}}
        @if (session('error'))
            <div class="mb-4 p-4 bg-red-100 text-red-700 rounded-lg">
                <strong>Error:</strong> {{ session('error') }}
            </div>
        @endif

        @if (session('success'))
            <div class="mb-4 p-4 bg-green-100 text-green-700 rounded-lg">
                <strong>Success:</strong> {{ session('success') }}
            </div>
        @endif

        {{-- Form --}}
        <form action="{{ route('sec.update', $sec->id) }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
            @csrf
            @method('PUT')

            {{-- Grid Layout for the Fields --}}
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">

                {{-- Select Battalion --}}
                <div class="mb-4">
                    <label for="bn_id" class="block text-gray-700 font-semibold mb-2">Select Bn</label>
                    <select name="bn_id" id="bn_id" class="w-full p-3 border border-gray-300 rounded" required>
                        <option value="">Choose a Bn</option>
                        @foreach($bns as $bn)
                            <option value="{{ $bn->id }}" {{ $sec->pl->coy->bn_id == $bn->id ? 'selected' : '' }}>{{ $bn->name }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- Select Company --}}
                <div class="mb-4">
                    <label for="coy_id" class="block text-gray-700 font-semibold mb-2">Select Coy</label>
                    <select name="coy_id" id="coy_id" class="w-full p-3 border border-gray-300 rounded" required>
                        <option value="">Choose a Coy</option>
                        @foreach($coys->where('bn_id', $sec->pl->coy->bn_id) as $coy)
                            <option value="{{ $coy->id }}" {{ $sec->pl->coy_id == $coy->id ? 'selected' : '' }}>{{ $coy->name }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- Select Platoon --}}
                <div class="mb-4">
                    <label for="pl_id" class="block text-gray-700 font-semibold mb-2">Select Pl</label>
                    <select name="pl_id" id="pl_id" class="w-full p-3 border border-gray-300 rounded" required>
                        <option value="">Choose a Pl</option>
                        @foreach($pls->where('coy_id', $sec->pl->coy_id) as $pl)
                            <option value="{{ $pl->id }}" {{ $sec->pl_id == $pl->id ? 'selected' : '' }}>{{ $pl->name }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- Section Name (I, II, III) --}}
                <div class="mb-4">
                    <label for="name" class="block text-gray-700 font-semibold mb-2">Sec Name</label>
                    <select name="name" id="name" class="w-full p-3 border border-gray-300 rounded" required>
                        <option value="">Select Section</option>
                        <option value="I" {{ $sec->name == 'I' ? 'selected' : '' }}>I</option>
                        <option value="II" {{ $sec->name == 'II' ? 'selected' : '' }}>II</option>
                        <option value="III" {{ $sec->name == 'III' ? 'selected' : '' }}>III</option>
                    </select>
                </div>

                {{-- Section Commander's Rank --}}
                <div class="mb-4">
                    <label for="comd_rank" class="block text-gray-700 font-medium mb-2">Comd Rank</label>
                    <select name="comd_rank" id="comd_rank" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
                        @php
                            $ranks = [
                                'Gen', 'Lt Gen', 'Maj Gen', 'Brig Gen', 'Col', 'Lt Col', 'Maj', 'Capt',
                                'Lt', '2Lt', 'JO1', 'JO2', 'O/Cdt', 'WO1', 'WO2', 'S/Sgt', 'Sgt', 'Cpl',
                                'L/Cpl', 'Pte'
                            ];
                        @endphp
                        @foreach($ranks as $rank)
                            <option value="{{ $rank }}" {{ $sec->comd_rank == $rank ? 'selected' : '' }}>{{ $rank }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- Section Commander's Name --}}
                <div class="mb-4">
                    <label for="comd_name" class="block text-gray-700 font-semibold mb-2">Sec Comd Name</label>
                    <input type="text" name="comd_name" id="comd_name" value="{{ $sec->comd_name }}" class="w-full p-3 border border-gray-300 rounded" required>
                </div>

            </div>

            {{-- Action Buttons --}}
            <div class="flex flex-col sm:flex-row gap-4 mt-6">
                <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600 flex-1">Update Sec</button>
                <a href="{{ route('bn.index') }}" class="bg-gray-500 text-white px-6 py-3 rounded hover:bg-gray-600 text-center flex-1">Cancel</a>
            </div>
        </form>
    </div>
@endsection

@push('scripts')
<script>
    // When the Bn is selected, make an AJAX request to get the corresponding Coys
    $('#bn_id').on('change', function() {
        var bn_id = $(this).val();
        
        if (bn_id) {
            $.ajax({
                url: '{{ route('getCoysByBn') }}',
                type: 'GET',
                data: { bn_id: bn_id },
                success: function(data) {
                    $('#coy_id').empty(); // Clear existing Coy options
                    $('#coy_id').append('<option value="">Choose a Coy</option>'); // Add default option
                    $.each(data, function(key, value) {
                        $('#coy_id').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                    
                    // Also clear the platoon dropdown when battalion changes
                    $('#pl_id').empty();
                    $('#pl_id').append('<option value="">Choose a Pl</option>');
                }
            });
        } else {
            $('#coy_id').empty();
            $('#coy_id').append('<option value="">Choose a Coy</option>');
            $('#pl_id').empty();
            $('#pl_id').append('<option value="">Choose a Pl</option>');
        }
    });
    
    // When the Coy is selected, make an AJAX request to get the corresponding Platoons
    $('#coy_id').on('change', function() {
        var coy_id = $(this).val();
        
        if (coy_id) {
            $.ajax({
                url: '{{ route('getPlsByCoy') }}',
                type: 'GET',
                data: { coy_id: coy_id },
                success: function(data) {
                    $('#pl_id').empty(); // Clear existing Pl options
                    $('#pl_id').append('<option value="">Choose a Pl</option>'); // Add default option
                    $.each(data, function(key, value) {
                        $('#pl_id').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                }
            });
        } else {
            $('#pl_id').empty();
            $('#pl_id').append('<option value="">Choose a Pl</option>');
        }
    });
    
    // Load initial state to match the current section's hierarchy
    $(document).ready(function() {
        // These are pre-selected in the HTML based on the section's current values
        // No need to trigger AJAX calls on page load since we're pre-populating the dropdowns
    });
</script>
@endpush