@extends('layouts.app')

@section('content')
<div class="container mx-auto p-4">
    <h2 class="text-3xl font-bold text-gray-900 mb-6">Marks Report</h2>

    <!-- Button to download as PDF -->
    <div class="mb-4">
        <a href="{{ route('marks.report', request()->all() + ['download_pdf' => 1]) }}" class="bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700">
            Download PDF
        </a>
    </div>

    <!-- Report Table -->
    <table class="min-w-full divide-y divide-gray-200">
        <thead>
            <tr class="bg-gray-50">
                <th></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Army Number</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Rank</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Cadet Name</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Marks & Weight</th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            @foreach($marks as $studentData)
                @php
                    $firstMark = $studentData->first();
                @endphp
                <tr>
                    <td class="px-6 py-4">{{ $firstMark->admission->army_number }}</td>
                    <td class="px-6 py-4">{{ $firstMark->admission->rank }}</td>
                    <td class="px-6 py-4">{{ $firstMark->admission->name }}</td>
                    <td class="px-6 py-4">
                        <ul class="space-y-2">
                            @foreach($studentData as $mark)
                                @php
                                    $weightedMark = ($mark->marks / 100) * $mark->weight;
                                @endphp
                                <li class="flex justify-between">
                                    <span>{{ $mark->subject->code ?? '' }} {{ $mark->exercises ?? '' }} ({{ $mark->marks }}%)</span>
                                    <span>{{ number_format($weightedMark, 2) }}</span>
                                </li>
                            @endforeach
                        </ul>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
