@extends('layouts.app')

@section('content')
<div class="container">
    <div class="header">
        <img src="{{ asset('images/logo.png') }}" alt="Logo" class="logo">
        <h1>Enhanced Performance Report</h1>
    </div>

    <div class="student-details mb-4">
        <h2>Student Information</h2>
        <table>
            <tr>
                <th>Army Number</th>
                <td>{{ $reportData['student']->army_number }}</td>
                <th>Name</th>
                <td>{{ $reportData['student']->name }}</td>
            </tr>
            <tr>
                <th>Rank</th>
                <td>{{ $reportData['student']->rank ?? 'N/A' }}</td>
                <th>Course</th>
                <td>{{ $reportData['student']->course_id ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Unit</th>
                <td colspan="3">
                    BN: {{ $reportData['student']->bn ?? 'N/A' }}, 
                    COY: {{ $reportData['student']->coy ?? 'N/A' }}, 
                    PL: {{ $reportData['student']->pl ?? 'N/A' }}, 
                    SEC: {{ $reportData['student']->sec ?? 'N/A' }}
                </td>
            </tr>
        </table>
    </div>

    <h2>Phase One Summary of Performance</h2>
    <table>
        <thead>
            <tr>
                <th>S/NO</th>
                <th>Description</th>
                <th>Raw Score</th>
                <th>Maximum Score</th>
                <th>Pass Mark</th>
                <th>Obtained Marks</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <!-- MSK Theory -->
            <tr>
                <td rowspan="2">1</td>
                <td>MSK Theory</td>
                <td>{{ number_format($reportData['msk']['theory']['raw_score'], 1) }}%</td>
                <td>40%</td>
                <td>20%</td>
                <td>{{ number_format($reportData['msk']['theory']['normalized_score'], 1) }}%</td>
                <td>
                    <span class="{{ $reportData['msk']['theory']['passed'] ? 'text-success' : 'text-danger' }}">
                        {{ $reportData['msk']['theory']['passed'] ? 'PASSED' : 'FAILED' }}
                    </span>
                </td>
            </tr>
            
            <!-- MSK Practical -->
            <tr>
                <td>MSK Practical</td>
                <td>{{ number_format($reportData['msk']['practical']['raw_score'], 1) }}%</td>
                <td>30%</td>
                <td>15%</td>
                <td>{{ number_format($reportData['msk']['practical']['normalized_score'], 1) }}%</td>
                <td>
                    <span class="{{ $reportData['msk']['practical']['passed'] ? 'text-success' : 'text-danger' }}">
                        {{ $reportData['msk']['practical']['passed'] ? 'PASSED' : 'FAILED' }}
                    </span>
                </td>
            </tr>
            
            <!-- Character Assessment -->
            <tr>
                <td rowspan="2">2</td>
                <td>Character Assessment 22CR</td>
                <td>-</td>
                <td>20%</td>
                <td>10%</td>
                <td>{{ number_format($reportData['character']['22cr']['score'], 1) }}%</td>
                <td>
                    <span class="{{ $reportData['character']['22cr']['passed'] ? 'text-success' : 'text-danger' }}">
                        {{ $reportData['character']['22cr']['passed'] ? 'PASSED' : 'FAILED' }}
                    </span>
                </td>
            </tr>
            
            <tr>
                <td>Character Assessment PR</td>
                <td>-</td>
                <td>10%</td>
                <td>5%</td>
                <td>{{ number_format($reportData['character']['pr']['score'], 1) }}%</td>
                <td>
                    <span class="{{ $reportData['character']['pr']['passed'] ? 'text-success' : 'text-danger' }}">
                        {{ $reportData['character']['pr']['passed'] ? 'PASSED' : 'FAILED' }}
                    </span>
                </td>
            </tr>
            
            <!-- Totals -->
            <tr class="table-secondary">
                <td colspan="2"><strong>MSK TOTAL</strong></td>
                <td>-</td>
                <td>70%</td>
                <td>35%</td>
                <td>{{ number_format($reportData['msk']['total']['score'], 1) }}%</td>
                <td>
                    <span class="{{ $reportData['msk']['total']['passed'] ? 'text-success' : 'text-danger' }}">
                        {{ $reportData['msk']['total']['passed'] ? 'PASSED' : 'FAILED' }}
                    </span>
                </td>
            </tr>
            
            <tr class="table-secondary">
                <td colspan="2"><strong>CHARACTER TOTAL</strong></td>
                <td>-</td>
                <td>30%</td>
                <td>15%</td>
                <td>{{ number_format($reportData['character']['total']['score'], 1) }}%</td>
                <td>
                    <span class="{{ $reportData['character']['total']['passed'] ? 'text-success' : 'text-danger' }}">
                        {{ $reportData['character']['total']['passed'] ? 'PASSED' : 'FAILED' }}
                    </span>
                </td>
            </tr>
            
            <tr class="table-primary">
                <td colspan="2"><strong>GRAND TOTAL</strong></td>
                <td>-</td>
                <td>100%</td>
                <td>50%</td>
                <td>{{ number_format($reportData['total']['score'], 1) }}%</td>
                <td>
                    <span class="{{ $reportData['total']['passed'] ? 'text-success' : 'text-danger' }}">
                        {{ $reportData['total']['passed'] ? 'PASSED' : 'FAILED' }}
                    </span>
                </td>
            </tr>
            
            <!-- Grade -->
            <tr>
                <td colspan="2"><strong>GRADE</strong></td>
                <td colspan="4">{{ $reportData['grade']['grade'] }} ({{ $reportData['grade']['description'] }})</td>
                <td></td>
            </tr>
            
            <!-- General Remarks -->
            <tr>
                <td colspan="7">
                    <strong>GENERAL REMARKS:</strong> 
                    {{ $reportData['total']['passed'] ? 'PASSED' : 'FAILED' }}
                    <div class="remarks">
                        @if($reportData['total']['passed'])
                            The student has successfully completed Phase One with satisfactory performance.
                        @else
                            @if(!$reportData['msk']['total']['passed'])
                                <p>The student has failed to meet the minimum requirements for MSK. Additional training is recommended.</p>
                            @endif
                            @if(!$reportData['character']['total']['passed'])
                                <p>The student has failed to meet the character assessment requirements. Further evaluation is recommended.</p>
                            @endif
                        @endif
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
    
    <!-- MSK Performance Details -->
    <h2>MSK Assessment Breakdown</h2>
    <div class="row">
        <div class="col-md-6">
            <div class="card mb-3">
                <div class="card-header">
                    <h4>Theory Performance ({{ number_format($reportData['msk']['theory']['raw_score'], 1) }}%)</h4>
                </div>
                <div class="card-body">
                    <p>Raw score: {{ number_format($reportData['msk']['theory']['raw_score'], 1) }}%</p>
                    <p>Weighted score (40%): {{ number_format($reportData['msk']['theory']['normalized_score'], 1) }}%</p>
                    <p>Required to pass: 20%</p>
                    <p>Status: <strong>{{ $reportData['msk']['theory']['passed'] ? 'PASSED' : 'FAILED' }}</strong></p>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card mb-3">
                <div class="card-header">
                    <h4>Practical Performance ({{ number_format($reportData['msk']['practical']['raw_score'], 1) }}%)</h4>
                </div>
                <div class="card-body">
                    <p>Raw score: {{ number_format($reportData['msk']['practical']['raw_score'], 1) }}%</p>
                    <p>Weighted score (30%): {{ number_format($reportData['msk']['practical']['normalized_score'], 1) }}%</p>
                    <p>Required to pass: 15%</p>
                    <p>Status: <strong>{{ $reportData['msk']['practical']['passed'] ? 'PASSED' : 'FAILED' }}</strong></p>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Grade Information -->
    <div class="card mt-4">
        <div class="card-header">
            <h3>Grade Information</h3>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h4>Final Grade: {{ $reportData['grade']['grade'] }}</h4>
                    <p>Description: {{ $reportData['grade']['description'] }}</p>
                    <p>Total Score: {{ number_format($reportData['total']['score'], 1) }}%</p>
                    <p>Overall Status: <strong>{{ $reportData['total']['passed'] ? 'PASSED' : 'FAILED' }}</strong></p>
                </div>
                <div class="col-md-6">
                    <h4>Grading Scale</h4>
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Grade</th>
                                <th>Range</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>A</td>
                                <td>80% - 100%</td>
                                <td>Excellent</td>
                            </tr>
                            <tr>
                                <td>B</td>
                                <td>70% - 79%</td>
                                <td>Very Good</td>
                            </tr>
                            <tr>
                                <td>C</td>
                                <td>60% - 69%</td>
                                <td>Good</td>
                            </tr>
                            <tr>
                                <td>D</td>
                                <td>50% - 59%</td>
                                <td>Pass</td>
                            </tr>
                            <tr>
                                <td>F</td>
                                <td>0% - 49%</td>
                                <td>Fail</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="no-print mt-4">
        <button onclick="window.print()" class="btn btn-primary">Print Report</button>
        {{-- <a href="{{ route('admission.index') }}" class="btn btn-secondary">Back to Search</a> --}}
    </div>
</div>

@endsection

@section('styles')
<style>
    body {
        font-family: sans-serif;
    }
    .container {
        width: 90%;
        margin: 20px auto;
    }
    .header {
        text-align: center;
        margin-bottom: 20px;
    }
    .logo {
        max-width: 200px;
        display: block;
        margin: 0 auto;
    }
    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }
    th, td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: left;
    }
    th {
        background-color: #f2f2f2;
    }
    .remarks {
        font-style: italic;
        margin-top: 10px;
    }
    .text-success {
        color: green;
    }
    .text-danger {
        color: red;
    }
    @media print {
        .no-print {
            display: none;
        }
        .card, .card-header, .card-body {
            border: none !important;
            padding: 0 !important;
        }
        h2, h3, h4 {
            page-break-after: avoid;
        }
        tr {
            page-break-inside: avoid;
        }
    }
</style>
@endsection