<!DOCTYPE html>
<html>
<head>
    <title>Combined Reports</title>
    <style>
        body { font-family: sans-serif; }
        .page-break { page-break-after: always; }
    </style>
</head>
<body>
    {{-- <h1>Combined Reports</h1> --}}
    
    @if(count($errors) > 0)
        <div class="errors">
            <h3>Errors:</h3>
            <ul>
                @foreach($errors as $armyNumber => $error)
                    <li>{{ $armyNumber }}: {{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @foreach($results as $armyNumber => $report)
        @if(isset($report['student']))
            {{-- <h2>Report for: {{ $report['student']->army_number ?? 'N/A' }}</h2> --}}
            
            @if($reportType == 'generate')
                @include('reports.performance', $report)
            @elseif($reportType == 'generate2')
                @include('reports.performance2', $report)
            @elseif($reportType == 'generate3')
                @include('reports.transcript', $report)
            @else
                <p>Unknown report type for student {{ $report['student']->army_number ?? 'N/A' }}</p>
            @endif
        @else
            <p>No data found for army number: {{ $armyNumber }}</p>
        @endif

        @if(!$loop->last)
            <div class="page-break"></div>
        @endif
    @endforeach
</body>
</html>