@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8 max-w-4xl">
    <div class="mb-6">
        <a href="{{ route('remark-templates.index') }}"
           class="text-blue-600 hover:text-blue-800 text-sm">
            ← Back to Templates
        </a>
    </div>

    <div class="bg-white rounded-lg shadow-lg p-8">
        <h1 class="text-3xl font-bold mb-6">Create Remark Template</h1>

        @if($errors->any())
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                <ul class="list-disc list-inside">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('remark-templates.store') }}">
            @csrf

            {{-- Phase --}}
            <div class="mb-6">
                <label for="phase_id" class="block text-sm font-medium text-gray-700 mb-2">
                    Phase <span class="text-red-500">*</span>
                </label>
                <select name="phase_id" id="phase_id"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                        required>
                    <option value="">Select Phase</option>
                    @foreach($phases as $phase)
                        <option value="{{ $phase->id }}" {{ old('phase_id') == $phase->id ? 'selected' : '' }}>
                            {{ $phase->name }}{{ $phase->is_active ? ' (Active)' : '' }}
                        </option>
                    @endforeach
                </select>
                @error('phase_id')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Grade --}}
            <div class="mb-6">
                <label for="grade" class="block text-sm font-medium text-gray-700 mb-2">
                    Grade <span class="text-red-500">*</span>
                </label>
                <select name="grade" id="grade"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                        required>
                    <option value="">Select Grade</option>
                    @foreach($grades as $grade)
                        <option value="{{ $grade }}" {{ old('grade') == $grade ? 'selected' : '' }}>
                            Grade {{ $grade }}
                        </option>
                    @endforeach
                </select>
                @error('grade')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Type --}}
            <div class="mb-6">
                <label for="type" class="block text-sm font-medium text-gray-700 mb-2">
                    Remark Type <span class="text-red-500">*</span>
                </label>
                <select name="type" id="type"
                        class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                        required>
                    <option value="">Select Type</option>
                    @foreach($types as $type)
                        <option value="{{ $type }}" {{ old('type') == $type ? 'selected' : '' }}>
                            {{ $type }}
                        </option>
                    @endforeach
                </select>
                @error('type')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            {{-- Remark Text --}}
            <div class="mb-6">
                <label for="remark_text" class="block text-sm font-medium text-gray-700 mb-2">
                    Remark Text <span class="text-red-500">*</span>
                </label>
                <textarea name="remark_text" id="remark_text" rows="8"
                          class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                          required>{{ old('remark_text') }}</textarea>
                @error('remark_text')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror

                <div class="mt-3 text-sm text-gray-600 bg-gray-50 rounded-lg p-3">
                    <p class="font-semibold mb-2">Available Placeholders:</p>
                    <div class="grid grid-cols-2 gap-2">
                        @foreach(['{{name}}' => "Student's full name", '{{gender_he}}' => 'He / She', '{{gender_He}}' => 'He / She (capital)', '{{gender_his}}' => 'His / Her (possessive)', '{{gender_His}}' => 'His / Her (capital)', '{{gender_him}}' => 'Him / Her (object)', '{{gender_Him}}' => 'Him / Her (capital)'] as $ph => $desc)
                        <div class="flex items-center gap-2">
                            <code class="bg-white border rounded px-2 py-0.5 text-xs cursor-pointer hover:bg-blue-50"
                                  onclick="insertPlaceholder('{{ $ph }}')">{{ $ph }}</code>
                            <span class="text-xs text-gray-500">{{ $desc }}</span>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>

            {{-- Preview --}}
            <div class="mb-6 p-4 bg-gray-50 rounded-lg border">
                <div class="flex gap-4 mb-3">
                    <h3 class="font-semibold text-sm">Live Preview:</h3>
                    <label class="flex items-center gap-1 text-xs text-gray-600">
                        <input type="radio" name="preview_gender" value="male" checked onchange="updatePreview()"> Male
                    </label>
                    <label class="flex items-center gap-1 text-xs text-gray-600">
                        <input type="radio" name="preview_gender" value="female" onchange="updatePreview()"> Female
                    </label>
                </div>
                <div id="preview" class="text-sm text-gray-700 italic min-h-[3rem]">
                    Start typing to see preview...
                </div>
            </div>

            {{-- Buttons --}}
            <div class="flex justify-end space-x-4">
                <a href="{{ route('remark-templates.index') }}"
                   class="px-6 py-2 border border-gray-300 rounded-lg hover:bg-gray-50 transition">
                    Cancel
                </a>
                <button type="submit"
                        class="px-6 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg transition">
                    Create Template
                </button>
            </div>
        </form>
    </div>
</div>

<script>
const textarea = document.getElementById('remark_text');

textarea.addEventListener('input', updatePreview);
updatePreview();

function updatePreview() {
    const isMale = document.querySelector('input[name="preview_gender"]:checked').value === 'male';
    let text = textarea.value;

    text = text.replace(/\{\{name\}\}/g,        '<strong>' + (isMale ? 'JOHN DOE' : 'JANE DOE') + '</strong>');
    text = text.replace(/\{\{gender_He\}\}/g,   '<em>' + (isMale ? 'He'  : 'She') + '</em>');
    text = text.replace(/\{\{gender_he\}\}/g,   '<em>' + (isMale ? 'he'  : 'she') + '</em>');
    text = text.replace(/\{\{gender_His\}\}/g,  '<em>' + (isMale ? 'His' : 'Her') + '</em>');
    text = text.replace(/\{\{gender_his\}\}/g,  '<em>' + (isMale ? 'his' : 'her') + '</em>');
    text = text.replace(/\{\{gender_Him\}\}/g,  '<em>' + (isMale ? 'Him' : 'Her') + '</em>');
    text = text.replace(/\{\{gender_him\}\}/g,  '<em>' + (isMale ? 'him' : 'her') + '</em>');

    document.getElementById('preview').innerHTML = text || 'Start typing to see preview...';
}

function insertPlaceholder(ph) {
    const start = textarea.selectionStart;
    const end   = textarea.selectionEnd;
    textarea.value = textarea.value.substring(0, start) + ph + textarea.value.substring(end);
    textarea.selectionStart = textarea.selectionEnd = start + ph.length;
    textarea.focus();
    updatePreview();
}
</script>
@endsection