@extends('layouts.app')

@section('content')

@if(session('registration_number'))
    <script>
        alert('Registration created successfully. Your Registration Number is: ' + '{{ session('registration_number') }}');
    </script>
@endif

<div class="py-6">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-white shadow-md rounded-lg p-6">
            <h2 class="text-2xl font-bold text-gray-900 mb-6">Registration Details</h2>
            
            <!-- Navigation Buttons -->
            <div class="flex justify-between space-x-3 mt-6">
                <a href="{{ route('registrations.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600">
                    Back to Registration List
                </a>
                <div class="flex space-x-2">
                    @if($previousRegistration = App\Models\Registration::where('id', '<', $registration->id)->orderBy('id', 'desc')->first())
                        <a href="{{ route('registrations.show', $previousRegistration) }}" 
                           class="bg-blue-500 text-white px-4 py-2 rounded-md hover:bg-blue-600">
                            ← Previous
                        </a>
                    @endif
                    @if($nextRegistration= App\Models\Registration::where('id', '>', $registration->id)->orderBy('id', 'asc')->first())
                        <a href="{{ route('admissions.show', $nextRegistration) }}" 
                           class="bg-blue-500 text-white px-4 py-2 rounded-md hover:bg-blue-600">
                            Next →
                        </a>
                    @endif
                </div>
            </div>

            <!-- Profile Section -->
            <div class="mt-6 border-b pb-6">
                <div class="flex items-center space-x-4">
                    <img src="{{ $registration->photo ? asset('storage/' . $registration->photo) : 'https://img.freepik.com/premium-vector/user-profile-icon-flat-style-member-avatar-vector-illustration-isolated-background-human-permission-sign-business-concept_157943-15752.jpg' }}"
                         alt="Profile Image"
                         class="w-28 h-28 rounded-full object-cover">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">{{ $registration->name ?? 'N/A' }}</h3>
                        <p class="text-gray-700">Reg/No: {{ $registration->registration_number }}</p>
                    </div>
                </div>
            </div>

            <!-- Personal Details -->
            <h3 class="text-lg font-semibold text-gray-900 mt-6">Personal Information</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-3">
                <div><label class="block text-sm font-medium text-gray-700">Army Number</label><p class="text-gray-900">{{ $registration->army_number ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">DOB</label><p class="text-gray-900">{{ $registration->dob ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">Sex</label><p class="text-gray-900">{{ $registration->sex ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">Unit</label><p class="text-gray-900">{{ $registration->unit ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">NIN</label><p class="text-gray-900">{{ $registration->nin ?? 'N/A' }}</p></div>
            </div>

            <!-- Contact Details -->
            <h3 class="text-lg font-semibold text-gray-900 mt-6">Contact Information</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-3">
                <div><label class="block text-sm font-medium text-gray-700">Email</label><p class="text-gray-900">{{ $registration->email ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">Phone Number</label><p class="text-gray-900">{{ $registration->phone ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">Next Kin Phone</label><p class="text-gray-900">{{ $registration->kin_number ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">Relationship With Kin</label><p class="text-gray-900">{{ $registration->relationship_with_kin ?? 'N/A' }}</p></div>
            </div>

            <!-- Family Details -->
            <h3 class="text-lg font-semibold text-gray-900 mt-6">Family Details</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mt-3">
                <div><label class="block text-sm font-medium text-gray-700">Mother Name</label><p class="text-gray-900">{{ ucfirst($registration->mother_name) ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">Mother Phone</label><p class="text-gray-900">{{ strtoupper($registration->mother_phone) ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">Father Name</label><p class="text-gray-900">{{ ucfirst($registration->father_name) ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">Father Phone</label><p class="text-gray-900">{{ strtoupper($registration->father_phone) ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">Spouse Name</label><p class="text-gray-900">{{ $registration->spouse_name ?? 'N/A' }}</p></div>
                <div><label class="block text-sm font-medium text-gray-700">Spouse Phone</label><p class="text-gray-900">{{ $registration->spouse_phone ?? 'N/A' }}</p></div>
            </div>

            <!-- Education -->
            <h3 class="text-lg font-semibold text-gray-900 mt-6">Education</h3>
            <div class="mt-3">
                <label class="block text-sm font-medium text-gray-700">Education Level</label>
                <p class="text-gray-900">{{ ucfirst($registration->education_level) ?? 'N/A' }}</p>
            </div>
        </div>
    </div>
</div>

@endsection
