@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-7xl mx-auto">
        <h1 class="text-2xl font-bold mb-6">New Registration</h1>

        <form action="{{ route('registrations.store') }}" method="POST" enctype="multipart/form-data" class="space-y-8">
            @csrf

               <!-- Alert Messages -->
        @if (session('success'))
        <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
    @endif

    @if (session('error'))
        <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
            <span class="block sm:inline">{{ session('error') }}</span>
        </div>
    @endif

    @if ($errors->any())
        <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative">
            <ul class="list-disc list-inside">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

            <!-- Military Information -->
            <div class="bg-gray-50 p-6 rounded-lg">
                <h2 class="text-xl font-bold mb-4">Military Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block font-semibold">Search Army Number <span class="text-red-500">*</span></label>
                        <div class="flex space-x-2">
                            <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm focus:ring focus:ring-blue-300 p-2" id="army_number" name="army_number" required>
                            <button type="button" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600" onclick="searchArmyNumber()">Search</button>
                        </div>
                    </div>
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2 bg-gray-100" id="name" name="name" readonly>
                    </div>
                    <div>
                        <label class="block font-semibold">Unit</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="unit" value="{{ old('unit') }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Photo <span class="text-red-500"></span></label>
                        <input type="file" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="photo" >
                    </div>
                </div>
             
        
            </div>

            <!-- Personal Information -->
            <div class="bg-gray-50 p-6 rounded-lg">
                <h2 class="text-xl font-bold mb-4">Personal Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block font-semibold">NIN <span class="text-red-500">*</span></label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="nin" value="{{ old('nin') }}" required>
                    </div>
                    <div>
                        <label class="block font-semibold">Date of Birth <span class="text-red-500">*</span></label>
                        <input type="date" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="dob" value="{{ old('dob') }}" required>
                    </div>
                    <div>
                        <label class="block font-semibold">Sex <span class="text-red-500">*</span></label>
                        <select name="sex" class="w-full border-gray-300 rounded-lg p-2" required>
                            <option value="">Select Sex</option>
                            <option value="Male" {{ old('sex') == 'Male' ? 'selected' : '' }}>Male</option>
                            <option value="Female" {{ old('sex') == 'Female' ? 'selected' : '' }}>Female</option>
                        </select>
                    </div>
                    <div>
                        <label class="block font-semibold">Phone <span class="text-red-500">*</span></label>
                        <input type="tel" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="phone" value="{{ old('phone') }}" required>
                    </div>
                    <div>
                        <label class="block font-semibold">Email <span class="text-red-500"></span></label>
                        <input type="email" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="email" value="{{ old('email') }}">
                    </div> 
                    <div>
                        <label class="block font-semibold">Shoe Size <span class="text-red-500"></span></label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="shoe_size" value="{{ old('shoe_size') }}">
                    </div> 
                </div>
            </div>

            <!-- Family Information -->
            <div class="bg-gray-50 p-6 rounded-lg">
                <h2 class="text-xl font-bold mb-4">Family Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block font-semibold">Father Name</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="father_name" value="{{ old('father_name') }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Father Phone</label>
                        <input type="tel" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="father_phone" value="{{ old('father_phone') }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Mother Name</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="mother_name" value="{{ old('mother_name') }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Mother Phone</label>
                        <input type="tel" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="mother_phone" value="{{ old('mother_phone') }}">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                    <div>
                        <label class="block font-semibold">Spouse Name</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="spouse_name" value="{{ old('spouse_name') }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Spouse Phone</label>
                        <input type="tel" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="spouse_phone" value="{{ old('spouse_phone') }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Next of Kin</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="next_kin" value="{{ old('next_kin') }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Relationship With Kin</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="relationship_with_kin" value="{{ old('relationship_with_kin') }}">
                    </div>
                    <div>
                        <label class="block font-semibold">Next of Kin Phone</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="kin_number" value="{{ old('kin_number') }}">
                    </div>
                </div>
            </div>

            <!-- Additional Information -->
            <div class="bg-gray-50 p-6 rounded-lg">
                <h2 class="text-xl font-bold mb-4">Additional Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">

                    <div>
                        <label class="block font-semibold">Education Level</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="education_level" value="{{ old('education_level') }}">
                    </div>

                  
          
                    {{-- <div>
                        <label class="block font-semibold">Education Level</label>
                        <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" name="education_level" value="{{ old('education_level') }}">
                    </div> --}}
               
                  
                </div>
               
            </div>

            <button type="submit" class="w-full bg-green-500 text-white py-3 px-4 rounded-lg hover:bg-green-600 font-semibold">
                Create Registration
            </button>
        </form>
    </div>
</div>

<script>
    function searchArmyNumber() {
        let armyNumber = document.getElementById('army_number').value;
        if (!armyNumber) {
            alert("Please enter an Army Number.");
            return;
        }

        fetch("{{ route('admissions.searchArmyNumber') }}", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": "{{ csrf_token() }}"
            },
            body: JSON.stringify({ army_number: armyNumber })
        })
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                alert("Army Number not found.");
            } else {
                document.getElementById('name').value = data.name;
                document.getElementById('MIL_ID_No').value = data.MIL_ID_No;
            }
        })
        .catch(error => console.error('Error:', error));
    }


</script>
@endsection

    
        {{-- <!-- Section 3: Personal Information -->
        <div class="bg-gray-50 p-6 rounded-lg">
            <h2 class="text-xl font-bold mb-4">Personal Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700">Email</label>
                    <input type="email" class="w-full border-gray-300 rounded-lg shadow-sm p-2" id="email" name="email">
                </div>
                <div>
                    <label for="phone" class="block text-sm font-medium text-gray-700">Phone Number</label>
                    <input type="tel" class="w-full border-gray-300 rounded-lg shadow-sm p-2" id="phone" name="phone">
                </div>
                <div>
                    <label for="home_district" class="block text-sm font-medium text-gray-700">Home District</label>
                    <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" id="home_district" name="home_district">
                </div>
                <div>
                    <label for="village" class="block text-sm font-medium text-gray-700">Village</label>
                    <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" id="village" name="village">
                </div>
            </div>
        </div> --}}