@extends('layouts.app2')
@section('title', 'Register')
@section('content')

<section class="bg-gray-100 min-h-screen flex items-center justify-center">
    <div class="w-full max-w-md px-4">
        <div class="bg-white shadow-md rounded-lg py-6 px-6">

            {{-- Header --}}
            <div class="text-center mb-6">
                <p class="text-sm uppercase font-bold text-gray-500">
                    Create new account
                </p>
            </div>

            {{-- Display All Errors --}}
            @if ($errors->any())
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <ul class="list-disc list-inside text-sm">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            {{-- Register Form --}}
            <form class="space-y-4" action="{{ url('register') }}" method="post">
                @csrf

                {{-- Name --}}
                <div>
                    <label for="nameInp" class="block text-sm font-medium text-gray-700">
                        Name
                    </label>
                    <input type="text"
                        id="nameInp"
                        name="name"
                        value="{{ old('name') }}"
                        class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 @error('name') border-red-500 @enderror">

                    @error('name')
                        <p class="text-xs text-red-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Email Username + Domain --}}
                <div>
                    <label for="emailInp" class="block text-sm font-medium text-gray-700">
                        Email Address
                    </label>

                    <div class="mt-1 flex rounded-md shadow-sm">
                        <input type="text"
                            id="emailInp"
                            name="username"
                            placeholder="Enter username"
                            required
                            class="flex-1 rounded-l-md border-gray-300 focus:border-blue-500 focus:ring focus:ring-blue-200 @error('email') border-red-500 @enderror">

                        <span class="inline-flex items-center px-3 rounded-r-md border border-l-0 border-gray-300 bg-gray-100 text-gray-600 text-sm">
                            @strartbmts.tradoc
                        </span>
                    </div>

                    @error('email')
                        <p class="text-xs text-red-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Password --}}
                <div>
                    <label for="passInp" class="block text-sm font-medium text-gray-700">
                        Password
                    </label>
                    <input type="password"
                        id="passInp"
                        name="password"
                        class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 @error('password') border-red-500 @enderror">

                    @error('password')
                        <p class="text-xs text-red-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Register Button --}}
                <div>
                    <button type="submit"
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 rounded-md transition">
                        Register
                    </button>
                </div>
            </form>

            {{-- Login Link --}}
            <div class="mt-4 text-center text-sm">
                <p class="text-gray-600">
                    Already have an account?
                    <a href="{{ url('/') }}" class="font-medium text-blue-600 hover:underline">
                        Login
                    </a>
                </p>
            </div>

        </div>
    </div>
</section>

<script>
    document.querySelector('form').addEventListener('submit', function () {
        let emailInput = document.getElementById('emailInp');
        let hiddenEmailField = document.createElement('input');

        hiddenEmailField.type = 'hidden';
        hiddenEmailField.name = 'email';
        hiddenEmailField.value = emailInput.value + '@strartbmts.tradoc';

        this.appendChild(hiddenEmailField);
    });
</script>

@endsection
