@extends('layouts.app')

@section('content')
<div class="container mx-auto p-4">
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-gray-800">Peer Rating List</h2>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Army No</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Name</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Rank</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Rating</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Sum</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Raters</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Mean</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">PR Score (%)</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($prStats as $pr)
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $pr['army_number'] }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $pr['name'] }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">{{ $pr['rank'] }}</td>
                        <td class="px-6 py-4 text-center">
                            @php
                                $rating = '';
                                for ($i = 1; $i <= 7; $i++) {
                                    if ($pr['ratings']['s'.$i] == 1) {
                                        $rating = $i;
                                        break;
                                    }
                                }
                            @endphp
                            {{ $rating }}
                        </td>
                        <td class="px-6 py-4 text-center font-semibold">{{ $pr['sum_of_ratings'] }}</td>
                        <td class="px-6 py-4 text-center">{{ $pr['number_of_raters'] }}</td>
                        <td class="px-6 py-4 text-center">{{ $pr['mean_rating'] }}</td>
                        <td class="px-6 py-4 text-center">{{ $pr['score'] ? $pr['score'] . '%' : '-' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection