@extends('layouts.app')

@section('content')
<div class="container mx-auto p-4">
      <!-- Header Information with improved styling -->
    <div class="bg-gradient-to-r from-blue-600 to-blue-800 rounded-xl shadow-lg p-6 mb-6 text-white">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-3xl font-bold mb-2">Peer Rating Entry</h2>
                <p class="text-blue-100">Evaluate your peers based on their performance</p>
            </div>
            <div class="bg-white/20 rounded-lg p-3 backdrop-blur-sm">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                </svg>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4 bg-white/10 rounded-lg p-4">
            <div class="flex items-center space-x-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-200" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                </svg>
                <div>
                    <p class="text-sm text-blue-200">Selected Cadet</p>
                    <p class="font-semibold">{{ $selectedStudent->army_number }} - {{ $selectedStudent->name }}</p>
                </div>
            </div>
            <div class="flex items-center space-x-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-200" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                </svg>
                <div>
                    <p class="text-sm text-blue-200">Grouping Details</p>
                    <p class="font-semibold">{{ $selectedStudent->bn }} / {{ $selectedStudent->coy }} / {{ $selectedStudent->pl }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Phase Selection Section with improved styling -->
    <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
        <div class="flex items-center space-x-2 mb-4">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
            </svg>
            <h3 class="text-lg font-semibold text-gray-800">Select Training Phase</h3>
        </div>
        
        <form action="{{ route('pr.store') }}" method="POST" id="filterForm" class="space-y-6">
            @csrf
            <input type="hidden" name="admission_id" value="{{ $admissionId }}">
            
            <div class="relative">
                <select name="phase_id" id="phase_id" class="block w-full md:w-96 px-4 py-3 text-gray-700 bg-white border-2 border-gray-200 rounded-lg focus:border-blue-500 focus:ring-2 focus:ring-blue-200 transition-colors appearance-none cursor-pointer" required>
                    <option value="" disabled selected>Choose a phase...</option>
                    @foreach($phases as $phase)
                        <option value="{{ $phase->id }}" {{ old('phase_id') == $phase->id ? 'selected' : '' }}>
                            {{ $phase->name }}
                        </option>
                    @endforeach
                </select>
                <div class="absolute inset-y-0 right-0 flex items-center px-2 pointer-events-none">
                    <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </div>
                @error('phase_id')
                    <p class="mt-2 text-sm text-red-600 flex items-center">
                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        {{ $message }}
                    </p>
                @enderror
            </div>

            <!-- Rating Scale Legend -->
            <div class="bg-gradient-to-r from-gray-50 to-gray-100 rounded-lg p-4 border border-gray-200">
                <h4 class="text-sm font-semibold text-gray-700 mb-3 flex items-center">
                    <svg class="w-4 h-4 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Rating Scale (1-7)
                </h4>
                <div class="grid grid-cols-1 md:grid-cols-7 gap-2 text-xs">
                    <div class="bg-red-100 text-red-800 p-2 rounded text-center">1 - Poor</div>
                    <div class="bg-orange-100 text-orange-800 p-2 rounded text-center">2 - Below Avg</div>
                    <div class="bg-yellow-100 text-yellow-800 p-2 rounded text-center">3 - Average</div>
                    <div class="bg-blue-100 text-blue-800 p-2 rounded text-center">4 - Good</div>
                    <div class="bg-green-100 text-green-800 p-2 rounded text-center">5 - Very Good</div>
                    <div class="bg-purple-100 text-purple-800 p-2 rounded text-center">6 - Excellent</div>
                    <div class="bg-indigo-100 text-indigo-800 p-2 rounded text-center">7 - Outstanding</div>
                </div>
                <p class="text-xs text-gray-600 mt-2 flex items-center">
                    <svg class="w-4 h-4 mr-1 text-yellow-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                    </svg>
                    Note: Ratings 1 and 7 are disabled as per guidelines
                </p>
            </div>
    </div>

    <!-- Main Form -->
   <form action="{{ route('pr.store') }}" method="POST" class="bg-white rounded-lg shadow-md p-6" id="filterForm">
    @csrf
    <input type="hidden" name="admission_id" value="{{ $admissionId }}">
    
 

    <table class="min-w-full divide-y divide-gray-200 table-auto">
        <thead class="bg-gray-50">
            <tr>
                <th scope="col" class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Army NO</th>
                <th scope="col" class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">NAME</th>
                <th scope="col" class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">RANK</th>
                <!-- These headers will be for the Score columns -->
                @for($i = 1; $i <= 7; $i++)
                    <th class="px-4 py-2 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">{{ $i }}</th>
                @endfor
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            @foreach($students as $student)
                @if($student->army_number != $selectedStudent->army_number && !$student->is_decommissioned)
                    <tr class="hover:bg-gray-50">
                        <!-- Army NO -->
                        <td class="px-4 py-2 whitespace-nowrap text-sm text-gray-500">
                            {{ $student->army_number }}
                        </td>
                        <!-- Name -->
                        <td class="px-4 py-2 whitespace-nowrap text-sm text-gray-500">
                            {{ $student->name }}
                        </td>
                        <!-- Rank -->
                        <td class="px-4 py-2 whitespace-nowrap text-sm text-gray-500">
                            {{ $student->rank }}
                        </td>
                        <!-- Score columns (1-7) -->
                        @for($i = 1; $i <= 7; $i++)
                            <td class="px-4 py-2 text-center text-sm">
                                <input type="radio"
                                       id="score_{{ $student->id }}_{{ $i }}"
                                       name="items[{{ $student->id }}]"
                                       value="{{ $i }}"
                                       class="form-radio h-5 w-5 text-blue-600 item-input"
                                       data-student-id="{{ $student->id }}"
                                       data-rating="{{ $i }}"
                                       {{ in_array($i, [1, 7]) ? 'disabled' : '' }}
                                       @if(isset($existingRatings[$student->id]) && $existingRatings[$student->id] == $i) checked @endif
                                >
                            </td>
                        @endfor
                    </tr>
                @endif
            @endforeach
        </tbody>
    </table>
    
    <div class="mt-6 flex justify-end">
        <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
            Save PR
        </button>
    </div>
</form>
</div>

<style>
    .form-radio {
        border-radius: 50%;
        width: 1.25rem;
        height: 1.25rem;
        border: 2px solid #d1d5db;
    }
    
    .form-radio:checked {
        background-color: #2563eb;
        border-color: #2563eb;
    }
    
    .form-radio:disabled {
        background-color: #f3f4f6;
        cursor: not-allowed;
    }
</style>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    const RatingInputHandler = {
        init() {
            this.ratingCounts = {2: 0, 6: 0};
            this.selectedValues = new Map();
            this.setupEventListeners();
            this.loadExistingSelections();
        },

        loadExistingSelections() {
            document.querySelectorAll('.form-radio:checked').forEach(radio => {
                const value = parseInt(radio.value);
                const studentId = radio.dataset.studentId;
                
                this.selectedValues.set(studentId, value);
                
                if (value === 2 || value === 6) {
                    this.ratingCounts[value]++;
                }
            });
            
            this.updateDisabledState();
        },

        setupEventListeners() {
            document.querySelectorAll('.form-radio').forEach(radio => {
                radio.addEventListener('change', (e) => this.handleRadioChange(e));
                radio.addEventListener('blur', (e) => this.handleBlur(e));
            });
        },

        handleRadioChange(event) {
            const radio = event.target;
            const studentId = radio.dataset.studentId;
            const value = parseInt(radio.value);
            const previousValue = this.selectedValues.get(studentId);

            if (previousValue === 2 || previousValue === 6) {
                this.ratingCounts[previousValue]--;
                this.enableSpecialValues(previousValue);
            }

            if (value === 2 || value === 6) {
                this.ratingCounts[value]++;
            }

            this.selectedValues.set(studentId, value);
            this.updateDisabledState();
        },

        handleBlur(event) {
            const radio = event.target;
            const value = parseInt(radio.value);

            if (!radio.checked && (value === 2 || value === 6)) {
                this.enableSpecialValues(value);
            }
        },

        enableSpecialValues(value) {
            document.querySelectorAll('.form-radio').forEach(radio => {
                if (parseInt(radio.value) === value) {
                    radio.disabled = false;
                }
            });
        },

        updateDisabledState() {
            document.querySelectorAll('.form-radio').forEach(radio => {
                const value = parseInt(radio.value);
                if ((value === 2 || value === 6) && this.ratingCounts[value] >= 1) {
                    radio.disabled = !radio.checked;
                }
            });
        }
    };

    document.addEventListener('DOMContentLoaded', () => {
        RatingInputHandler.init();
        
        // Add form validation
        const form = document.getElementById('filterForm');
        
        form.addEventListener('submit', function(e) {
            const selectedRatings = document.querySelectorAll('.form-radio:checked');
            
            if (selectedRatings.length === 0) {
                e.preventDefault();
                Swal.fire({
                    icon: 'warning',
                    title: 'No Ratings Selected',
                    text: 'Please rate at least one cadet before submitting.',
                    confirmButtonColor: '#3085d6',
                });
                return false;
            }
            
            // Show loading state
            const submitButton = form.querySelector('button[type="submit"]');
            submitButton.disabled = true;
            submitButton.textContent = 'Saving...';
            
            return true; // Allow form submission
        });
    });
</script>
@endpush

@endsection