@extends('layouts.app')
@section('title', 'Create New Pl')
@section('content')
<div class="container mx-auto py-8">
    @if ($errors->any())
        <div class="bg-red-100 text-red-700 p-4 rounded-lg mb-4">
            @foreach ($errors->all() as $error)
                <p>{{ $error }}</p>
            @endforeach
        </div>
    @endif

    <h2 class="text-3xl font-semibold text-gray-800 mb-6">Create New Pl</h2>

    <form action="{{ route('pl.store') }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
        @csrf

        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            <div>
                <label for="bn_id" class="block text-gray-700 font-semibold mb-2">Select Bn</label>
                <select name="bn_id" id="bn_id" class="w-full p-3 border border-gray-300 rounded" required>
                    <option value="">Choose a Bn</option>
                    @foreach($bns as $bn)
                        <option value="{{ $bn->id }}">{{ $bn->name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label for="coy_id" class="block text-gray-700 font-semibold mb-2">Select Coy</label>
                <select name="coy_id" id="coy_id" class="w-full p-3 border border-gray-300 rounded" required>
                    <option value="">Choose a Coy</option>
                    <!-- Coy options will be populated via AJAX -->
                </select>
            </div>

            <div>
                <label for="name" class="block text-gray-700 font-semibold mb-2">Pl</label>
                <select name="name" id="name" class="w-full p-3 border border-gray-300 rounded" required>
                    <option value="">Select Pl</option>
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                </select>
            </div>

            <div>
                <label for="comd_rank" class="block text-gray-700 font-medium mb-2">Rank</label>
                <select name="comd_rank" id="comd_rank" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
                    @php
                        $ranks = [
                            'Gen', 'Lt Gen', 'Maj Gen', 'Brig Gen', 'Col', 'Lt Col', 'Maj', 'Capt',
                            'Lt', '2Lt', 'JO1', 'JO2', 'O/Cdt', 'WO1', 'WO2', 'S/Sgt', 'Sgt', 'Cpl',
                            'L/Cpl', 'Pte'
                        ];
                    @endphp
                    @foreach($ranks as $rank)
                        <option value="{{ $rank }}">{{ $rank }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label for="comd_name" class="block text-gray-700 font-medium mb-2">Comd Name</label>
                <input type="text" name="comd_name" id="comd_name" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
            </div>

            <div>
                <label for="pl_sgt" class="block text-gray-700 font-medium mb-2">Pl Sgt</label>
                <input type="text" name="pl_sgt" id="pl_sgt" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
            </div>

            <div>
                <label for="pl_sgt_rank" class="block text-gray-700 font-medium mb-2">Pl Sgt Rank</label>
                <select name="pl_sgt_rank" id="pl_sgt_rank" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
                    @php
                        $ranks = [
                            'Gen', 'Lt Gen', 'Maj Gen', 'Brig Gen', 'Col', 'Lt Col', 'Maj', 'Capt',
                            'Lt', '2Lt', 'JO1', 'JO2', 'O/Cdt', 'WO1', 'WO2', 'S/Sgt', 'Sgt', 'Cpl',
                            'L/Cpl', 'Pte'
                        ];
                    @endphp
                    @foreach($ranks as $rank)
                        <option value="{{ $rank }}">{{ $rank }}</option>
                    @endforeach
                </select>
            </div>


            
        </div>

        <button type="submit" class="bg-blue-500 text-white px-6 py-3 rounded hover:bg-blue-600">Create Pl</button>
    </form>
</div>

@endsection

@push('scripts')
<script>
    // AJAX request to fetch coys based on selected bn
    $('#bn_id').on('change', function() {
        var bn_id = $(this).val();
        
        if (bn_id) {
            $.ajax({
                url: '{{ route('getCoysByBn') }}', // Define this route in your web.php
                type: 'GET',
                data: { bn_id: bn_id },
                success: function(data) {
                    $('#coy_id').empty(); // Clear existing options
                    $('#coy_id').append('<option value="">Choose a Coy</option>'); // Add default option
                    $.each(data, function(key, value) {
                        $('#coy_id').append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                }
            });
        } else {
            $('#coy_id').empty();
            $('#coy_id').append('<option value="">Choose a Coy</option>');
        }
    });
</script>
@endpush
