@extends('layouts.app')

@section('content')
<div class="container mx-auto p-6">
    <div class="bg-white rounded-lg shadow-lg overflow-hidden">
        <!-- Student Information Header -->
        <div class="bg-gray-50 px-6 py-4 border-b">
            <div class="flex justify-between items-start">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">Student Assessment Details</h1>
                    <div class="mt-2 space-y-1">
                        <p class="text-gray-600"><span class="font-semibold">Army Number:</span> {{ $admission->army_number }}</p>
                        <p class="text-gray-600"><span class="font-semibold">Rank:</span> {{ $admission->rank }}</p>
                        <p class="text-gray-600"><span class="font-semibold">Name:</span> {{ $admission->name }}</p>
                    </div>
                </div>
                <a href="javascript:void(0);" onclick="window.history.back();" class="bg-gray-100 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-200">
                    Back to List
                </a>

            </div>
        </div>

        <!-- Assessment Groups -->
        <div class="p-6 space-y-6">
            @foreach($assessments as $groupName => $groupTypes)
                <div class="mb-8">
                    <h2 class="text-xl font-semibold text-gray-900 mb-4">{{ $groupName }}</h2>

                    @foreach($groupTypes as $typeName => $typeAssessments)
                        <div class="mb-6">
                            <h3 class="text-lg font-medium text-gray-800 mb-3">{{ $typeName }}</h3>
                            <div class="bg-white rounded-lg border overflow-hidden">
                                <table class="min-w-full divide-y divide-gray-200">
                                    <thead class="bg-gray-50">
                                        <tr>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Subject/Exercise</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Period</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Marks</th>
{{--                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Weight</th>--}}
{{--                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Weighted Score</th>--}}
                                        </tr>
                                    </thead>
                                  <!-- Replace the table body section with this updated code -->
<tbody class="bg-white divide-y divide-gray-200">
    @foreach($typeAssessments as $assessment)
        <tr class="hover:bg-gray-50">
            <td class="px-6 py-4 text-sm text-gray-900">
                {{ $assessment->subject->code ?? $assessment->exercises ?? '-' }}
            </td>
            <td class="px-6 py-4 text-sm text-gray-900">
                @if($assessment->type === 'Monthly' && !empty($assessment->month))
                    {{ $assessment->month }}
                @elseif(!empty($assessment->week))
                Week {{ preg_replace('/[^0-9]/', '', $assessment->week) }}

                @else
                    -
                @endif
            </td>
            <td class="px-6 py-4 text-sm">
                <span class="px-2 py-1 rounded-full {{ $assessment->marks <= 49 ?  'bg-red-100 text-red-800' : 'bg-green-100 text-green-800' }}">
                    {{ number_format($assessment->marks, 1) }}%
                </span>
            </td>
{{--            <td class="px-6 py-4 text-sm text-gray-900">--}}
{{--                @php--}}
{{--                    $weight = null;--}}
{{--                    if ($assessment->exercises) {--}}
{{--                        $weight = $exerciseWeights[$assessment->exercises] ?? null;--}}
{{--                    } else {--}}
{{--                        $weight = $examWeights[$assessment->type] ?? null;--}}
{{--                    }--}}
{{--                @endphp--}}
{{--                {{ $weight ? number_format($weight, 2) . '%' : '-' }}--}}
{{--            </td>--}}
{{--            <td class="px-6 py-4 text-sm text-gray-900">--}}
{{--                @if($weight)--}}
{{--                    <span class="{{ ($assessment->marks * $weight / 100) >= 50 ? 'text-gray-600' : 'text-gray-600' }}">--}}
{{--                        {{ number_format(($assessment->marks * $weight / 100), 2) }}--}}
{{--                    </span>--}}
{{--                @else--}}
{{--                    ---}}
{{--                @endif--}}
{{--            </td>--}}
        </tr>
    @endforeach
</tbody>
                                </table>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endforeach
        </div>
    </div>
</div>
@endsection
