<!DOCTYPE html>
<html>
<head>
    <title>Marks Report</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .header { text-align: center; margin-bottom: 30px; }
        .logo { height: 60px; margin-bottom: 10px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f5f5f5; }
        .filters { margin-bottom: 20px; }
        .summary { margin-top: 20px; }
        .student-row { background-color: #f9f9f9; }
        .marks-row { background-color: #ffffff; }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ asset('amry_project/bmts-logo1.png') }}" alt="School Logo" class="logo">
        <h2>Marks Report</h2>
        <p>Generated on: {{ now()->format('d/m/Y H:i:s') }}</p>
    </div>

    @if(!empty($filters))
    <div class="filters">
        <h4>Filters Applied:</h4>
        @if(!empty($filters['assessment_type']))
            <p>Assessment Type: {{ $filters['assessment_type'] }}</p>
        @endif
        @if(!empty($filters['assessment_group']))
            <p>Assessment Group: {{ $filters['assessment_group'] }}</p>
        @endif
        @if(!empty($filters['type']))
            <p>Type: {{ $filters['type'] }}</p>
        @endif
    </div>
    @endif

    <table>
        <thead>
            <tr>
                <th>Army Number</th>
                <th>Rank</th>
                <th>Name</th>
                @if($marks->first()->subject_id)
                    <th>Subject</th>
                @elseif($marks->first()->type)
                    <th>Type</th>
                @endif
                @if($marks->first()->exercises)
                    <th>Exercise</th>
                @endif
                <th>Marks</th>
                {{-- <th>Weight</th> --}}
            </tr>
        </thead>
        <tbody>
            @php
                $currentStudent = null;
            @endphp
            @forelse($marks->groupBy('admission_id') as $admissionId => $studentMarks)
                @foreach($studentMarks as $mark)
                    <tr class="{{ $mark->admission->army_number !== ($currentStudent ?? '') ? 'student-row' : 'marks-row' }}">
                        <td>{{ $mark->admission->army_number !== ($currentStudent ?? '') ? $mark->admission->army_number : '' }}</td>
                        <td>{{ $mark->admission->army_number !== ($currentStudent ?? '') ? $mark->admission->rank : '' }}</td>
                        <td>{{ $mark->admission->army_number !== ($currentStudent ?? '') ? $mark->admission->name : '' }}</td>
                        @if($marks->first()->subject_id)
                        <td>{{ $mark->subject->code ?? 'N/A' }}</td>
                    @elseif($marks->first()->type)
                        <td>
                            @php
                                $words = explode(' ', $mark->type);
                                $initials = '';
                                foreach ($words as $word) {
                                    $initials .= strtoupper($word[0]);
                                }
                            @endphp
                            {{ $initials }}{{!empty($mark->week) ? substr($mark->week, -1) : '' }}
                        </td>
                    @endif
                    @if($marks->first()->exercises)
                        <td>
                            @php
                                $words = explode(' ', $mark->exercises);
                                $initials = '';
                                foreach ($words as $word) {
                                    $initials .= strtoupper($word[0]);
                                }
                            @endphp
                            {{ $initials }}
                        </td>
                    @endif
                        <td>{{ $mark->marks ?? '0' }}%</td>
                        {{-- <td>{{ number_format(($mark->marks / 100) * ($mark->weight ?? 0), 2) }}</td> --}}
                  
                    </tr>
                    @php
                        $currentStudent = $mark->admission->army_number;
                    @endphp
                @endforeach
            @empty
                <tr>
                    <td colspan="{{ 8 + ($marks->first()->exercises ? 1 : 0) }}" class="text-center">No marks found</td>
                </tr>
            @endforelse
        </tbody>
    </table>
    {{-- <div class="summary">
        <p><strong>Total Records:</strong> {{ $marks->count() }}</p>
        <p><strong>Total Students:</strong> {{ $marks->groupBy('admission_id')->count() }}</p>
    </div> --}}
</body>
</html>