@extends('layouts.app')

@section('content')
<div class="container mx-auto p-6">
    <h2 class="text-2xl font-semibold mb-4">Log Details</h2>
    <div class="bg-white shadow-md rounded-lg p-6">
        <div class="mb-4">
            <strong class="text-gray-700">ID:</strong> {{ $log->id }}
        </div>
        <div class="mb-4">
            <strong class="text-gray-700">Log Name:</strong> {{ $log->log_name }}
        </div>
        <div class="mb-4">
            <strong class="text-gray-700">Description:</strong> {{ $log->description }}
        </div>
        <div class="mb-4">
            <strong class="text-gray-700">Created At:</strong> {{ $log->created_at }}
        </div>
        
        <h3 class="text-xl font-semibold mt-6 mb-2">Properties</h3>
        @php
            $properties = json_decode($log->properties, true); 
        @endphp
        @if($properties)
            <div class="space-y-2">
                <div><strong>IP:</strong> {{ $properties['ip'] ?? 'N/A' }}</div>
                <div><strong>URL:</strong> <a href="{{ $properties['url'] ?? '#' }}" class="text-blue-500" target="_blank">{{ $properties['url'] ?? 'N/A' }}</a></div>
                <div><strong>Method:</strong> {{ $properties['method'] ?? 'N/A' }}</div>
                <div><strong>Input:</strong></div>
                <div class="pl-4 space-y-1">
                    @foreach($properties['input'] ?? [] as $key => $value)
                        <div><strong>{{ ucfirst(str_replace('_', ' ', $key)) }}:</strong> {{ $value }}</div>
                    @endforeach
                </div>
            </div>
        @else
            <span class="text-gray-500">N/A</span>
        @endif

        <div class="mt-4">
            <a href="{{ route('admin.logs') }}" class="text-blue-500">Back to Log List</a>
        </div>
    </div>
</div>
@endsection
