@extends('layouts.app2')
@section('title', 'Login')
@section('content')

<section class="bg-gray-100 min-h-screen flex items-center justify-center">
    <div class="w-full max-w-md px-4">
        <div class="bg-white shadow-md rounded-lg py-6 px-6">
            
            {{-- Logo & Header --}}
            <div class="text-center mb-6">
                <img src="{{ asset('bmts-logo1.png') }}" alt="Logo" class="mx-auto mb-3 w-28">
                <p class="text-sm uppercase font-bold text-gray-500">
                    Welcome To STRART v2.0
                </p>
            </div>

            {{-- Session Error --}}
            @if(session('error'))
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4 flex justify-between items-center">
                    <span>{{ session('error') }}</span>
                    <button onclick="this.parentElement.remove()" class="font-bold">×</button>
                </div>
            @endif

            {{-- Session Status --}}
            @if(session('status'))
                <div class="bg-blue-100 border border-blue-400 text-blue-700 px-4 py-3 rounded mb-4 flex justify-between items-center">
                    <span>{{ session('status') }}</span>
                    <button onclick="this.parentElement.remove()" class="font-bold">×</button>
                </div>
            @endif

            {{-- Validation Errors --}}
            @if($errors->any())
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <ul class="list-disc list-inside text-sm">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            {{-- Login Form --}}
            <form class="space-y-4" action="{{ url('login') }}" method="post">
                @csrf

                {{-- Email --}}
                <div>
                    <label for="emailInp" class="block text-sm font-medium text-gray-700">
                        Email Address
                    </label>
                    <input type="email"
                        id="emailInp"
                        name="email"
                        value="{{ old('email') }}"
                        required
                        autofocus
                        class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200 @error('email') border-red-500 @enderror">

                    @error('email')
                        <p class="text-xs text-red-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Password --}}
                <div>
                    <label for="passInp" class="block text-sm font-medium text-gray-700">
                        Password
                    </label>
                    <div class="relative mt-1">
                        <input type="password"
                            id="passInp"
                            name="password"
                            required
                            class="w-full rounded-md border-gray-300 shadow-sm pr-10 focus:border-blue-500 focus:ring focus:ring-blue-200 @error('password') border-red-500 @enderror">

                        <button type="button"
                            id="togglePassword"
                            class="absolute inset-y-0 right-0 px-3 flex items-center text-gray-500 hover:text-gray-700">
                            👁
                        </button>
                    </div>

                    @error('password')
                        <p class="text-xs text-red-500 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Login Button --}}
                <div>
                    <button type="submit"
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 rounded-md transition">
                        Login
                    </button>
                </div>
            </form>

            {{-- Register Link --}}
            <div class="mt-4 text-center text-sm">
                <p class="text-gray-600">
                    I don't have an account?
                    <a href="{{ url('register') }}" class="font-medium text-blue-600 hover:underline">
                        Register
                    </a>
                </p>
            </div>
        </div>

        {{-- Version --}}
        <div class="mt-4 text-left">
            <small class="text-gray-500">System Version: 1.0.1</small>
        </div>
    </div>
</section>

@push('scripts')
<script>
    document.getElementById('togglePassword').addEventListener('click', function () {
        const passwordInput = document.getElementById('passInp');

        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            this.textContent = '🙈';
        } else {
            passwordInput.type = 'password';
            this.textContent = '👁';
        }
    });
</script>
@endpush

@endsection
