@extends('layouts.app')

@section('content')
<div class="container">
    <!-- Success/Error Messages -->
    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Success!</strong>
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
            <strong class="font-bold">Error!</strong>
            <span class="block sm:inline">{{ session('error') }}</span>
        </div>
    @endif

    <div class="card">
        <div class="card-header mb-5">
            <div class="flex justify-between items-center mb-8">
                <div>
                    <h1 class="text-4xl font-bold text-gray-800">Saved GPV Reports</h1>
                    <p class="text-gray-600">View and manage your saved performance reports</p>
                </div>
                <div>
                    <a href="{{ route('gpv') }}" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded inline-flex items-center">
                        <i class="fas fa-arrow-left mr-2"></i> Back to GPV
                    </a>
                </div>
            </div>
        </div>

        <div class="card-body">
            <div class="overflow-x-auto">
                <table class="w-full table-auto">
                    <thead>
                        <tr class="bg-gray-200 text-gray-700">
                            <th class="px-4 py-2">#</th>
                            <th class="px-4 py-2">Report Name</th>
                            <th class="px-4 py-2">Phase</th>
                            <th class="px-4 py-2">School</th>
                            <th class="px-4 py-2">Course</th>
                            {{-- <th class="px-4 py-2">Intake</th> --}}
                            <th class="px-4 py-2">Total Cadets</th>
                            <th class="px-4 py-2">Created By</th>
                            <th class="px-4 py-2">Date Created</th>
                            <th class="px-4 py-2">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reports as $index => $report)
                            <tr class="border-b hover:bg-gray-50 {{ $index % 2 == 1 ? 'bg-gray-100' : '' }}">
                                <td class="px-4 py-2">{{ $reports->firstItem() + $index }}</td>
                                <td class="px-4 py-2 font-semibold">{{ $report->report_name }}</td>
                                <td class="px-4 py-2">{{ $report->phase }}</td>
                                <td class="px-4 py-2">{{ $report->school ? $report->school->name : 'All Schools' }}</td>
                                <td class="px-4 py-2">{{ $report->course ? $report->course->name : 'All Courses' }}</td>
                                {{-- <td class="px-4 py-2">{{ $report->intake ? $report->intake->year : 'All Intakes' }}</td> --}}
                                <td class="px-4 py-2 text-center">
                                    <span class="bg-blue-100 text-blue-800 px-2 py-1 rounded">{{ $report->total_students }}</span>
                                </td>
                                <td class="px-4 py-2">{{ $report->creator ? $report->creator->name : 'N/A' }}</td>
                                <td class="px-4 py-2">{{ $report->created_at->format('M d, Y H:i') }}</td>
                                <td class="px-4 py-2">
                                    <div class="flex space-x-2">
                                        <a href="{{ route('gpv.view-report', $report->id) }}" class="bg-blue-500 hover:bg-blue-700 text-white px-3 py-1 rounded text-sm" title="View Report">
                                            <i class="fas fa-eye">View</i>
                                        </a>
                                        {{-- <form action="{{ route('gpv.delete-report', $report->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this report?');" style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="bg-red-500 hover:bg-red-700 text-white px-3 py-1 rounded text-sm" title="Delete Report">
                                                <i class="fas fa-trash">Delete</i>
                                            </button>
                                        </form> --}}
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="10" class="px-4 py-8 text-center text-gray-500">
                                    <i class="fas fa-folder-open text-4xl mb-2"></i>
                                    <p>No saved reports found</p>
                                    <a href="{{ route('gpv') }}" class="text-blue-500 hover:underline">Create your first report</a>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="mt-6">
        {{ $reports->links('pagination::tailwind') }}
    </div>
</div>
@endsection