@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header mb-5">
          
            <div class="flex justify-between items-center mb-8">
                <div>
                    <h1 class="text-4xl font-bold text-gray-800">General Performance Review (GPV)</h1>
                    <p class="text-gray-600">Summary of overall trainee performance across all phases and more.</p>
                </div>
            </div>
            
        </div>
    <!-- Filter Form -->
 <!-- Filter Form -->
 <div class="bg-white shadow-md rounded-lg mb-4">
    <div class="bg-gray-100 p-4 rounded-t-lg">
        <h5 class="text-lg font-semibold">Filter Options</h5>
    </div>
    <div class="p-4">
        <form action="{{ route('gpv') }}" method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <input type="hidden" name="phase" value="{{ $phase ?? 1 }}">
                  <div class="mb-4">
                <label for="army_number" class="block text-sm font-medium text-gray-700">Search:</label>
                <input type="text" name="army_number" id="army_number" value="{{ request('army_number') }}" placeholder="Search by army number"
                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>
            
            <div class="mb-4">
                <label for="school_id" class="block text-sm font-medium text-gray-700">School:</label>
                <select name="school_id" id="school_id" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Schools</option>
                    @foreach($schools as $school)
                        <option value="{{ $school->id }}" {{ request('school_id') == $school->id ? 'selected' : '' }}>
                            {{ $school->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            
            <div class="mb-4">
                <label for="course_id" class="block text-sm font-medium text-gray-700">Course:</label>
                <select name="course_id" id="course_id" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Courses</option>
                    @foreach($courses as $course)
                        <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>
                            {{ $course->name }}
                        </option>
                    @endforeach
                </select>
            </div>
                   {{-- <div class="mb-4">
                <label for="intake_id" class="block text-sm font-medium text-gray-700">Intake:</label>
                <select name="intake_id" id="intake_id" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Intakes</option>
                    @foreach($intakes as $intake)
                        <option value="{{ $intake->id }}" {{ request('intake_id') == $intake->id ? 'selected' : '' }}>
                            {{ $intake->year }}
                        </option>
                    @endforeach
                </select>

           </div> --}}
            <div class="mb-4">
                <label for="phase" class="block text-sm font-medium text-gray-700">Phase:</label>
                <select name="phase" id="phase" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Phase</option>
                    <option value="Phase 1" {{ request('phase') == 'Phase 1' ? 'selected' : '' }}>Phase 1</option>
                    <option value="Phase 2" {{ request('phase') == 'Phase 2' ? 'selected' : '' }}>Phase 2</option>
                    <option value="Phase 3" {{ request('phase') == 'Phase 3' ? 'selected' : '' }}>Phase 3</option>
                </select>
            </div>

            <div class="mb-4">
                <label for="bn" class="block text-sm font-medium text-gray-700">Bn:</label>
                <select name="bn" id="bn" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Bns</option>
                    @foreach($bns as $bn)
                        <option value="{{ $bn->name }}" {{ request('bn') == $bn->name ? 'selected' : '' }}>
                            {{ $bn->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            
            <div class="mb-4">
                <label for="coy" class="block text-sm font-medium text-gray-700">Coy:</label>
                <select name="coy" id="coy" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Coys</option>
                    @foreach($coys as $coy)
                        <option value="{{ $coy->name }}" {{ request('coy') == $coy->name ? 'selected' : '' }}>
                            {{ $coy->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            
            <div class="mb-4">
                <label for="pl" class="block text-sm font-medium text-gray-700">Pl:</label>
                <select name="pl" id="pl" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Pls</option>
                    <option value="1" {{ request('pl') == '1' ? 'selected' : '' }}>1</option>
                    <option value="2" {{ request('pl') == '2' ? 'selected' : '' }}>2</option>
                    <option value="3" {{ request('pl') == '3' ? 'selected' : '' }}>3</option>
                </select>
            </div>
            <div class="mb-4">
                <label for="grade" class="block text-sm font-medium text-gray-700">Grade:</label>
                <select name="grade" id="grade" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">All Grades</option>
                    <option value="A" {{ request('grade') == 'A' ? 'selected' : '' }}>A</option>
                    <option value="B" {{ request('grade') == 'B' ? 'selected' : '' }}>B</option>
                    <option value="C" {{ request('grade') == 'C' ? 'selected' : '' }}>C</option>
                    <option value="D" {{ request('grade') == 'D' ? 'selected' : '' }}>D</option>
                    <option value="D" {{ request('grade') == 'E' ? 'selected' : '' }}>E</option>
                    <option value="F" {{ request('grade') == 'F' ? 'selected' : '' }}>F</option>
                </select>
            </div>

            {{-- <div class="mb-4">
                <label for="phase" class="block text-sm font-medium text-gray-700">Phase:</label>
                <select name="phase" id="phase" class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @for($i = 1; $i <= 3; $i++)
                        <option value="{{ $i }}" {{ request('phase', 1) == $i ? 'selected' : '' }}>Phase {{ $i }}</option>
                    @endfor
                </select>
            </div> --}}
            
            
            <div class="mb-4">
                <label for="per_page" class="block text-sm font-medium text-gray-700">Records per page:</label>
                <select name="per_page" id="per_page" onchange="this.form.submit()"
                    class="mt-1 block w-full px-3 py-2 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                    @foreach([25, 50, 100, 200, 300, 700] as $size)
                        <option value="{{ $size }}" {{ request('per_page', 25) == $size ? 'selected' : '' }}>
                            {{ $size }}
                        </option>
                    @endforeach
                </select>
            </div>

  
            
            <div class="flex items-end gap-2 mb-4">
                <button type="submit" class="flex items-center px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <i class="fas fa-filter mr-2"></i> Apply Filters
                </button>
                <a href="{{ route('gpv') }}" class="flex items-center px-4 py-2 bg-gray-300 text-gray-800 rounded-md hover:bg-gray-400 focus:outline-none focus:ring-2 focus:ring-gray-500">
                    <i class="fas fa-redo mr-2"></i> Reset
                </a>
            </div>
        </form>
    </div>
</div>

        <!-- Conditionally render the export buttons based on showButtons flag -->
        {{-- @if(isset($showButtons) && $showButtons) --}}
        <div class="flex justify-end mb-4 space-x-4">
            <!-- Print Button -->
         <!-- Save Report Button -->
        <!-- Include SweetAlert2 (CDN) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

@if(Auth::user()->type === 'admin')

<form id="saveReportForm" action="{{ route('gpv') }}" method="GET" style="display: inline;">
    @foreach(request()->all() as $key => $value)
        @if($key !== 'save_report' && $key !== 'download_excel' && $key !== 'download_pdf' && $key !== 'preview_pdf')
            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
        @endif
    @endforeach
{{-- 
    <button type="submit" name="save_report" value="true"
        class="bg-gray-400 hover:bg-gray-500 text-white font-bold py-2 px-4 rounded inline-flex items-center">
        <i class="fas fa-save mr-2"></i> Save Report
    </button> --}}
</form>

@endif


<script>
document.getElementById('saveReportForm').addEventListener('submit', function (e) {
    e.preventDefault(); // stop form temporarily for confirmation

    Swal.fire({
        title: "Are you sure?",
        text: "Please confirm that all Phase Theory, Practical, 22CR, and PR info are entered before saving.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, Save",
        cancelButtonText: "Cancel",
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            e.target.submit(); // proceed with save if confirmed
        }
    });
});
</script>

   
            <a href="{{ route('gpv', array_merge(request()->all(), ['preview_pdf' => true])) }}" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded" target="_blank">
                👁️ Preview PDF
            </a>
            <!-- Export to PDF Button -->
    

            <!-- Export to Excel Button -->
            <a href="{{ route('gpv.saved-reports') }}?" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                📊 View  GPV History
            </a>
        </div>
        {{-- @endif --}}

        <div class="card-body">
            <div class="overflow-x-auto">
                <table class="w-full table-auto">
                    <thead>
                        <tr class="bg-gray-200 text-gray-700">
                            <th class="px-4 py-2 cursor-pointer">
                              #
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(0)">
                                Admission No. <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(1)">
                                Army Number <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(2)">
                                Rank <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(3)">
                                O/CDT Name <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(4)">
                                Theory <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(5)">
                                Practical <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(6)">
                                22CR <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(7)">
                                PR <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(8)">
                                Total <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(9)">
                                Grade <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(10)">
                                Comment <span class="sort-icon ml-1">↕️</span>
                            </th>
                            <th class="px-4 py-2 cursor-pointer" onclick="sortTable(11)">
                                Remarks <span class="sort-icon ml-1">↕️</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody id="tableBody">
                        @forelse($studentsData as $index => $student)
                            {{-- <tr class="border-b hover:bg-gray-50 {{ $index % 2 == 1 ? 'bg-gray-100' : '' }}"> --}}
                                <td class="px-4 py-2">{{ $index + 1 }}</td>
                                <td class="px-4 py-2">{{ $student['admission_number'] }}</td>
                                <td class="px-4 py-2">{{ $student['army_number'] }}</td>
                                <td class="px-4 py-2">{{ $student['rank'] }}</td>
                                <td class="px-4 py-2">{{ $student['name'] }}</td>
                                <td class="px-4 py-2">{{ $student['theory'] }}</td>
                                <td class="px-4 py-2">{{ $student['practical'] }}</td>
                                <td class="px-4 py-2">{{ $student['cr_22'] }}</td>
                                <td class="px-4 py-2">{{ $student['pr'] }}</td>
                                <td class="px-4 py-2">{{ $student['total'] }}</td>
                                <td class="px-4 py-2">{{ $student['grade'] }}</td>
                                <td class="px-4 py-2">{{ $student['comment'] }}</td>
                                <td class="px-4 py-2">{{ $student['remarks'] }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="12" class="px-4 py-2 text-center">No students found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
        </div>
    </div>
</div>
<div class="mt-6">
    {{ $students->withQueryString()->links('pagination::tailwind') }}
</div>



<!-- Add custom print CSS -->
<style>
    /* Hide the buttons/icons when printing */
    @media print {
        .flex {
            display: none !important;
        }

        .sort-icon {
            display: none !important;
        }
    }
</style>

<script>
function printPage() {
    window.print();
}

let sortDirection = Array(12).fill('asc');

function sortTable(columnIndex) {
    const table = document.getElementById('tableBody');
    const rows = Array.from(table.rows);
    
    // Toggle sort direction for the clicked column
    sortDirection[columnIndex] = sortDirection[columnIndex] === 'asc' ? 'desc' : 'asc';
    
    // Update all sort icons to default (bidirectional arrow)
    document.querySelectorAll('.sort-icon').forEach(icon => {
        icon.textContent = '↕️';
    });
    
    // Update the clicked column's sort icon
    const sortIcon = document.querySelectorAll('.sort-icon')[columnIndex];
    sortIcon.textContent = sortDirection[columnIndex] === 'asc' ? '↑' : '↓';
    
    // Sort the rows
    rows.sort((a, b) => {
        let aValue = a.cells[columnIndex].textContent.trim();
        let bValue = b.cells[columnIndex].textContent.trim();
        
        // Check if values are numbers
        if (!isNaN(aValue) && !isNaN(bValue)) {
            aValue = parseFloat(aValue);
            bValue = parseFloat(bValue);
        }
        
        if (aValue < bValue) {
            return sortDirection[columnIndex] === 'asc' ? -1 : 1;
        } else if (aValue > bValue) {
            return sortDirection[columnIndex] === 'asc' ? 1 : -1;
        }
        return 0;
    });
    
    // Re-append rows in the new order
    rows.forEach(row => table.appendChild(row));
    
    // Apply zebra striping
    rows.forEach((row, index) => {
        row.classList.remove('bg-gray-100');
        if (index % 2 === 1) {
            row.classList.add('bg-gray-100');
        }
    });
}
</script>

@endsection
