<x-filament::page>
    <h1 class="text-2xl font-bold mb-4"> Assessments</h1>

    <table class="table-auto w-full border-collapse border border-gray-300">
        <thead>
            <tr>
                <th class="border border-gray-300 px-4 py-2">Army Number</th>
                <th class="border border-gray-300 px-4 py-2">Rank</th>
                <th class="border border-gray-300 px-4 py-2">Soldier Name</th>
                <th class="border border-gray-300 px-4 py-2">Pl</th>
                <th class="border border-gray-300 px-4 py-2">Sec</th>
                @for ($i = 1; $i <= 5; $i++)
                    <th class="border border-gray-300 px-4 py-2 bg-{{ ['red-200', 'blue-200', 'yellow-200', 'green-200', 'purple-200'][$i-1] }}">
                        Weekly {{ $i }}
                    </th>
                @endfor
            </tr>
        </thead>
        <tbody>
            @foreach ($assessments->groupBy('admission.army_number') as $soldierAssessments)
                <tr>
                    <td class="border border-gray-300 px-4 py-2">{{ $soldierAssessments->first()->admission->army_number }}</td>
                    <td class="border border-gray-300 px-4 py-2">{{ $soldierAssessments->first()->admission->rank }}</td>
                    <td class="border border-gray-300 px-4 py-2">{{ $soldierAssessments->first()->admission->name }}</td>
                    <td class="border border-gray-300 px-4 py-2">{{ $soldierAssessments->first()->admission->pl }}</td>
                    <td class="border border-gray-300 px-4 py-2">{{ $soldierAssessments->first()->admission->sel }}</td>

                    @for ($i = 1; $i <= 5; $i++)
                        @php
                            $weekAssessments = $soldierAssessments->where('week', 'week' . $i);
                            $weekDetails = $weekAssessments->map(function($assessment) {
                                if (!is_null($assessment->subject_id) && strtolower($assessment->subject_id) !== 'exercises') {
                                    return "{$assessment->marks} ({$assessment->subject_id})"; // Show marks + subject_id
                                }
                                return $assessment->marks; // Only marks if subject_id is null or "exercises"
                            })->implode(', ');
                        @endphp
                        <td class="border border-gray-300 px-4 py-2 bg-{{ ['red-100', 'blue-100', 'yellow-100', 'green-100', 'purple-100'][$i-1] }}">
                            {{ $weekDetails ?: '-' }}
                        </td>
                    @endfor
                </tr>
            @endforeach
        </tbody>
    </table>
</x-filament::page>
