<!DOCTYPE html>
<html>
<head>
    <title>Admissions List</title>
    <style>
        body { font-family: Arial, sans-serif; }
        .filters { margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { margin-bottom: 20px; }
        .date { text-align: right; margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>Admissions List</h2>
        <div class="date">Generated on: {{ date('Y-m-d H:i:s') }}</div>
    </div>

    @if(!empty($filters))
    <div class="filters">
        <h4>Applied Filters:</h4>
        <ul>
            @if(!empty($filters['school_id']))
                <li>School: {{ App\Models\School::find($filters['school_id'])->name }}</li>
            @endif
            @if(!empty($filters['course_id']))
                <li>Course: {{ App\Models\Course::find($filters['course_id'])->name }}</li>
            @endif
            @if(!empty($filters['bn']))
                <li>Bn: {{ $filters['bn'] }}</li>
            @endif
            @if(!empty($filters['coy']))
                <li>Coy: {{ $filters['coy'] }}</li>
            @endif
            @if(!empty($filters['pl']))
                <li>Pl: {{ $filters['pl'] }}</li>
            @endif
            @if(!empty($filters['sec']))
                <li>Sec: {{ $filters['sec'] }}</li>
            @endif
            @if(!empty($filters['search']))
                <li>Search: {{ $filters['search'] }}</li>
            @endif
        </ul>
    </div>
    @endif

    <table>
        <thead>
            <tr>
                <th>Army Number</th>
                <th>Rank</th>
                <th>Name</th>
                <th>Course</th>
                <th>Bn</th>
                <th>Coy</th>
            </tr>
        </thead>
        <tbody>
            @foreach($admissions as $admission)
            <tr>
                <td>{{ $admission->army_number }}</td>
                <td>{{ $admission->rank }}</td>
                <td>{{ $admission->name }}</td>
                <td>{{ $admission->course->name }}</td>
                <td>{{ $admission->bn }}</td>
                <td>{{ $admission->coy }}</td>

            </tr>
            @endforeach
        </tbody>
    </table>
    <div>Total Records: {{ $admissions->count() }}</div>
</body>
</html>
