<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>22 CR Assessment</title>
    <style>
        @page { size: A4; margin: 1cm; }
        body { font-family: Arial, sans-serif; }
        .header { text-align: center; margin-bottom: 20px; }
        .logo { width: 80px; }
        .student-info { margin-bottom: 20px; padding: 10px; border: 1px solid #ddd; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f5f5f5; }
        .summary { margin-top: 20px; border-top: 2px solid #ddd; padding-top: 10px; }
        .total { display: flex; justify-content: space-between; margin: 5px 0; }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ asset('bmts-logo1.png') }}" alt="School Logo" class="logo">
        <h1>22 CR</h1>
        <p>Generated on {{ $date }}</p>
    </div>

    <div class="student-info">
        <h3>Student Information</h3>
        <table>
            <tr>
                <td><strong>Army Number:</strong> {{ $student['army_number'] }}</td>
                <td><strong>Name:</strong> {{ $student['name'] }}</td>
                <td><strong>Course:</strong> {{ $student['course'] }}</td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th>Character Requirement</th>
                <th>Score</th>
            </tr>
        </thead>
        <tbody>
            @foreach($assessments as $index => $assessment)
            <tr>
                <td>{{ $assessment['cr_id'] }}</td>
                <td class="text-center">{{ $assessment['cres'] }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="summary">
        <div class="total">
            <strong>Total CRES:</strong>
            <span>{{ number_format($totalCRES, 2) }}</span>
        </div>
        <div class="total">
            <strong>22CR Score Phase 1:</strong>
            <span>{{ $finalScore }}%</span>
        </div>
    </div>
</body>
</html>