
@extends('layouts.app')
@section('title', 'Create New Bn')
@section('content')
    <div class="container mx-auto py-8">
        <h2 class="text-3xl font-semibold text-gray-800 mb-6">Create New Bn</h2>

        <form action="{{ route('bn.store') }}" method="POST" class="bg-white p-6 rounded-lg shadow-md">
            @csrf
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                <div class="w-full">
                    <label for="name" class="block text-gray-700 font-medium mb-2">Bn Name</label>
                    <input type="text" name="name" id="name"  class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400" required>
                </div>
            
                <div class="w-full">
                    <label for="comd_rank" class="block text-gray-700 font-medium mb-2">Rank</label>
                    <select name="comd_rank" id="comd_rank" class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400">
                        @php
                            $ranks = [
                    'Gen', 'Lt Gen', 'Maj Gen', 'Brig Gen', 'Col', 'Lt Col', 'Maj', 'Capt',
                    'Lt', '2Lt', 'JO1', 'JO2', 'O/Cdt', 'WO1', 'WO2', 'S/Sgt', 'Sgt', 'Cpl',
                    'L/Cpl', 'Pte'
                ];
                        @endphp
                        @foreach($ranks as $rank)
                            <option value="{{ $rank }}" >{{ $rank }}</option>
                        @endforeach
                    </select>
                </div>
            
                <div class="w-full">
                    <label for="comd_name" class="block text-gray-700 font-medium mb-2">Bn Comd Name</label>
                    <input type="text" name="comd_name" id="comd_name"  class="w-full p-4 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-400">
                </div>
            </div>
            <button type="submit" class="w-full bg-blue-500 text-white py-4 rounded-lg text-lg font-semibold hover:bg-blue-600 transition duration-200">Create Bn</button>
        </form>
        
    </div>
@endsection
