@extends('layouts.app')

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-white shadow-md rounded-lg overflow-hidden">
            <!-- Header Section with Navigation -->
            <div class="p-6 border-b border-gray-200">
                <div class="flex justify-between items-center">
                    <h2 class="text-2xl font-bold text-gray-900">Admission Details</h2>
                    <div class="flex space-x-3">
                        <div class="flex space-x-2">
                     
                        
                            <a href="{{ route('admissions.index') }}" class="bg-gray-500 text-white px-4 py-2 rounded-md hover:bg-gray-600">
                                Back to List
                            </a>
                        
                            <a href="{{ route('admissions.edit', $admission->id) }}" class="bg-blue-500 text-white px-4 py-2 rounded-md hover:bg-blue-600">
                                Edit
                            </a>
                        </div>
                        
                    </div>
                </div>

                <!-- Previous/Next Navigation -->
                <div class="flex justify-between mt-4">
                    <div class="flex space-x-2">
                        @if($previousAdmission = App\Models\Admission::where('id', '<', $admission->id)->orderBy('id', 'desc')->first())
                            <a href="{{ route('admissions.show', $previousAdmission) }}" 
                               class="text-blue-600 hover:text-blue-800">
                                ← Previous
                            </a>
                        @endif
                    </div>
                    <div>
                        @if($nextAdmission = App\Models\Admission::where('id', '>', $admission->id)->orderBy('id', 'asc')->first())
                            <a href="{{ route('admissions.show', $nextAdmission) }}" 
                               class="text-blue-600 hover:text-blue-800">
                                Next →
                            </a>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Main Content -->
            <div class="p-6">
                <!-- Profile Section -->
                <div class="flex items-start space-x-6 mb-6">
                    <div class="w-32 flex-shrink-0">
                        @if($admission->image)
                            <img 
                                src="http://localhost/army_project2/army_project2/public/{{ $admission->image }}"
                                alt="{{ $admission->name }}'s profile"
                                class="w-32 h-32 rounded-lg object-cover shadow-sm cursor-pointer"
                                onclick="openImageModal(this.src)"
                                onerror="this.onerror=null; this.src='{{ asset('images/default-profile.png') }}'"
                            >
                        @else
                            <div class="w-32 h-32 bg-gray-200 rounded-lg flex items-center justify-center">
                                <span class="text-gray-400">No Image</span>
                            </div>
                        @endif
                    </div>

                    <div class="flex-1">
                        <h3 class="text-xl font-semibold text-gray-900">{{ $admission->name }}</h3>
                        <p class="text-sm text-gray-500">{{ $admission->rank }}</p>
                        <p class="text-sm text-gray-500">Army Number: {{ $admission->army_number }}</p>
                    </div>
                </div>

                <!-- Status Indicators -->
                @if($admission->is_non_ugandan)
                    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded-md mb-6">
                        <h3 class="text-lg font-medium text-blue-800 mb-2">Non-Ugandan Cadet Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-blue-700">Country of Origin</label>
                                <p class="mt-1 text-blue-900">{{ $admission->country_origin ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-blue-700">Military ID</label>
                                <p class="mt-1 text-blue-900">{{ $admission->military_id ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>
                @endif

                @if($admission->is_decommissioned)
                    <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded-md mb-6">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-lg font-medium text-red-800"> Discontinued</h3>
                                <div class="mt-2 text-sm text-red-700">
                                    <p><strong>Date:</strong> {{ $admission->decommission_date ? date('d M Y', strtotime($admission->decommission_date)) : 'N/A' }}</p>
                                    <p><strong>Reason:</strong> {{ $admission->decommission_reason }}</p>
                                    @if($admission->decommission_notes)
                                        <p><strong>Notes:</strong> {{ $admission->decommission_notes }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Information Sections -->
                <div class="space-y-8">
                    <!-- Basic Information -->
                    <section>
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Basic Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Email</label>
                                <p class="mt-1">{{ $admission->email ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Phone Number</label>
                                <p class="mt-1">{{ $admission->phone_number ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">NIN</label>
                                <p class="mt-1">{{ $admission->nin ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </section>

                    <!-- Academic Information -->
                    <section>
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Academic Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">School</label>
                                <p class="mt-1">{{ $admission->school->name ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Course</label>
                                <p class="mt-1">{{ $admission->course->name ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Education Level</label>
                                <p class="mt-1">{{ $admission->education_level ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Intake</label>
                                <p class="mt-1">{{ $admission->intake->name ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </section>

                    <!-- Military Information -->
                    <section>
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Military Information</h3>
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">BN</label>
                                <p class="mt-1">{{ $admission->bn ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">COY</label>
                                <p class="mt-1">{{ $admission->coy ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">PL</label>
                                <p class="mt-1">{{ $admission->pl ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">SEC</label>
                                <p class="mt-1">{{ $admission->sec ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </section>

                    <!-- Contact Information -->
                    <section>
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Contact Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Home District</label>
                                <p class="mt-1">{{ $admission->home_district ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Village</label>
                                <p class="mt-1">{{ $admission->village ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </section>

                    <!-- Family Information -->
                    <section>
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Family Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Father's Details</label>
                                <p class="mt-1">Name: {{ $admission->father_name ?? 'N/A' }}</p>
                                <p class="mt-1">Phone: {{ $admission->father_phone ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Mother's Details</label>
                                <p class="mt-1">Name: {{ $admission->mother_name ?? 'N/A' }}</p>
                                <p class="mt-1">Phone: {{ $admission->mother_phone ?? 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Spouse's Details</label>
                                <p class="mt-1">Name: {{ $admission->spouse_name ?? 'N/A' }}</p>
                                <p class="mt-1">Phone: {{ $admission->spouse_phone ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </section>

                    <!-- System Information -->
                    <section class="border-t pt-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">System Information</h3>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 text-sm">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Created</label>
                                <p class="mt-1">By: {{ $admission->created_by ?? 'N/A' }}</p>
                                <p class="text-gray-500">{{ $admission->created_at ? $admission->created_at->format('d M Y H:i') : 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Last Updated</label>
                                <p class="mt-1">By: {{ $admission->updated_by ?? 'N/A' }}</p>
                                <p class="text-gray-500">{{ $admission->updated_at ? $admission->updated_at->format('d M Y H:i') : 'N/A' }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Admission Year</label>
                                <p class="mt-1">{{ $admission->year_admission ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Image Modal -->
<div id="imageModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
    <div class="max-w-4xl mx-auto p-4">
        <img id="modalImage" src="" alt="Full size image" class="max-h-[80vh] max-w-full rounded-lg">
        <button 
            onclick="closeImageModal()"
            class="absolute top-4 right-4 text-white bg-gray-800 rounded-full p-2 hover:bg-gray-700"
        >
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
            </svg>
        </button>
    </div>
</div>

@push('scripts')
<script>
function openImageModal(src) {
    const modal = document.getElementById('imageModal');
    const modalImage = document.getElementById('modalImage');
    modalImage.src = src;
    modal.classList.remove('hidden');
    modal.classList.add('flex');
    document.body.classList.add('overflow-hidden');
}

function closeImageModal() {
    const modal = document.getElementById('imageModal');
    modal.classList.add('hidden');
    modal.classList.remove('flex');
    document.body.classList.remove('overflow-hidden');
}

document.getElementById('imageModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeImageModal();
    }
});

document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeImageModal();
    }
});
</script>
@endpush

@endsection