@extends('layouts.app')

@section('content')
<!-- Loading Overlay -->



<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Title and Add New Button -->
    <!-- Add this after the "Add New Admission" button -->


 

    @if ($type == 'epr')
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">End Of Phase Report</h1>
            <p class="text-gray-600">Overview of performance at the end of a training phase</p>
        </div>
    </div>
@elseif ($type == 'isr')
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">Individual Summary Report</h1>
            <p class="text-gray-600">Detailed summary of an individual's performance and progress</p>
        </div>
    </div>
@elseif ($type == 'tr')
    <div class="flex justify-between items-center mb-8">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">Transcript Report</h1>
            <p class="text-gray-600">Comprehensive record of academic achievements and results</p>
        </div>
    </div>
@endif

   
        <!-- Success Message -->
        @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <span class="block sm:inline">{{ session('success') }}</span>
        </div>
        @endif


  
{{-- Cascading Filter System --}}
<form method="GET" action="{{ route('admissions.list', $type) }}" class="mb-4 flex flex-wrap gap-4">
    <!-- School Filter -->
    <select name="school_id" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by School</option>
        @foreach($schools as $school)
            <option value="{{ $school->id }}" {{ request('school_id') == $school->id ? 'selected' : '' }}>
                {{ $school->name }}
            </option>
        @endforeach
    </select>
    
    <!-- Course Filter -->
    <select name="course_id" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Course</option>
        @foreach($courses as $course)
            <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>
                {{ $course->name }}
            </option>
        @endforeach
    </select>
    
    <!-- Battalion Filter -->
    <select name="bn" id="bn-filter" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Bn</option>
        @foreach($bn as $battalion)
            <option value="{{ $battalion }}" {{ request('bn') == $battalion ? 'selected' : '' }}>
                {{ ucfirst($battalion) }}
            </option>
        @endforeach
    </select>
    
    <!-- Company Filter -->
    <select name="coy" id="coy-filter" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Coy</option>
        @foreach($coy as $company)
            <option value="{{ $company }}" 
                {{ request('coy') == $company ? 'selected' : '' }}
                data-bn="{{ $companyBnMap[$company] ?? '' }}">
                {{ strtoupper($company) }}
            </option>
        @endforeach
    </select>
    
    <!-- Platoon Filter -->
    <select name="pl" id="" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Pl</option>
        <option value="1">1</option>
        <option value="2">2</option>
        <option value="3">3</option>
        <option value="4">4</option>
    </select>
    
    <!-- Section Filter -->
    <select name="sec" id="sec-filte" class="border-gray-300 rounded-lg p-2">
        <option value="">Filter by Sec</option>
        <option value="I">I</option>
        <option value="II">II</option>
        <option value="III">III</option>
 
    </select>
    
    <!-- Submit and Clear Buttons -->
    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
        Filter
    </button>
    <a href="{{ route('admissions.list', $type) }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
        Clear
    </a>
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const bnFilter = document.getElementById('bn-filter');
    const coyFilter = document.getElementById('coy-filter');
    const plFilter = document.getElementById('pl-filter');
    const secFilter = document.getElementById('sec-filter');
    
    // Function to filter dropdowns based on selection
    function updateFilters() {
        const selectedBn = bnFilter.value;
        const selectedCoy = coyFilter.value;
        const selectedPl = plFilter.value;
        
        // Filter company options based on battalion
        if (selectedBn) {
            Array.from(coyFilter.options).forEach(option => {
                if (option.value === '' || option.dataset.bn === selectedBn) {
                    option.style.display = '';
                } else {
                    option.style.display = 'none';
                }
            });
        } else {
            // Show all company options if no battalion selected
            Array.from(coyFilter.options).forEach(option => {
                option.style.display = '';
            });
        }
        
        // Filter platoon options based on battalion and company
        Array.from(plFilter.options).forEach(option => {
            if (option.value === '') {
                option.style.display = '';
                return;
            }
            
            let shouldShow = true;
            
            if (selectedBn && option.dataset.bn !== selectedBn) {
                shouldShow = false;
            }
            
            if (selectedCoy && option.dataset.coy !== selectedCoy) {
                shouldShow = false;
            }
            
            option.style.display = shouldShow ? '' : 'none';
        });
        
        // Filter section options based on battalion, company, and platoon
        Array.from(secFilter.options).forEach(option => {
            if (option.value === '') {
                option.style.display = '';
                return;
            }
            
            let shouldShow = true;
            
            if (selectedBn && option.dataset.bn !== selectedBn) {
                shouldShow = false;
            }
            
            if (selectedCoy && option.dataset.coy !== selectedCoy) {
                shouldShow = false;
            }
            
            if (selectedPl && option.dataset.pl !== selectedPl) {
                shouldShow = false;
            }
            
            option.style.display = shouldShow ? '' : 'none';
        });
    }
    
    // Add event listeners for filter changes
    bnFilter.addEventListener('change', function() {
        // Clear lower-level filters when battalion changes
        coyFilter.value = '';
        plFilter.value = '';
        secFilter.value = '';
        updateFilters();
    });
    
    coyFilter.addEventListener('change', function() {
        // Clear lower-level filters when company changes
        plFilter.value = '';
        secFilter.value = '';
        updateFilters();
    });
    
    plFilter.addEventListener('change', function() {
        // Clear section filter when platoon changes
        secFilter.value = '';
        updateFilters();
    });
    
    // Initial update on page load
    updateFilters();
});
</script>
        <!-- Search Bar -->
<!-- Search Bar -->
<form method="GET" action="{{ route('admissions.list', $type) }}" class="mb-4">
    <div class="flex space-x-2">
        <div class="relative w-full">
            <input type="text" name="search" placeholder="Search by Army Number, Name"
                   value="{{ request('search') }}"
                   class="w-full border-gray-300 rounded-lg shadow-sm p-2 pl-10">
            <svg class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-gray-500"
                 xmlns="http://www.w3.org/2000/svg" fill="none"
                 viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M11 19a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm0 0l7 7"></path>
            </svg>
        </div>
        <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600">
            Search
        </button>
    </div>
</form>

@if(!empty($filteredArmyNumbers))
    @if ($type !== 'tr')
        <!-- Show this for EPR or ISR, but NOT TR -->
        <form action="{{ route('report.generateMultiple') }}" method="POST" target="_blank">
            @csrf
            @foreach($filteredArmyNumbers as $number)
                <input type="hidden" name="army_numbers[]" value="{{ $number }}">
            @endforeach

            @if ($type == 'epr')
                <input type="hidden" name="report_type" value="generate">
            @elseif ($type == 'isr')
                <input type="hidden" name="report_type" value="generate2">
            @endif

            <button type="submit"
                    class="mt-3 bg-purple-600 text-white px-4 py-2 rounded hover:bg-purple-700">
                Generate Reports for All Filtered
            </button>
        </form>
    @endif
@endif

<!-- Show this ONLY when type == 'tr' -->
@if($admissions->count() > 0 && $type == 'tr')
    <form action="{{ route('reports.generate.all.transcripts') }}" method="POST" target="_blank" class="mb-4">
        @csrf
        <!-- Pass all current filters -->
        <input type="hidden" name="school_id" value="{{ request('school_id') }}">
        <input type="hidden" name="course_id" value="{{ request('course_id') }}">
        <input type="hidden" name="intake_id" value="{{ request('intake_id') }}">
        <input type="hidden" name="bn" value="{{ request('bn') }}">
        <input type="hidden" name="coy" value="{{ request('coy') }}">
        <input type="hidden" name="pl" value="{{ request('pl') }}">
        <input type="hidden" name="sec" value="{{ request('sec') }}">
        <input type="hidden" name="search" value="{{ request('search') }}">

        <button type="submit"
                class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none"
                 viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z" />
            </svg>
            Print All Transcript Reports ({{ $admissions->total() }})
        </button>
    </form>
@endif



        <!-- Bulk Delete Form -->
        {{-- <form id="bulk-delete-form" action="" method="POST">
            @csrf
             {{-- <div class="flex justify-between items-center mb-4">
               @if(Auth::user()->type == 'admin')
                    <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700" onclick="return confirm('Are you sure you want to delete selected records?');">
                        Bulk Delete
                    </button>
                @endif 
            </div> --}}
            
            <div class="text-sm text-gray-700">
                Showing 
                <span class="font-medium">{{ $admissions->firstItem() ?? 0 }}</span>
                to 
                <span class="font-medium">{{ $admissions->lastItem() ?? 0 }}</span>
                of 
                <span class="font-medium">{{ $admissions->total() }}</span>
                results
            </div>
            <!-- Admissions Table -->
            <div class="bg-white shadow-md rounded-lg overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                
                                <th class="px-6 py-3">#</th> <!-- Serial number column -->
                                <th class="px-6 py-3">
                                    <input type="checkbox" id="select-all" class="select-all-checkbox">
                                </th>
                        

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=admission_id&direction={{ request('direction') == 'asc' ? 'desc' : 'asc' }}">
                                        Admission ID
                                        @if(request('sort') == 'admission_id')
                                            @if(request('direction') == 'asc')
                                                ▲
                                            @else
                                                ▼
                                            @endif
                                        @endif
                                    </a>
                                </th>

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=army_number&direction={{ request('direction') == 'asc' ? 'desc' : 'asc' }}">
                                        Army Number
                                        @if(request('sort') == 'army_number')
                                            @if(request('direction') == 'asc')
                                                ▲
                                            @else
                                                ▼
                                            @endif
                                        @endif
                                    </a>
                                </th>
                                
                                {{-- <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Army Number</th> --}}
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Rank</th>

                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                                    <a href="?sort=name&direction={{ request('direction') == 'asc' ? 'desc' : 'asc' }}">
                                        Cadet Name
                                        @if(request('sort') == 'name')
                                            @if(request('direction') == 'asc')
                                                ▲
                                            @else
                                                ▼
                                            @endif
                                        @endif
                                    </a>
                                </th>
                            
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">School</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Course</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($admissions as $index => $admission)
                            <tr>
                                <!-- Adjusted numbering based on pagination -->
                                <td class="px-6 py-4">{{ $admissions->firstItem() + $index }}</td>
                                <td class="px-6 py-4">
                                    <input type="checkbox" name="selected_ids[]" value="{{ $admission->id }}" class="select-item">
                                </td>
                                <td class="px-6 py-4">{{ $admission->admission_id }}</td>
                                <td class="px-6 py-4">{{ $admission->army_number }}</td>
                                <td class="px-6 py-4">{{ $admission->rank }}</td>
                                <td class="px-6 py-4">{{ $admission->name }}</td>
                                <td class="px-6 py-4">{{ $admission->school->name }}</td>
                                <td class="px-6 py-4">{{ $admission->course->name }}</td>
                       <td class="px-6 py-4">
    <div class="flex flex-col space-y-2">
        <!-- Generate Report Button -->
        @if ($type == 'epr')
            <form action="{{ route('report.generate') }}" method="POST">
                @csrf
                <input type="hidden" name="army_number" value="{{ $admission->army_number }}">
                <button type="submit" class="w-full bg-blue-500 text-white px-3 py-1.5 rounded hover:bg-blue-600 transition-colors flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    Generate EPR
                </button>
            </form>
        @endif

        @if ($type == 'isr')
            <form action="{{ route('report.generate2') }}" method="POST">
                @csrf
                <input type="hidden" name="army_number" value="{{ $admission->army_number }}">
                <button type="submit" class="w-full bg-blue-500 text-white px-3 py-1.5 rounded hover:bg-blue-600 transition-colors flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    Generate ISR
                </button>
            </form>
        @endif

        @if ($type == 'tr')
            <form action="{{ route('report.generate3') }}" method="POST">
                @csrf
                <input type="hidden" name="army_number" value="{{ $admission->army_number }}">
                <button type="submit" class="w-full bg-blue-500 text-white px-3 py-1.5 rounded hover:bg-blue-600 transition-colors flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    Generate TR
                </button>
            </form>
        @endif

        <!-- Add Remarks Button -->
        <a href="{{ route('remarks.create', $admission->id) }}" class="flex items-center justify-center bg-green-500 text-white px-3 py-1.5 rounded hover:bg-green-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
            </svg>
            Add Remarks
        </a>
    </div>
</td>
                                

                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    
                    <!-- Pagination Links -->
                   
                    
                </div>
            </div>
        </form>

        <!-- Pagination -->
    <!-- Pagination -->

 
    <div>
        {{ $admissions->withQueryString()->links() }}
    </div>

    </div>
</div>

<script>
    // Select all checkboxes logic
    document.addEventListener("DOMContentLoaded", function () {
        const selectAllCheckbox = document.getElementById('select-all');
        const rowCheckboxes = document.querySelectorAll('input[type="checkbox"].select-item');

        selectAllCheckbox.addEventListener("change", function () {
            rowCheckboxes.forEach(checkbox => {
                checkbox.checked = selectAllCheckbox.checked;
            });
        });

        rowCheckboxes.forEach(checkbox => {
            checkbox.addEventListener("change", function () {
                if (![...rowCheckboxes].some(chk => chk.checked)) {
                    selectAllCheckbox.checked = false;
                }
            });
        });
    });
</script>

@endsection
