@extends('layouts.app')

@section('content')


<div class="max-w-4xl mx-auto bg-white shadow-md rounded-lg p-6 mt-6">
    <h2 class="text-2xl font-bold mb-4 text-gray-800">Create Admission</h2>
   {{-- Display All Validation Errors at the Top --}}

   @if (session('success'))
   <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
       <span class="block sm:inline">{{ session('success') }}</span>
   </div>
@endif

@if (session('error'))
   <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
       <span class="block sm:inline">{{ session('error') }}</span>
   </div>
@endif

@if ($errors->any())
   <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative">
       <ul class="list-disc list-inside">
           @foreach ($errors->all() as $error)
               <li>{{ $error }}</li>
           @endforeach
       </ul>
   </div>
@endif

    <form action="{{ route('admissions.store') }}" method="POST" enctype="multipart/form-data" class="space-y-8">
        @csrf

        <!-- Military Information -->
   <!-- Military Information -->
<div class="bg-gray-50 p-6 rounded-lg">
    <h2 class="text-xl font-bold mb-4">Military Information</h2>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <!-- Army Number Search -->
        <div>
            <label class="block font-semibold">Search Army Number <span class="text-red-500">*</span></label>
            <div class="flex space-x-2">
                <input type="text"
                       class="w-full border-gray-300 rounded-lg shadow-sm focus:ring focus:ring-blue-300 p-2"
                       id="ArmyNumber"
                       name="search_army_number"
                       placeholder="Enter army number to search">
                <button type="button" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600" onclick="searchArmyNumber2()">Search</button>
            </div>
        </div>

        <!-- Actual Army Number Field (hidden initially or readonly) -->
        <div>
            <label for="army_number" class="block text-sm font-medium text-gray-700">Army Number <span class="text-red-500">*</span></label>
            <input type="text" 
                   class="w-full border-gray-300 rounded-lg shadow-sm p-2 bg-gray-100" 
                   id="army_number" 
                   name="army_number" 
                   required
                   readonly>
        </div>

        <div>
            <label for="name" class="block text-sm font-medium text-gray-700">Name</label>
            <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" id="name" name="name" readonly>
        </div>
        
        <!-- Rest of your existing fields... -->
    </div>
</div>

        <div class="mb-4">
            <input type="hidden" name="is_non_ugandan" id="isNonUgandan" value="NO">
        </div>



        <!-- Section 2: Academic Information -->
        <div class="bg-gray-50 p-6 rounded-lg shadow-sm">
            <h2 class="text-xl font-bold mb-4 text-gray-800">Academic Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                <!-- School Dropdown -->
                <div class="space-y-2">
                    <label class="block font-semibold text-gray-700">
                        School <span class="text-red-500">*</span>
                    </label>
                    <select class="w-full border-gray-300 rounded-lg shadow-sm p-2 focus:ring-2 focus:ring-blue-500"
                            name="school_id"
                            id="school_id"
                            required>
                        <option value="">Select School</option>
                        @foreach($schools as $school)
                            <option value="{{ $school->id }}"
                                    {{ $school->name === 'BMTS' ? 'selected' : '' }}>
                                {{ $school->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <!-- Course Dropdown -->
                <div class="space-y-2">
                    <label class="block font-semibold text-gray-700">
                        Course <span class="text-red-500">*</span>
                    </label>
                    <select class="w-full border-gray-300 rounded-lg shadow-sm p-2 focus:ring-2 focus:ring-blue-500"
                            name="course_id"
                            id="course_id"
                            required
                            onchange="fetchSubjects()">
                        <option value="">Select Course</option>
                        @foreach($courses as $course)
                            <option value="{{ $course->id }}"
                                    {{ $course->name === 'O/CDT' ? 'selected' : '' }}>
                                {{ $course->name }}
                            </option>
                        @endforeach
                    </select>
                    <div id="course-loading" class="hidden text-sm text-gray-500">
                        Loading courses...
                    </div>
                </div>

                <!-- Subjects Multi-Select -->
          <!-- Subjects Multi-Select -->
<div class="space-y-2">


    <label class="block font-semibold text-gray-700">
        Subjects <span class="text-red-500">*</span>
    </label>
    <select class="w-full border-gray-300 rounded-lg shadow-sm p-2 focus:ring-2 focus:ring-blue-500"
            name="subjects[]"
            id="subjects"
            multiple
            required
            size="4">
        <option value="" disabled>Select Course First</option>
    </select>

</div>

                <!-- Intake Dropdown -->
                <div class="space-y-2">
                    <label class="block font-semibold text-gray-700">
                        Intake <span class="text-red-500">*</span>
                    </label>
                    <select class="w-full border-gray-300 rounded-lg shadow-sm p-2 focus:ring-2 focus:ring-blue-500"
                            name="intake_id"
                            id="intake_id"
                            required>
                        <option value="">Select Intake</option>
                        @foreach($intakes as $intake)
                            <option value="{{ $intake->id }}"
                                    {{ $intake->year === '19/25' ? 'selected' : '' }}>
                                {{ $intake->year }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <!-- Loading & Error States -->
            <div id="academic-error" class="hidden mt-4 p-4 rounded-lg bg-red-50 text-red-600">
            </div>
        </div>
<div class="bg-gray-50 p-6 rounded-lg">
    <h2 class="text-xl font-bold mb-4">Groupings</h2>
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mt-4">
        <!-- Bn -->
        <div>
            <label class="block font-semibold">Bn <span class="text-red-500"></span></label>
            <select name="bn" class="w-full border-gray-300 rounded-lg p-2">
                <option value="">Select Bn</option>
                @foreach($bn as $bns)
                    <option value="{{ $bns }}">{{ $bns }}</option>
                @endforeach
            </select>
        </div>

        <!-- Coy -->
        <div>
            <label class="block font-semibold">Coy <span class="text-red-500"></span></label>
            <select name="coy" class="w-full border-gray-300 rounded-lg p-2">
                <option value="">Select Coy</option>
                @foreach($coy as $coys)
                    <option value="{{ $coys }}">{{ $coys }}</option>
                @endforeach
            </select>
        </div>

        <!-- Pl (static: 1, 2, 3) -->
        <div>
            <label class="block font-semibold">Pl <span class="text-red-500"></span></label>
            <select name="pl" class="w-full border-gray-300 rounded-lg p-2">
                <option value="">Select Pl</option>
                @foreach(['1', '2', '3'] as $pls)
                    <option value="{{ $pls }}">{{ $pls }}</option>
                @endforeach
            </select>
        </div>

        <!-- Sec (static: I, II, III) -->
        <div>
            <label class="block font-semibold">Sec <span class="text-red-500"></span></label>
            <select name="sec" class="w-full border-gray-300 rounded-lg p-2">
                <option value="">Select Sec</option>
                @foreach(['I', 'II', 'III'] as $secs)
                    <option value="{{ $secs }}">{{ $secs }}</option>
                @endforeach
            </select>
        </div>
    </div>
</div>



        <!-- Personal Information -->
        <div class="bg-gray-50 p-6 rounded-lg">
            <h2 class="text-xl font-bold mb-4">Personal Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block font-semibold">Email</label>
                    <input type="email" name="email"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Phone <span class="text-red-500"></span></label>
                    <input type="text" name="phone_number"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Home District</label>
                    <input type="text" name="home_district"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-4">
                <div>
                    <label class="block font-semibold">Village</label>
                    <input type="text" name="village"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Next of Kin</label>
                    <input type="text" name="next_kin"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Next of Kin Phone</label>
                    <input type="text" name="next_kin_phone"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Next of Kin Relationship</label>
                    <input type="text" name="next_kin_rel"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Sex <span class="text-red-500">*</span></label>
                    <select name="sex" class="w-full border-gray-300 rounded-lg p-2" required>
                        <option value="">Select Sex</option>
                        <option value="M">M</option>
                        <option value="F">F</option>
                    </select>
                </div>
                <div>
                    <label for="nin" class="block text-sm font-medium text-gray-700">NIN</label>
                    <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" id="nin" name="nin">
                </div>

{{-- country_origin --}}
                <div>
                    <label class="block font-semibold">Country of Origin</label>
                    <input type="text" name="country_origin"  class="w-full border-gray-300 rounded-lg p-2">
                </div>

            </div>
        </div>

        <!-- Family Information -->
        <div class="bg-gray-50 p-6 rounded-lg">
            <h2 class="text-xl font-bold mb-4">Family Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block font-semibold">Father's Name</label>
                    <input type="text" name="father_name"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Father's Phone</label>
                    <input type="text" name="father_phone"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Mother's Name</label>
                    <input type="text" name="mother_name"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Mother's Phone</label>
                    <input type="text" name="mother_phone" class="w-full border-gray-300 rounded-lg p-2">
                </div>
            </div>
        </div>

        <!-- Additional Information -->
        <div class="bg-gray-50 p-6 rounded-lg">
            <h2 class="text-xl font-bold mb-4">Additional Information</h2>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label class="block font-semibold">Education Level</label>
                    <input type="text" name="education_level"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Spouse Name</label>
                    <input type="text" name="spouse_name" class="w-full border-gray-300 rounded-lg p-2">
                </div>
                <div>
                    <label class="block font-semibold">Spouse Phone</label>
                    <input type="text" name="spouse_phone"  class="w-full border-gray-300 rounded-lg p-2">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-4">
                <div>
                    <label for="shoe_size" class="block text-sm font-medium text-gray-700">Shoe Size</label>
                    <input type="text" class="w-full border-gray-300 rounded-lg shadow-sm p-2" id="shoe_size" name="shoe_size">
                </div>

            </div>
        </div>

        <!-- Submit Button -->
        <button type="submit" class="w-full bg-green-500 text-white py-3 px-4 rounded-lg hover:bg-green-600 font-semibold">
           Create Admission
        </button>
    </form>

</div>

<script>
    const MESSAGES = {
           ARMY_NUMBER_REQUIRED: "Please enter an Army Number",
           ARMY_NUMBER_NOT_FOUND: "Army Number not found in the system",
           NETWORK_ERROR: "Network error occurred. Please check your connection and try again",
           GENERAL_ERROR: "An error occurred. Please try again",
           SELECT_COURSE: "Please select a course first",
           NO_SUBJECTS: "No subjects available for this course",
           LOADING: "Loading..."
       };
   // Add this to your existing script section
function previewImage(event) {
    const input = event.target;
    const preview = document.getElementById('imagePreview');
    const previewImg = preview.querySelector('img');

    if (input.files && input.files[0]) {
        const reader = new FileReader();

        reader.onload = function(e) {
            previewImg.src = e.target.result;
            preview.classList.remove('hidden');
        }

        reader.readAsDataURL(input.files[0]);

        // Validate file size (2MB max)
        const fileSize = input.files[0].size / 1024 / 1024; // in MB
        if (fileSize > 2) {
            alert('File size exceeds 2MB. Please choose a smaller file.');
            input.value = ''; // Clear the input
            preview.classList.add('hidden');
            return;
        }

        // Validate file type
        const fileType = input.files[0].type;
        const validImageTypes = ['image/jpeg', 'image/png', 'image/jpg'];
        if (!validImageTypes.includes(fileType)) {
            alert('Please select a valid image file (JPEG, PNG, or JPG)');
            input.value = ''; // Clear the input
            preview.classList.add('hidden');
            return;
        }
    } else {
        preview.classList.add('hidden');
    }
}
       // Update the searchArmyNumber2 function
       function searchArmyNumber2() {
    const armyNumberInput = document.getElementById('ArmyNumber');

    if (!armyNumberInput.value.trim()) {
        showAlert(MESSAGES.ARMY_NUMBER_REQUIRED);
        return;
    }

    fetch("{{ route('searchArmyNumber2') }}", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            "Accept": "application/json"
        },
        body: JSON.stringify({
            army_number: armyNumberInput.value.trim()
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.message) {
            showError(data.message);
            clearForm();
            return;
        }

        // Populate basic fields
        document.getElementById('name').value = data.Student_Name || '';
        document.getElementById('rank').value = data.Rank || 'O/CDT';

        document.querySelector('input[name="education_level"]').value = data.LEVEL_OF_EDUCATION || '';
        document.getElementById('nin').value = data.NIN || '';
        document.querySelector('select[name="sex"]').value = data.SEX || '';
        document.querySelector('select[name="bn"]').value = data.BN || 'Kagera';
        document.querySelector('select[name="coy"]').value = data.COY || '';
        document.querySelector('select[name="pl"]').value = data.PL || '';
        document.querySelector('select[name="sec"]').value = data.SEC || '';
        document.querySelector('input[name="home_district"]').value = data.DISTRICT || '';
        document.querySelector('input[name="village"]').value = data.VILLAGE || '';
        document.querySelector('input[name="father_name"]').value = data.FATHER_S_NAME || '';
        document.querySelector('input[name="next_kin"]').value = data.NOK || '';
        document.querySelector('input[name="father_phone"]').value = data.NOK_TEL || '';
        document.getElementById('shoe_size').value = data.SHOES_SIZE || '';

        // Handle sex selection
        const sexSelect = document.querySelector('select[name="sex"]');
    if (sexSelect && data.SEX) {
        // Normalize the sex value
        const sexValue = data.SEX.toUpperCase().trim();
        if (sexValue === 'M' || sexValue === 'F') {
            sexSelect.value = sexValue;
        } else {
            console.warn('Invalid sex value received:', data.SEX);
            sexSelect.value = ''; // Reset to default if invalid
        }
    }


        // Automatically handle non-Ugandan status
        const isNonUgandan = data.NON_UGANDAN === 'YES';
        const nonUgandanFields = document.getElementById('nonUgandanFields');
        const ugandanFields = document.getElementById('ugandanFields');
        const hiddenInput = document.getElementById('isNonUgandan');

        // Set the hidden input value
        hiddenInput.value = isNonUgandan ? "YES" : "NO";

        // Toggle fields visibility
        nonUgandanFields.classList.toggle('hidden', !isNonUgandan);
        ugandanFields.classList.toggle('hidden', isNonUgandan);

        if (isNonUgandan) {
            // Populate non-Ugandan specific fields
            document.getElementById('country_origin').value = data.COUNTRY_ORIGIN || '';
            document.getElementById('military_id').value = data.MIL_ID_No || '';
        } else {
            // Clear non-Ugandan specific fields if switching back to Ugandan
            document.getElementById('country_origin').value = '';
            document.getElementById('military_id').value = '';
        }

        // Populate remaining fields


        showSuccess('Record found and form populated successfully');
    })
    .catch(error => {
         console.error('Search failed:', error);
        // showError(MESSAGES.NETWORK_ERROR);
    });
}

   // Add this to your existing JavaScript
   document.addEventListener('DOMContentLoaded', function() {
       const nonUgandanToggle = document.getElementById('nonUgandanToggle');
       const ugandanFields = document.getElementById('ugandanFields');
       const nonUgandanFields = document.getElementById('nonUgandanFields');
       const isNonUgandan = document.getElementById('isNonUgandan');
       const armyNumberInput = document.getElementById('ArmyNumber');
       const decommissionButton = document.getElementById('decommissionButton');
       const decommissionSection = document.getElementById('decommissionSection');

       if (nonUgandanToggle) {
           nonUgandanToggle.addEventListener('change', function() {
               ugandanFields.classList.toggle('hidden');
               nonUgandanFields.classList.toggle('hidden');
               isNonUgandan.value = this.checked ? "YES" : "NO";

               // Toggle required attribute for Army Number
               if (this.checked) {
                   armyNumberInput.removeAttribute('required');
               } else {
                   armyNumberInput.setAttribute('required', 'required');
               }
           });
       }

       if (decommissionButton && decommissionSection) {
           decommissionButton.addEventListener('click', function() {
               decommissionSection.classList.toggle('hidden');
           });
       }

       const schoolSelect = document.querySelector('select[name="school_id"]');
       if (schoolSelect) {
           schoolSelect.addEventListener('change', function() {
               const courseSelect = document.getElementById('course_id');
               if (courseSelect) {
                   courseSelect.innerHTML = '<option value="">Select Course</option>';
                   fetchSubjects(); // Clear subjects when school changes
               }
           });
       }
   });

   // Utility function to show alerts
   function showAlert(message, type = 'error') {
       // You can replace this with a better UI notification system
       if (type === 'error') {
           alert(message);
       }
   }

   // Utility function to show error messages
   function showError(message) {
       showAlert(message, 'error');
   }

   // Utility function to show success messages
   function showSuccess(message) {
       showAlert(message, 'success');
   }

   // Utility function to clear the form
   function clearForm() {
       const form = document.querySelector('form');
       if (form) {
           const inputs = form.querySelectorAll('input:not([type="hidden"]), select');
           inputs.forEach(input => {
               if (input.type === 'select-one') {
                   input.selectedIndex = 0;
               } else {
                   input.value = '';
               }
           });
       }
   }

   // Fetch subjects when course changes
// Update the fetchSubjects function in your script section
function fetchSubjects() {
    const courseId = document.getElementById('course_id').value;
    const subjectsSelect = document.getElementById('subjects');

    if (!courseId || !subjectsSelect) return;

    // Show loading state
    subjectsSelect.innerHTML = '<option value="" disabled>Loading subjects...</option>';
    subjectsSelect.disabled = true;

    fetch(`{{ url('/get-subjects') }}/${courseId}`)
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(subjects => {
            subjectsSelect.innerHTML = ''; // Clear existing options

            if (subjects.length === 0) {
                subjectsSelect.innerHTML = '<option value="" disabled>No subjects available</option>';
                return;
            }

            subjects.forEach(subject => {
                if (subject.id) { // Ensure subject.id exists
                    const option = new Option(subject.name, subject.id);
                    subjectsSelect.add(option);
                }
            });
        })
        .catch(error => {
            console.error('Error loading subjects:', error);
            subjectsSelect.innerHTML = '<option value="" disabled>Error loading subjects</option>';
        })
        .finally(() => {
            subjectsSelect.disabled = false;
        });
}

   // Add event listener when the page loads
   document.addEventListener('DOMContentLoaded', function() {
       const courseSelect = document.getElementById('course_id');
       if (courseSelect) {
           courseSelect.addEventListener('change', fetchSubjects);
       }
   });
   </script>
@endsection



