<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admissions List</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 20px;
            padding: 0;
            background-color: #f8f9fa;
            color: #333;
        }
        .container {
            max-width: 1200px;
            margin: auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        .header {
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #007bff;
        }
        .logo {
            display: block;
            margin: 0 auto;
            width: 100px; /* Adjust the size as needed */
        }
        .header h2 {
            margin-top: 10px;
            color: #007bff;
        }
        .date {
            text-align: right;
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }
        .filters {
            background: #e9ecef;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
            text-align: left;
        }
        .filters h4 {
            margin-top: 0;
            color: #333;
        }
        .filters ul {
            padding-left: 20px;
            margin: 0;
        }
        .filters li {
            font-size: 14px;
            color: #555;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            margin-top: 10px;
        }
        th, td {
            padding: 12px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background: #007bff;
            color: #fff;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background: #f2f2f2;
        }
        tr:hover {
            background: #dfe6f1;
        }
        .total {
            margin-top: 15px;
            font-size: 16px;
            font-weight: bold;
            text-align: right;
        }
    </style>
</head>
<body>

    <div class="container">
        <div class="header">
            <img src="path/to/logo.png" alt="Logo" class="logo">
            <h2>Admissions List</h2>
        </div>
        <div class="date">Generated on: {{ date('Y-m-d H:i:s') }}</div>

        @if(!empty($filters))
        <div class="filters">
            <h4>Applied Filters:</h4>
            <ul>
                @if(!empty($filters['school_id']))
                    <li><strong>School:</strong> {{ App\Models\School::find($filters['school_id'])->name }}</li>
                @endif
                @if(!empty($filters['course_id']))
                    <li><strong>Course:</strong> {{ App\Models\Course::find($filters['course_id'])->name }}</li>
                @endif
                @if(!empty($filters['bn']))
                    <li><strong>Bn:</strong> {{ $filters['bn'] }}</li>
                @endif
                @if(!empty($filters['coy']))
                    <li><strong>Coy:</strong> {{ $filters['coy'] }}</li>
                @endif
                @if(!empty($filters['pl']))
                    <li><strong>Pl:</strong> {{ $filters['pl'] }}</li>
                @endif
                @if(!empty($filters['sec']))
                    <li><strong>Sec:</strong> {{ $filters['sec'] }}</li>
                @endif
                @if(!empty($filters['search']))
                    <li><strong>Search:</strong> {{ $filters['search'] }}</li>
                @endif
            </ul>
        </div>
        @endif

        <table>
            <thead>
                <tr>
                    <th>Admission ID</th>
                    <th>Army Number</th>
                    <th>Rank</th>
                    <th>Name</th>
                    <th>School</th>
                    <th>Course</th>
                    <th>Bn</th>
                    <th>Coy</th>
                    <th>Pl</th>
                    <th>Sec</th>
                </tr>
            </thead>
            <tbody>
                @foreach($admissions as $admission)
                <tr>
                    <td>{{ $admission->admission_id }}</td>
                    <td>{{ $admission->army_number }}</td>
                    <td>{{ $admission->rank }}</td>
                    <td>{{ $admission->name }}</td>
                    <td>{{ $admission->school->name }}</td>
                    <td>{{ $admission->course->name }}</td>
                    <td>{{ $admission->bn }}</td>
                    <td>{{ $admission->coy }}</td>
                    <td>{{ $admission->pl }}</td>
                    <td>{{ $admission->sec }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="total">Total Records: {{ $admissions->count() }}</div>
    </div>

</body>
</html>
