<!DOCTYPE html>
<html>
<head>
    <title>22CR Report</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            margin: 50px 30px;
            color: #333;
        }

        header, footer {
            position: fixed;
            left: 0;
            right: 0;
            color: #555;
            text-align: center;
            font-size: 14px;
        }

        header {
            top: -30px;
        }

        footer {
            bottom: -30px;
        }

        .restricted {
            color: rgb(0, 0, 0);
            font-weight: bold;
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 30px;
        }

        th, td {
            padding: 8px;
            border: 1px solid #ccc;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

    </style>
</head>
<body>

    <!-- Header -->
    <header>
       
        <div class="restricted">RESTRICTED</div>
    </header>

    <!-- Footer -->
    <footer>
        <div class="restricted">RESTRICTED</div>
    </footer>

    <!-- Main content -->
    <h2>22CR Cadets Assessment Report</h2>

    <div style="margin-bottom: 10px; text-align: center;">

        <strong>BN:</strong> {{ $bn ?? '-' }} &nbsp; | &nbsp;
        <strong>COY:</strong> {{ $coys ?? '-' }} &nbsp; | &nbsp;
        <strong>PL:</strong> {{ $platoon ?? '-' }}
    </div>

    <table>
        <thead>
            <tr>
                <th>SN</th>
                <th>Army Number</th>
                <th>Rank</th>
                <th>Cadet Name</th>
                {{-- <th>Phase</th> --}}
                <th>22CR Score</th>
            </tr>
        </thead>
        <tbody>
            @php $cadetCounter = 1; @endphp
            @foreach($assessments as $armyNumber => $armyAssessments)
                @foreach($armyAssessments as $index => $assessment)
                    <tr>
                        @if($index === 0)
                            <td rowspan="{{ count($armyAssessments) }}">{{ $cadetCounter }}</td>
                            <td rowspan="{{ count($armyAssessments) }}">{{ $armyNumber }}</td>
                            <td rowspan="{{ count($armyAssessments) }}">O/CDT</td>
                            <td rowspan="{{ count($armyAssessments) }}">{{ $assessment->name }}</td>
                            @php $cadetCounter++; @endphp
                        @endif
                 
                        <td>
                            @php
                                $totalCRES = 0;
                                foreach($assessment->assessmentDetails as $detail) {
                                    $f = $detail->f1 + $detail->f2 + $detail->f3 + $detail->f4 + $detail->f5;
                                    $fx = ($detail->f1 * 1) + ($detail->f2 * 2) + ($detail->f3 * 3) +
                                          ($detail->f4 * 4) + ($detail->f5 * 5);
                                    if ($f > 0) {
                                        $individualCRES = ($fx / $f) * $detail->twentyTwoCR->weight;
                                        $totalCRES += $individualCRES;
                                    }
                                }
                                $score = number_format(($totalCRES / 720) * 20, 2);
                            @endphp
                            {{ $score }}
                        </td>
                    </tr>
                @endforeach
            @endforeach
        </tbody>
    </table>

</body>
</html>
