#  Reports & Performance Reviews

The **Reports Module** in START provides key performance analytics and printable summaries for cadets across various schools, courses, and phases. It supports operational oversight and academic transparency by generating structured, filterable reports.

---

##  Available Report Types

### 1.  End of Phase Report (EPR)

![Performance Filters](/images/end-of-phase.png)

Provides a full overview of cadet performance at the end of a training **Phase**, including academic, practical, 22CR, and PR metrics.

####  Filters:

- **School**
- **Course**
- **Intake**
- **Phase**
- **Bn / Coy / Pl / Sec**
- **Army Number or Name (Search)**

####  Actions:

- `Generate EPR` – Creates a formal printable report for the cadet.
- `Add Remarks` – Allows instructors to input narrative feedback or performance notes.

>  You can generate reports for **individual cadets** or **all filtered results** in batch.

---

### 2.  Individual Summary Report

![Performance Filters](/images/in.png)

Delivers a detailed summary of a cadet's complete training lifecycle, showing scores and progression across multiple phases, subjects, and practicals.

- Includes:
  - Subject-wise scores
  - Attendance (if available)
  - Cumulative GPA or pass/fail results
  - Remarks or disciplinary notes

### 🛠️ How to Use:

1. Navigate to **Reports** > **Individual Summary**
2. Search using:
   - **Army Number**
   - **School**, **Course**, **Phase**
3. Click **"Generate Summary"**

---

### 3. 📈 General Performance Review (GPV)

![Performance Filters](/images/report-filters.png)

A **summary of overall trainee performance** across **all phases**, filtered by course, grade, or structure.

#### 📍 Filters:

- **School**
- **Course**
- **Intake**
- **Phase**
- **Grade**
- **Bn / Coy / Pl**
- **Army Number / Name (Search)**
- **Records Per Page** (default: 25)

#### 🛠️ Actions:

- `Apply Filters` – View summary table based on selected filters.
- `Reset` – Clear all filters.
- `Export` – Download filtered data in Excel or PDF formats.

> 🔁 These reports help commanders and training staff make data-informed decisions regarding cadet progression and instructional improvements.

---

## 🧮 Example: Filtered GPV Table

| # | Army Number | Name           | Course   | Phase    | Grade | Status   | Actions       |
|---|-------------|----------------|----------|----------|-------|----------|----------------|
| 1 | RA/233671   | NAKIYUKA MOREEN| O/CDT    | Phase 2  | B+    | Passed   | View Report    |
| 2 | R0/00000    | MWANIKA HUDSON| O/CDT    | Phase 2  | A     | Passed   | View Report    |

---



simples of reports
![End of Phase Report](/images/report-epr-table.png)
![Generate Individual Summary](/images/summary-form.png)

