#  Assessment Module

The **Assessment Module** in START provides detailed insights into cadet academic, behavioral, and performance-based evaluations across weeks, phases, and training categories. It is designed to support instructors, commandants, and administrators in tracking learning progress, managing assessment data, and generating exportable reports.

---

##  Marks Overview
![Weekly Marks Overview](/images/marks.png)

Monitor and evaluate cadet academic performance across **weekly assessments**, **monthly evaluations**, or **end-of-phase exams**.

###  Filters & Options:

- **Assessment Type**: Theory / MSK / Practical
- **Week Selector**: Choose specific week(s)
- **Course**: e.g., Kagera
- **Class/Grade**: e.g., A
- **Search**: Army Number / Cadet Name / Rank

> ✅ Data can be **exported to PDF** for record-keeping and reporting.

### 📑 Example Table Layout:

| Army Number | Rank  | Cadet Name     | Week 1 | Week 2 | Week 3 | ... | Actions |
|-------------|-------|----------------|--------|--------|--------|-----|---------|
| RA/230848   | O/CDT | OKELLO RONALD  | 67.0%  | 57.0%  | -      | ... | View     |
| RA/232341   | O/CDT | BANGI JALIA    | 36.0%  | 64.0%  | -      | ... | View     |
| RA/232555   | O/CDT | DONGO HAMISI   | 35.0%  | 25.0%  | -      | ... | View     |

> 📈 Arrows ↑ ↓ may represent performance trends across weeks.

---

## 🧾 22CR Overview

![Weekly Marks Overview](/images/22cr-view.png)

This section provides a summarized view of cadet performance in **22CR behavioral metrics** (Discipline, Leadership, Punctuality, etc.).

###  Filter Options:

- **School**
- **Course**
- **Battalion**
- **Company**
- **Platoon**
- **Sort Direction** (Default, Ascending, Descending)

>  Results can be **exported to PDF** for offline analysis or printed for record-keeping.

---

##  PR List – Performance Rating Summary
![Weekly Marks Overview](/images/pr.png)
Provides a breakdown of cadet **PR scores** (Performance Ratings), based on multiple raters. Each score includes individual ratings, a sum, mean, and calculated percentage.

### 📍 Filters:

- **Battalion**
- **Company**
- **Platoon**

### 📑 Table Format:

| # | Army No     | Name           | Rank  | Scores | Raters | Sum | Mean | PR %  |
|---|-------------|----------------|-------|--------|--------|-----|------|-------|
| 1 | RA/230848   | OKELLO RONALD  | O/CDT | 6      | 2      | 12  | 2.4  | 3.9%  |
| 2 | RA/232341   | BANGI JALIA    | O/CDT | 2      | 3      | 8   | 1.6  | 2.8%  |
| 3 | RA/232555   | DONGO HAMISI   | O/CDT | 3      | 4      | 11  | 2.2  | 3.6%  |

> 📉 Low PR percentages may flag cadets needing attention in performance areas.

---

## 📤 Export & Print Options

All assessment categories support:

- ✅ PDF Export
- ✅ Table Sorting
- ✅ Filter Reset
- ✅ Printable Views

These ensure that START assessments can easily support administrative workflows and documentation.

---

## 🧭 Purpose of the Assessment Module

- Enable **real-time academic monitoring**
- Support **instructor-led evaluations**
- Offer commanders **behavioral performance snapshots**
- Help cadets understand and improve performance over time

---
