<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create permissions
        Permission::create(['name' => 'view users']);
        Permission::create(['name' => 'create users']);
        Permission::create(['name' => 'edit users']);
        Permission::create(['name' => 'delete users']);
        Permission::create(['name' => 'view entries']);
        Permission::create(['name' => 'create entries']);
        Permission::create(['name' => 'edit entries']);
        Permission::create(['name' => 'delete entries']);

        // Create roles and assign permissions
        $admin = Role::create(['name' => 'admin']);
        $admin->givePermissionTo(Permission::all());

        $dataEntryClerk = Role::create(['name' => 'data_entry_clerk']);
        $dataEntryClerk->givePermissionTo([
            'view entries',
            'create entries',
            'edit entries'
        ]);
    }
}
