<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('remark_templates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('phase_id')->constrained()->onDelete('cascade');
            $table->string('grade', 1); // A, B, C, D, E, F
            $table->enum('type', ['ci', 'comdt']); // CI or Commandant
            $table->text('remark_text');
            $table->timestamps();

            $table->unique(['phase_id', 'grade', 'type']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('remark_templates');
    }
};