<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNonUgandanAndDecommissionFieldsToAdmissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('admissions', function (Blueprint $table) {
            // Non-Ugandan fields
            $table->boolean('is_non_ugandan')->default(false);
            $table->string('country_origin')->nullable();
            $table->string('military_id')->nullable();
            
            // Decommission fields
            $table->date('decommission_date')->nullable();
            $table->string('decommission_reason')->nullable();
            $table->text('decommission_notes')->nullable();
            $table->boolean('is_decommissioned')->default(false);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('admissions', function (Blueprint $table) {
            $table->dropColumn([
                'is_non_ugandan',
                'country_origin',
                'military_id',
                'decommission_date',
                'decommission_reason',
                'decommission_notes',
                'is_decommissioned'
            ]);
        });
    }
}
