<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentPerformancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_performances', function (Blueprint $table) {
            $table->id();
            $table->string('army_number')->unique();
            $table->string('name');
            $table->decimal('msk_theory', 5, 2);
            $table->decimal('msk_practical', 5, 2);
            $table->decimal('character_assessment_22cr', 5, 2);
            $table->decimal('character_assessment_pr', 5, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_performances');
    }
}
